/*
 * Decompiled with CFR 0.152.
 */
package com.chess.chessboard;

import com.chess.chessboard.ChessGame;
import com.chess.chessboard.Piece;

public class ChessLogic {
    public static boolean validateMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl) {
        boolean bl2 = false;
        if (n >= 0 && n <= 7 && n2 >= 0 && n2 <= 7) {
            switch (piece.type) {
                case 'P': 
                case 'p': {
                    bl2 = ChessLogic.validatePawnMove(chessGame, piece, n, n2, false, bl);
                    break;
                }
                case 'R': 
                case 'r': {
                    bl2 = ChessLogic.validateRookMove(chessGame, piece, n, n2, false, bl);
                    break;
                }
                case 'B': 
                case 'b': {
                    bl2 = ChessLogic.validateBishopMove(chessGame, piece, n, n2, false, bl);
                    break;
                }
                case 'N': 
                case 'n': {
                    bl2 = ChessLogic.validateKnightMove(chessGame, piece, n, n2, false, bl);
                    break;
                }
                case 'Q': 
                case 'q': {
                    bl2 = ChessLogic.validateQueenMove(chessGame, piece, n, n2, false, bl);
                    break;
                }
                case 'K': 
                case 'k': {
                    bl2 = ChessLogic.validateKingMove(chessGame, piece, n, n2, false, bl);
                }
            }
            System.out.println("BC" + bl2);
            if (bl2) {
                int n3 = piece.x;
                int n4 = piece.y;
                piece.x = n;
                piece.y = n2;
                bl2 = ChessLogic.validateCheck(chessGame, n3, n4, bl);
                piece.x = n3;
                piece.y = n4;
            }
            System.out.println("AC" + bl2);
        }
        return bl2;
    }

    private static boolean validateRookMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (n == piece.x) {
            if (n2 > piece.y) {
                boolean bl4 = true;
                for (int i = piece.y + 1; i < n2; ++i) {
                    if (chessGame.getPieceIdAt(n, i) == -1) continue;
                    bl4 = false;
                    break;
                }
                if (bl4) {
                    bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                }
            } else if (n2 < piece.y) {
                boolean bl5 = true;
                for (int i = piece.y - 1; i > n2; --i) {
                    if (chessGame.getPieceIdAt(n, i) == -1) continue;
                    bl5 = false;
                    break;
                }
                if (bl5) {
                    bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                }
            }
        } else if (n2 == piece.y) {
            if (n > piece.x) {
                boolean bl6 = true;
                for (int i = piece.x + 1; i < n; ++i) {
                    if (chessGame.getPieceIdAt(i, n2) == -1) continue;
                    bl6 = false;
                    break;
                }
                if (bl6) {
                    bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                }
            } else if (n < piece.x) {
                boolean bl7 = true;
                for (int i = piece.x - 1; i > n; --i) {
                    if (chessGame.getPieceIdAt(i, n2) == -1) continue;
                    bl7 = false;
                    break;
                }
                if (bl7) {
                    bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                }
            }
        }
        return bl3;
    }

    private static boolean validateBishopMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (Math.abs(n - piece.x) == Math.abs(n2 - piece.y)) {
            if (n > piece.x) {
                if (n2 > piece.y) {
                    boolean bl4 = true;
                    int n3 = piece.x + 1;
                    for (int i = piece.y + 1; i < n2; ++i) {
                        if (chessGame.getPieceIdAt(n3, i) != -1) {
                            bl4 = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl4) {
                        bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                    }
                } else if (n2 < piece.y) {
                    boolean bl5 = true;
                    int n4 = piece.x + 1;
                    for (int i = piece.y - 1; i > n2; --i) {
                        if (chessGame.getPieceIdAt(n4, i) != -1) {
                            bl5 = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl5) {
                        bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                    }
                }
            } else if (n < piece.x) {
                if (n2 > piece.y) {
                    boolean bl6 = true;
                    int n5 = piece.x - 1;
                    for (int i = piece.y + 1; i < n2; ++i) {
                        if (chessGame.getPieceIdAt(n5, i) != -1) {
                            bl6 = false;
                            break;
                        }
                        --n5;
                    }
                    if (bl6) {
                        bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                    }
                } else if (n2 < piece.y) {
                    boolean bl7 = true;
                    int n6 = piece.x - 1;
                    for (int i = piece.y - 1; i > n2; --i) {
                        if (chessGame.getPieceIdAt(n6, i) != -1) {
                            bl7 = false;
                            break;
                        }
                        --n6;
                    }
                    if (bl7) {
                        bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
                    }
                }
            }
        }
        return bl3;
    }

    private static boolean validateKnightMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (Math.abs(n - piece.x) == 1 && Math.abs(n2 - piece.y) == 2 || Math.abs(n - piece.x) == 2 && Math.abs(n2 - piece.y) == 1) {
            bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
        }
        return bl3;
    }

    private static boolean validateQueenMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (n == piece.x || n2 == piece.y) {
            bl3 = ChessLogic.validateRookMove(chessGame, piece, n, n2, bl, bl2);
        } else if (Math.abs(n - piece.x) == Math.abs(n2 - piece.y)) {
            bl3 = ChessLogic.validateBishopMove(chessGame, piece, n, n2, bl, bl2);
        }
        return bl3;
    }

    private static boolean validateKingMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n3 = chessGame.getPieceIdAt(n, n2);
        if (chessGame.chess960 && n3 != -1 && chessGame.pieces[n3].isRook() && bl2 ^ !chessGame.pieceIdBelongToPlayer(n3) && (piece.y == 7 || piece.y == 0) && Math.abs(n2 - piece.y) == 0) {
            bl3 = ChessLogic.validate960Castling(chessGame, piece, n3, n, n2, bl, bl2);
        } else if (Math.abs(n - piece.x) >= 0 && Math.abs(n - piece.x) <= 1 && Math.abs(n2 - piece.y) >= 0 && Math.abs(n2 - piece.y) <= 1) {
            bl3 = bl ? true : ChessLogic.validateTarget(chessGame, n, n2, bl2);
        } else if (!(chessGame.chess960 || Math.abs(n - piece.x) != 2 || n2 != piece.y || piece.y != 7 && piece.y != 0)) {
            String string = "H";
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n < piece.x) {
                string = !(bl2 ^ chessGame.playAsWhite) ? (piece.y == 0 ? "K" : "Q") : (piece.y == 0 ? "q" : "k");
                n4 = 0;
                n5 = chessGame.playAsWhite ? 3 : 2;
                n6 = -1;
            } else if (n > piece.x) {
                string = !(bl2 ^ chessGame.playAsWhite) ? (piece.y == 0 ? "Q" : "K") : (piece.y == 0 ? "k" : "q");
                n4 = 7;
                n5 = chessGame.playAsWhite ? 5 : 4;
                n6 = 1;
            }
            if (chessGame.castlingAllowed(string)) {
                boolean bl4 = true;
                for (int i = piece.x + n6; i > 0 && i < 7; i += n6) {
                    if (chessGame.getPieceIdAt(i, piece.y) == -1) continue;
                    bl4 = false;
                    break;
                }
                if (bl4) {
                    bl3 = true;
                    int n7 = chessGame.getPieceIdAt(n4, piece.y);
                    chessGame.pieces[n7].x = n5;
                    chessGame.rookCastlingX = n4;
                    chessGame.kingCastlingX = piece.x;
                    chessGame.kingCastlingXE = n;
                    chessGame.rookCastlingId = n7;
                    chessGame.kingCastlingId = chessGame.getPieceIdAt(piece.x, piece.y);
                }
            }
        }
        return bl3;
    }

    private static boolean validate960Castling(ChessGame chessGame, Piece piece, int n, int n2, int n3, boolean bl, boolean bl2) {
        boolean bl3 = true;
        System.out.println("960 Castling...");
        Piece piece2 = chessGame.pieces[n];
        String string = "Z";
        int n4 = 0;
        int n5 = 0;
        if (piece2.x < piece.x) {
            string = !(bl2 ^ chessGame.playAsWhite) ? (piece.y == 0 ? "K" : "Q") : (piece.y == 0 ? "q" : "k");
            n4 = chessGame.playAsWhite ? 3 : 2;
            n5 = chessGame.playAsWhite ? 2 : 1;
        } else {
            string = !(bl2 ^ chessGame.playAsWhite) ? (piece.y == 0 ? "Q" : "K") : (piece.y == 0 ? "k" : "q");
            n4 = chessGame.playAsWhite ? 5 : 4;
            n5 = chessGame.playAsWhite ? 6 : 5;
        }
        String string2 = chessGame.getLetterX(piece2.x);
        if (!("a".equals(string2) || "A".equals(string2) || "h".equals(string2) || "H".equals(string2))) {
            string = "K".equals(string) || "Q".equals(string) ? string2.toUpperCase() : string2.toLowerCase();
        }
        if (chessGame.castlingAllowed(string)) {
            int n6;
            int n7;
            int n8 = chessGame.getPieceIdAt(piece.x, piece.y);
            int n9 = Math.min(piece2.x, n4);
            int n10 = Math.max(piece2.x, n4);
            for (n7 = n9; n7 <= n10; ++n7) {
                n6 = chessGame.getPieceIdAt(n7, piece2.y);
                if (n6 == -1 || n6 == n || n6 == n8) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                n9 = Math.min(piece.x, n5);
                n10 = Math.max(piece.x, n5);
                for (n7 = n9; n7 <= n10; ++n7) {
                    n6 = chessGame.getPieceIdAt(n7, piece2.y);
                    if (n6 == -1 || n6 == n || n6 == n8) continue;
                    bl3 = false;
                    break;
                }
            }
            if (bl3) {
                chessGame.rookCastlingX = chessGame.pieces[n].x;
                chessGame.pieces[n].x = n4;
                chessGame.kingCastlingX = piece.x;
                chessGame.kingCastlingXE = n5;
                chessGame.rookCastlingId = n;
                chessGame.kingCastlingId = n8;
            }
        } else {
            bl3 = false;
        }
        return bl3;
    }

    private static boolean validateCheck(ChessGame chessGame, int n, int n2, boolean bl) {
        boolean bl2 = true;
        Piece piece = ChessLogic.getKing(chessGame, bl);
        boolean bl3 = chessGame.playAsWhite ^ bl;
        for (int i = 0; i < chessGame.pieces.length; ++i) {
            int n3;
            Piece piece2 = chessGame.pieces[i];
            if (piece2 == null || (bl3 || !Character.isLowerCase(piece2.type)) && (!bl3 || !Character.isUpperCase(piece2.type))) continue;
            boolean bl4 = ChessLogic.validateCheckMove(chessGame, piece2, piece.x, piece.y, bl);
            if (bl4) {
                bl2 = false;
                break;
            }
            if (chessGame.rookCastlingId == -1) continue;
            boolean bl5 = false;
            if (chessGame.kingCastlingX > chessGame.kingCastlingXE) {
                for (n3 = chessGame.kingCastlingX; n3 >= chessGame.kingCastlingXE; --n3) {
                    bl5 = bl5 || ChessLogic.validateCheckMove(chessGame, piece2, n3, piece.y, bl);
                }
            } else {
                for (n3 = chessGame.kingCastlingX; n3 <= chessGame.kingCastlingXE; ++n3) {
                    bl5 = bl5 || ChessLogic.validateCheckMove(chessGame, piece2, n3, piece.y, bl);
                }
            }
            if (!bl5) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private static Piece getKing(ChessGame chessGame, boolean bl) {
        Piece piece = null;
        for (int i = 0; i < chessGame.pieces.length; ++i) {
            char c;
            Piece piece2 = chessGame.pieces[i];
            char c2 = c = !(chessGame.playAsWhite ^ bl) ? (char)'K' : 'k';
            if (piece2 == null || piece2.type != c) continue;
            piece = piece2;
            break;
        }
        return piece;
    }

    private static boolean validateCheckMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl) {
        boolean bl2 = false;
        switch (piece.type) {
            case 'P': 
            case 'p': {
                bl2 = ChessLogic.validatePawnMove(chessGame, piece, n, n2, true, bl);
                break;
            }
            case 'R': 
            case 'r': {
                bl2 = ChessLogic.validateRookMove(chessGame, piece, n, n2, true, bl);
                break;
            }
            case 'B': 
            case 'b': {
                bl2 = ChessLogic.validateBishopMove(chessGame, piece, n, n2, true, bl);
                break;
            }
            case 'N': 
            case 'n': {
                bl2 = ChessLogic.validateKnightMove(chessGame, piece, n, n2, true, bl);
                break;
            }
            case 'Q': 
            case 'q': {
                bl2 = ChessLogic.validateQueenMove(chessGame, piece, n, n2, true, bl);
                break;
            }
            case 'K': 
            case 'k': {
                bl2 = ChessLogic.validateKingMove(chessGame, piece, n, n2, true, bl);
            }
        }
        return bl2;
    }

    private static boolean validatePawnMove(ChessGame chessGame, Piece piece, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n3 = -1;
        if (!(bl ^ bl2)) {
            n3 = 1;
        }
        if (n == piece.x) {
            if (n2 == piece.y + n3) {
                if (chessGame.getPieceIdAt(n, n2) == -1) {
                    bl3 = true;
                }
            } else if (n2 == piece.y + 2 * n3) {
                int n4;
                int n5 = n4 = bl2 ? 6 : 1;
                if (piece.y == n4 && chessGame.getPieceIdAt(n, n2) == -1 && chessGame.getPieceIdAt(n, n2 - n3) == -1) {
                    bl3 = true;
                }
            }
        } else if (Math.abs(n - piece.x) == 1 && n2 == piece.y + n3) {
            if (bl) {
                bl3 = true;
            } else {
                int n6 = chessGame.getPieceIdAt(n, n2);
                if (n6 != -1) {
                    if (!(bl2 ^ !chessGame.pieceIdBelongToPlayer(n6))) {
                        bl3 = true;
                        chessGame.removePiece(n6);
                    }
                } else {
                    int n7 = chessGame.getX(chessGame.enPassant.substring(0, 1));
                    if (n7 != -1 && n == n7 && (bl2 && n2 == 2 || !bl2 && n2 == 5)) {
                        int n8 = 3;
                        if (!bl2) {
                            n8 = 4;
                        }
                        n6 = chessGame.getPieceIdAt(n, n8);
                        chessGame.removePiece(n6);
                        bl3 = true;
                    }
                }
            }
        }
        return bl3;
    }

    private static boolean validateTarget(ChessGame chessGame, int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = chessGame.getPieceIdAt(n, n2);
        if (n3 != -1) {
            if (!(bl ^ !chessGame.pieceIdBelongToPlayer(n3))) {
                bl2 = true;
                chessGame.removePiece(n3);
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }
}

