/*
 * Decompiled with CFR 0.152.
 */
package com.chess.rms;

import com.chess.rms.StoreData;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PersistentStore {
    private static final String STORE_NAME = "Chess.com";

    public void setSubmitTime(String string) {
        if ("0".equals(string) || "1".equals(string)) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                String string2 = this.getData(5);
                if (string2 != null) {
                    if (!string2.endsWith(",")) {
                        string2 = string2 + ",";
                    }
                    if (this.maxEntriesReached(string2, string)) {
                        int n = string2.indexOf(",");
                        string2 = string2.substring(n + 1);
                    }
                    this.addOrUpdate(recordStore, 5, string2 + "" + System.currentTimeMillis() + ",");
                } else {
                    this.addOrUpdate(recordStore, 5, "" + System.currentTimeMillis() + ",");
                }
                recordStore.closeRecordStore();
                System.out.println("Submit time set...");
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Could not set submit time. " + (Object)((Object)recordStoreException));
            }
        }
    }

    public boolean allowSubmit(String string) {
        String string2;
        boolean bl = true;
        if (("0".equals(string) || "1".equals(string)) && (string2 = this.getData(5)) != null && this.maxEntriesReached(string2, string)) {
            int n = string2.indexOf(",");
            String string3 = string2.substring(0, n);
            try {
                long l = Long.parseLong(string3);
                long l2 = System.currentTimeMillis() - l;
                if (l2 < 86400000L) {
                    System.out.println("Delta time=" + l2);
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string2.substring(n + 1);
                try {
                    RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                    this.addOrUpdate(recordStore, 5, string2);
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    private boolean maxEntriesReached(String string, String string2) {
        int n = this.countEntries(string);
        boolean bl = false;
        if ("0".equals(string2)) {
            if (n >= 3) {
                bl = true;
            }
        } else if ("1".equals(string2) && n >= 25) {
            bl = true;
        }
        return bl;
    }

    private int countEntries(String string) {
        int n = 0;
        int n2 = string.indexOf(",");
        while (n2 >= 0) {
            ++n;
            n2 = string.indexOf(",", n2 + 1);
        }
        return n;
    }

    private String getData(int n) {
        String string = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            byte[] byArray = recordStore.getRecord(n);
            string = new String(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return string;
    }

    public void saveAccountInfo(StoreData storeData) {
        if (storeData.userName != null && !"".equals(storeData.userName.trim()) && storeData.password != null && !"".equals(storeData.password.trim())) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.addOrUpdate(recordStore, 1, storeData.userName);
                this.addOrUpdate(recordStore, 2, storeData.password);
                this.addOrUpdate(recordStore, 3, storeData.autoLogin ? "1" : "0");
                recordStore.closeRecordStore();
                System.out.println("Account saved...");
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Could not save account. " + (Object)((Object)recordStoreException));
            }
        }
    }

    private void addOrUpdate(RecordStore recordStore, int n, String string) {
        byte[] byArray = string.getBytes();
        boolean bl = false;
        try {
            recordStore.setRecord(n, byArray, 0, byArray.length);
            bl = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (!bl) {
            try {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Could not add record.");
            }
        }
    }

    public StoreData loadAccountInfo() {
        StoreData storeData = new StoreData();
        storeData.valid = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            storeData.userName = new String(byArray);
            byte[] byArray2 = recordStore.getRecord(2);
            storeData.password = new String(byArray2);
            byte[] byArray3 = recordStore.getRecord(3);
            storeData.autoLogin = "1".equals(new String(byArray3));
            System.out.println("Account loaded...");
            recordStore.closeRecordStore();
            storeData.valid = true;
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("Could not load account. " + (Object)((Object)recordStoreException));
        }
        return storeData;
    }

    public void saveSettings(String string) {
        if (string != null && !"".equals(string.trim())) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.addOrUpdate(recordStore, 4, string);
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Could not save account. " + (Object)((Object)recordStoreException));
            }
        }
    }

    public String loadSettings() {
        String string = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            byte[] byArray = recordStore.getRecord(4);
            string = new String(byArray);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("Could not load account. " + (Object)((Object)recordStoreException));
        }
        return string;
    }
}

