/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.chessboard.ChessGame;
import com.chess.chessboard.ChessLogic;
import com.chess.chessboard.Piece;
import com.chess.input.Keys;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnalysisScreen
implements IScreen {
    private ChesscomCanvas canvas;
    public ChessGame chessGame;
    public ChessGame current;
    private Image analysisicon;
    private Image chess960;
    private Font smallBoldFont;
    private Font smallFont;
    private boolean initialMove = true;
    public boolean myMove = true;
    private int selectedX = 0;
    private int selectedY = 0;
    private boolean pieceSelected = false;
    private int pieceSelectedId = -1;
    private int newFromX;
    private int newFromY;
    private boolean promotion = false;
    private int promotionX = 0;
    private int promotionY = 0;
    private boolean whitePromotion = false;
    public int size = 0;
    public boolean rules = true;

    public AnalysisScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.analysisicon = Image.createImage((String)"/res/analysisicon.png");
        this.chess960 = Image.createImage((String)"/res/chess960.png");
    }

    public void draw(Graphics graphics, long l) {
        int n;
        int n2;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.handleInput();
        int n3 = this.smallBoldFont.getHeight();
        int n4 = 3 * n3 / 2;
        int n5 = (this.canvas.width - 8 * this.size) / 2;
        if (this.canvas.height > 250) {
            Theme.drawFader(this.canvas, graphics, 0, n4 - 4);
            n2 = this.smallBoldFont.stringWidth("Analysis Board") + 20;
            graphics.drawImage(this.analysisicon, this.canvas.width / 2 - n2 / 2, 2, 20);
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallBoldFont);
            graphics.drawString("Analysis Board", this.canvas.width / 2 - n2 / 2 + 18, 2, 20);
        } else {
            n4 = 4;
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallFont);
        n2 = 0;
        if (this.chessGame.chess960) {
            graphics.drawImage(this.chess960, n5, n4 - 1, 20);
            n2 = 16;
        }
        graphics.drawString(this.chessGame.opponent, n5 + n2, n4, 20);
        int n6 = this.smallFont.stringWidth(this.chessGame.opponent);
        int n7 = this.smallFont.stringWidth(this.chessGame.timeLeft);
        if (8 * this.size > n7 + n6 + 5) {
            graphics.drawString(this.chessGame.timeLeft, this.canvas.width - n5, n4, 24);
        }
        n4 += n4 - 5;
        graphics.setColor(169, 169, 169);
        graphics.fillRect(n5 - 2, n4 - 2, 8 * this.size + 4, 8 * this.size + 4);
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                if ((n + i) % 2 == 0) {
                    graphics.setColor(240, 217, 181);
                    graphics.fillRect(n * this.size + n5, i * this.size + n4, this.size, this.size);
                    continue;
                }
                graphics.setColor(181, 136, 99);
                graphics.fillRect(n * this.size + n5, i * this.size + n4, this.size, this.size);
            }
        }
        if (this.initialMove && this.chessGame.lastFromX != -1 && this.chessGame.lastToX != -1) {
            graphics.setColor(255, 255, 163);
            graphics.fillRect(this.chessGame.lastFromX * this.size + n5, this.chessGame.lastFromY * this.size + n4, this.size, this.size);
            graphics.setColor(255, 255, 51);
            graphics.fillRect(this.chessGame.lastToX * this.size + n5, this.chessGame.lastToY * this.size + n4, this.size, this.size);
        }
        for (n = 0; n < this.chessGame.pieces.length; ++n) {
            Piece piece;
            if (this.pieceSelected && n == this.pieceSelectedId || (piece = this.chessGame.pieces[n]) == null) continue;
            graphics.drawImage(this.canvas.boardScreen.getPieceImage(piece.type), n5 + piece.x * this.size, n4 + piece.y * this.size, 20);
        }
        if (this.selectedY != 8) {
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n5 + this.selectedX * this.size, n4 + this.selectedY * this.size, this.size - 1, this.size - 1);
            graphics.drawRect(n5 + this.selectedX * this.size + 1, n4 + this.selectedY * this.size + 1, this.size - 3, this.size - 3);
            if (this.pieceSelected) {
                Piece piece = this.chessGame.pieces[this.pieceSelectedId];
                graphics.drawImage(this.canvas.boardScreen.getPieceImage(piece.type), n5 + this.selectedX * this.size, n4 + this.selectedY * this.size, 20);
            }
        }
        if (this.promotion) {
            graphics.setColor(240, 217, 181);
            graphics.fillRect(n5 + 5 * this.size / 2, n4 + 5 * this.size / 2, 3 * this.size, 3 * this.size);
            graphics.setColor(181, 136, 99);
            graphics.drawRect(n5 + 5 * this.size / 2, n4 + 5 * this.size / 2, 3 * this.size - 1, 3 * this.size - 1);
            if (this.whitePromotion) {
                graphics.drawImage(this.canvas.boardScreen.whiteQueen, n5 + 3 * this.size, n4 + 3 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.whiteKnight, n5 + 4 * this.size, n4 + 3 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.whiteRook, n5 + 3 * this.size, n4 + 4 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.whiteBishop, n5 + 4 * this.size, n4 + 4 * this.size, 20);
            } else {
                graphics.drawImage(this.canvas.boardScreen.blackQueen, n5 + 3 * this.size, n4 + 3 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.blackKnight, n5 + 4 * this.size, n4 + 3 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.blackRook, n5 + 3 * this.size, n4 + 4 * this.size, 20);
                graphics.drawImage(this.canvas.boardScreen.blackBishop, n5 + 4 * this.size, n4 + 4 * this.size, 20);
            }
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n5 + (3 + this.promotionX) * this.size, n4 + (3 + this.promotionY) * this.size, this.size - 1, this.size - 1);
            graphics.drawRect(n5 + (3 + this.promotionX) * this.size + 1, n4 + (3 + this.promotionY) * this.size + 1, this.size - 3, this.size - 3);
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n3 / 2 + 4, 3 * n3 / 2 - 4);
        if (this.selectedY == 8) {
            graphics.setColor(185, 185, 165);
            if (this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n3 / 2 + 6, this.canvas.width / 3, n3);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n3 / 2 + 6, this.canvas.width / 3, n3);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.promotion) {
            graphics.drawString("Select", 5, this.canvas.height - 2, 36);
        } else {
            graphics.drawString("Current", 5, this.canvas.height - 2, 36);
            graphics.drawString("Back", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (this.promotion) {
            if (keys.up) {
                --this.promotionY;
                if (this.promotionY < 0) {
                    this.promotionY = 1;
                }
            } else if (keys.down) {
                ++this.promotionY;
                if (this.promotionY > 1) {
                    this.promotionY = 0;
                }
            } else if (keys.left) {
                --this.promotionX;
                if (this.promotionX < 0) {
                    this.promotionX = 1;
                }
            } else if (keys.right) {
                ++this.promotionX;
                if (this.promotionX > 1) {
                    this.promotionX = 0;
                }
            }
        } else if (keys.up) {
            --this.selectedY;
            if (this.selectedY < 0) {
                this.selectedY = 8;
            }
        } else if (keys.down) {
            ++this.selectedY;
            if (this.selectedY > 8) {
                this.selectedY = 0;
            }
        } else if (keys.left) {
            --this.selectedX;
            if (this.selectedY == 8) {
                this.selectedX = 0;
            } else if (this.selectedX < 0) {
                this.selectedX = 7;
            }
        } else if (keys.right) {
            ++this.selectedX;
            if (this.selectedY == 8) {
                this.selectedX = 1;
            } else if (this.selectedX > 7) {
                this.selectedX = 0;
            }
        }
        if (keys.fire) {
            if (this.promotion) {
                this.handlePromotionPressed();
            } else {
                this.handlePressed();
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (!this.promotion) {
            this.gotoBoardScreen();
        }
    }

    private void handleLeftMenu() {
        if (this.promotion) {
            this.handlePromotionPressed();
        } else {
            this.setCurrent();
        }
    }

    private void setCurrent() {
        this.myMove = this.current.myMove;
        this.chessGame = this.current.getAnalysisCopy();
    }

    private void handlePressed() {
        if (this.selectedY == 8) {
            if (this.selectedX == 0) {
                this.handleLeftMenu();
            } else {
                this.handleRightMenu();
            }
        } else if (this.pieceSelected) {
            Piece piece = this.chessGame.pieces[this.pieceSelectedId];
            if (!this.rules || ChessLogic.validateMove(this.chessGame, piece, this.selectedX, this.selectedY, this.myMove)) {
                this.updateEnPassant(piece);
                this.updateCastling(piece);
                this.enforceRulesOnNoRules();
                piece.x = this.chessGame.chess960 && this.chessGame.rookCastlingId != -1 ? this.chessGame.kingCastlingXE : this.selectedX;
                piece.y = this.selectedY;
                this.handlePromotion(piece);
                this.pieceSelected = false;
                this.initialMove = false;
                this.myMove = !this.myMove;
                this.chessGame.rookCastlingId = -1;
                this.chessGame.takenPieceId = -1;
                this.chessGame.promotedId = -1;
            } else {
                this.pieceSelected = false;
                this.cancelMove();
            }
        } else {
            int n = this.chessGame.getPieceIdAt(this.selectedX, this.selectedY);
            if (n != -1) {
                boolean bl = this.myMove ^ this.chessGame.pieceIdBelongToPlayer(n);
                if (!this.rules || !bl) {
                    this.pieceSelectedId = n;
                    this.newFromX = this.selectedX;
                    this.newFromY = this.selectedY;
                    this.pieceSelected = true;
                }
            }
        }
    }

    private void enforceRulesOnNoRules() {
        int n;
        if (!this.rules && (n = this.chessGame.getPieceIdAt(this.selectedX, this.selectedY)) != -1) {
            this.chessGame.removePiece(n);
            this.chessGame.takenPieceId = -1;
        }
    }

    private void handlePromotion(Piece piece) {
        if (piece.isPawn() && (this.selectedY == 0 || this.selectedY == 7)) {
            this.promotion = true;
            this.whitePromotion = Character.isUpperCase(piece.type);
        }
    }

    private void updateCastling(Piece piece) {
        String string = this.chessGame.castling;
        System.out.println("CC before=" + string);
        if (piece.isKing()) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ((!Character.isLowerCase(piece.type) || !Character.isUpperCase(c)) && (!Character.isUpperCase(piece.type) || !Character.isLowerCase(c))) continue;
                string2 = string2 + c;
            }
            this.chessGame.castling = string2;
        } else if (piece.isRook() && (piece.y == 0 || piece.y == 7)) {
            String string3 = this.chessGame.getLetterX(piece.x);
            if (Character.isUpperCase(piece.type)) {
                string3 = piece.x == 0 && piece.y == 0 || piece.x == 7 && piece.y == 7 ? "K" : (piece.x == 0 && piece.y == 7 || piece.x == 7 && piece.y == 0 ? "Q" : string3.toUpperCase());
            } else {
                if (piece.x == 0 && piece.y == 0 || piece.x == 7 && piece.y == 7) {
                    string3 = "q";
                }
                string3 = piece.x == 0 && piece.y == 7 || piece.x == 7 && piece.y == 0 ? "k" : string3.toLowerCase();
            }
            System.out.println("UC-Type=" + string3);
            String string4 = "";
            for (int i = 0; i < string.length(); ++i) {
                String string5 = "" + string.charAt(i);
                if (string3.equals(string5)) continue;
                string4 = string4 + string5;
            }
            this.chessGame.castling = string4;
        }
        System.out.println("CC after=" + this.chessGame.castling);
    }

    private void updateEnPassant(Piece piece) {
        if (piece.isPawn() && Math.abs(piece.y - this.selectedY) == 2) {
            this.chessGame.enPassant = piece.y > this.selectedY ? this.chessGame.getLetterX(piece.x) + (piece.y - 1) : this.chessGame.getLetterX(piece.x) + (piece.y + 1);
        }
    }

    private void cancelMove() {
        if (this.pieceSelectedId != -1) {
            Piece piece = this.chessGame.pieces[this.pieceSelectedId];
            piece.x = this.newFromX;
            piece.y = this.newFromY;
            this.chessGame.resetMove();
        }
    }

    private void handlePromotionPressed() {
        char c = 'q';
        if (this.promotionX == 1 && this.promotionY == 0) {
            c = 'n';
        } else if (this.promotionX == 0 && this.promotionY == 1) {
            c = 'r';
        } else if (this.promotionX == 1 && this.promotionY == 1) {
            c = 'b';
        }
        if (this.whitePromotion) {
            c = Character.toUpperCase(c);
        }
        this.chessGame.promote(this.pieceSelectedId, c);
        this.promotion = false;
        this.chessGame.promotedId = -1;
    }

    private void gotoBoardScreen() {
        this.canvas.setScreen(this.canvas.boardScreen);
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.selectedX = 0;
        this.selectedY = 0;
        this.pieceSelected = false;
        this.pieceSelectedId = -1;
        this.newFromX = 0;
        this.newFromY = 0;
        this.initialMove = true;
        this.myMove = this.chessGame.myMove;
        System.out.println("MM=" + this.myMove);
        this.promotion = false;
        this.promotionX = 0;
        this.promotionY = 0;
    }
}

