/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.chessboard.ChessGame;
import com.chess.chessboard.ChessLogic;
import com.chess.chessboard.Piece;
import com.chess.input.Keys;
import com.chess.internet.CommandThread;
import com.chess.internet.GameHistoryThread;
import com.chess.screens.IScreen;
import com.chess.screens.MessageScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardScreen
implements IScreen {
    private ChesscomCanvas canvas;
    private boolean firstInit = true;
    public ChessGame chessGame;
    public int chessGameId;
    public String membershipLevel;
    public Image whitePawn;
    public Image whiteRook;
    public Image whiteBishop;
    public Image whiteKnight;
    public Image whiteQueen;
    public Image whiteKing;
    public Image blackPawn;
    public Image blackRook;
    public Image blackBishop;
    public Image blackKnight;
    public Image blackQueen;
    public Image blackKing;
    private Image checkMark;
    private Image errorMark;
    private Image chess960;
    private Font smallBoldFont;
    private Font smallFont;
    private int size = 0;
    private int selectedX = 0;
    private int selectedY = 0;
    private boolean pieceSelected = false;
    private boolean pieceSetDown = false;
    private int pieceSelectedId = -1;
    private int newFromX;
    private int newFromY;
    private int newToX;
    private int newToY;
    private boolean promotion = false;
    private char promoted = (char)32;
    private int promotionX = 0;
    private int promotionY = 0;
    private boolean noMove = false;
    private boolean submitted = false;
    private boolean resigned = false;
    private boolean drawOffered = false;
    private boolean drawAccepted = false;
    private boolean commiting = false;
    private boolean commited = false;
    private boolean failed = false;
    public String command = null;
    private boolean menu;
    private int menuSelected = 0;
    private boolean maxMoves = false;
    private boolean showMaxMoves = false;
    public int boardSize = 1;
    public String[] resSizeArray = new String[]{"176", "240", "320", "480"};
    public int[] sizeArray = new int[]{17, 24, 32, 45};
    private int currentBoardSize = 1;
    private boolean adjustBoardSizeError = false;

    public BoardScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.checkMark = Image.createImage((String)"/res/checkmark.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
        this.chess960 = Image.createImage((String)"/res/chess960.png");
    }

    private void setBoardSize() {
        String string = this.resSizeArray[this.boardSize];
        this.size = this.sizeArray[this.boardSize];
        try {
            this.whitePawn = Image.createImage((String)("/res/" + string + "/wp.png"));
            this.whiteRook = Image.createImage((String)("/res/" + string + "/wr.png"));
            this.whiteBishop = Image.createImage((String)("/res/" + string + "/wb.png"));
            this.whiteKnight = Image.createImage((String)("/res/" + string + "/wn.png"));
            this.whiteQueen = Image.createImage((String)("/res/" + string + "/wq.png"));
            this.whiteKing = Image.createImage((String)("/res/" + string + "/wk.png"));
            this.blackPawn = Image.createImage((String)("/res/" + string + "/bp.png"));
            this.blackRook = Image.createImage((String)("/res/" + string + "/br.png"));
            this.blackBishop = Image.createImage((String)("/res/" + string + "/bb.png"));
            this.blackKnight = Image.createImage((String)("/res/" + string + "/bn.png"));
            this.blackQueen = Image.createImage((String)("/res/" + string + "/bq.png"));
            this.blackKing = Image.createImage((String)("/res/" + string + "/bk.png"));
        }
        catch (IOException iOException) {
            this.adjustBoardSizeError = true;
        }
        this.currentBoardSize = this.boardSize;
    }

    public void draw(Graphics graphics, long l) {
        int n;
        int n2;
        int n3;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.handleInput();
        this.checkCommand();
        int n4 = this.smallBoldFont.getHeight();
        int n5 = 3 * n4 / 2 - 3;
        int n6 = (this.canvas.width - 8 * this.size) / 2;
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallFont);
        int n7 = 0;
        if (this.chessGame.chess960) {
            graphics.drawImage(this.chess960, n6, 1, 20);
            n7 = 16;
        }
        graphics.drawString(this.chessGame.opponent, n6 + n7, 2, 20);
        int n8 = this.smallFont.stringWidth(this.chessGame.opponent);
        int n9 = this.smallFont.stringWidth(this.chessGame.timeLeft);
        if (8 * this.size > n9 + n8 + 5) {
            graphics.drawString(this.chessGame.timeLeft, this.canvas.width - n6, 2, 24);
        }
        graphics.setColor(169, 169, 169);
        graphics.fillRect(n6 - 2, n5 - 2, 8 * this.size + 4, 8 * this.size + 4);
        for (n3 = 0; n3 < 8; ++n3) {
            for (int i = 0; i < 8; ++i) {
                if ((n3 + i) % 2 == 0) {
                    graphics.setColor(240, 217, 181);
                    graphics.fillRect(n3 * this.size + n6, i * this.size + n5, this.size, this.size);
                    continue;
                }
                graphics.setColor(181, 136, 99);
                graphics.fillRect(n3 * this.size + n6, i * this.size + n5, this.size, this.size);
            }
        }
        if (this.pieceSetDown) {
            graphics.setColor(92, 194, 255);
            graphics.fillRect(this.newFromX * this.size + n6, this.newFromY * this.size + n5, this.size, this.size);
            graphics.setColor(51, 153, 255);
            graphics.fillRect(this.newToX * this.size + n6, this.newToY * this.size + n5, this.size, this.size);
        } else if (this.chessGame.lastFromX != -1 && this.chessGame.lastToX != -1) {
            graphics.setColor(255, 255, 163);
            graphics.fillRect(this.chessGame.lastFromX * this.size + n6, this.chessGame.lastFromY * this.size + n5, this.size, this.size);
            graphics.setColor(255, 255, 51);
            graphics.fillRect(this.chessGame.lastToX * this.size + n6, this.chessGame.lastToY * this.size + n5, this.size, this.size);
        }
        for (n3 = 0; n3 < this.chessGame.pieces.length; ++n3) {
            Piece piece;
            if (this.pieceSelected && n3 == this.pieceSelectedId || (piece = this.chessGame.pieces[n3]) == null) continue;
            graphics.drawImage(this.getPieceImage(piece.type), n6 + piece.x * this.size, n5 + piece.y * this.size, 20);
        }
        if (!this.noMove && this.selectedY != 8) {
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n6 + this.selectedX * this.size, n5 + this.selectedY * this.size, this.size - 1, this.size - 1);
            graphics.drawRect(n6 + this.selectedX * this.size + 1, n5 + this.selectedY * this.size + 1, this.size - 3, this.size - 3);
            if (this.pieceSelected) {
                Piece piece = this.chessGame.pieces[this.pieceSelectedId];
                graphics.drawImage(this.getPieceImage(piece.type), n6 + this.selectedX * this.size, n5 + this.selectedY * this.size, 20);
            }
        }
        if (this.chessGame.lastDesc != null && !"".equals(this.chessGame.lastDesc.trim())) {
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallFont);
            graphics.drawString("" + this.chessGame.fullMove + (this.chessGame.playAsWhite ? "..." : ".") + this.chessGame.lastDesc, n6, n5 + 8 * this.size, 20);
        }
        if (this.promotion) {
            graphics.setColor(240, 217, 181);
            graphics.fillRect(n6 + 5 * this.size / 2, n5 + 5 * this.size / 2, 3 * this.size, 3 * this.size);
            graphics.setColor(181, 136, 99);
            graphics.drawRect(n6 + 5 * this.size / 2, n5 + 5 * this.size / 2, 3 * this.size - 1, 3 * this.size - 1);
            if (this.chessGame.playAsWhite) {
                graphics.drawImage(this.whiteQueen, n6 + 3 * this.size, n5 + 3 * this.size, 20);
                graphics.drawImage(this.whiteKnight, n6 + 4 * this.size, n5 + 3 * this.size, 20);
                graphics.drawImage(this.whiteRook, n6 + 3 * this.size, n5 + 4 * this.size, 20);
                graphics.drawImage(this.whiteBishop, n6 + 4 * this.size, n5 + 4 * this.size, 20);
            } else {
                graphics.drawImage(this.blackQueen, n6 + 3 * this.size, n5 + 3 * this.size, 20);
                graphics.drawImage(this.blackKnight, n6 + 4 * this.size, n5 + 3 * this.size, 20);
                graphics.drawImage(this.blackRook, n6 + 3 * this.size, n5 + 4 * this.size, 20);
                graphics.drawImage(this.blackBishop, n6 + 4 * this.size, n5 + 4 * this.size, 20);
            }
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n6 + (3 + this.promotionX) * this.size, n5 + (3 + this.promotionY) * this.size, this.size - 1, this.size - 1);
            graphics.drawRect(n6 + (3 + this.promotionX) * this.size + 1, n5 + (3 + this.promotionY) * this.size + 1, this.size - 3, this.size - 3);
        }
        if (this.showMaxMoves) {
            int n10 = "0".equals(this.membershipLevel) ? 3 : 25;
            String[] stringArray = new String[]{"You have made", "the max # of moves", "(" + n10 + " per 24 hrs).", "Upgrade to a", "Premium Membership", "for unlimited", "mobile moves!"};
            Theme.drawInformation(this.canvas, graphics, stringArray);
        }
        if (this.adjustBoardSizeError) {
            Theme.drawErrorCentered(this.canvas, graphics, "Could not adjust board size.", null);
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n4 / 2 + 4, 3 * n4 / 2 - 4);
        if (this.selectedY == 8) {
            graphics.setColor(185, 185, 165);
            if (this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n4 / 2 + 6, this.canvas.width / 3, n4);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n4 / 2 + 6, this.canvas.width / 3, n4);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.menu) {
            graphics.drawString("Select", 5, this.canvas.height - 2, 36);
            graphics.drawString("Cancel", this.canvas.width - 5, this.canvas.height - 2, 40);
        } else if (!this.failed && !this.commiting && !this.commited && (this.submitted || this.resigned || this.drawAccepted || this.drawOffered)) {
            graphics.drawString("OK", 5, this.canvas.height - 2, 36);
            graphics.drawString("Cancel", this.canvas.width - 5, this.canvas.height - 2, 40);
        } else if (this.promotion) {
            graphics.drawString("Select", 5, this.canvas.height - 2, 36);
        } else if (this.showMaxMoves || this.adjustBoardSizeError) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.failed) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.pieceSetDown && !this.commited && !this.failed && !this.maxMoves) {
            graphics.drawString("Submit", 5, this.canvas.height - 2, 36);
            graphics.drawString("Cancel", this.canvas.width - 5, this.canvas.height - 2, 40);
        } else if (!this.commiting) {
            if (!this.commited && !this.maxMoves) {
                graphics.drawString("Menu", 5, this.canvas.height - 2, 36);
            }
            graphics.drawString("Back", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
        if (this.submitted || this.resigned || this.drawAccepted || this.drawOffered) {
            graphics.setFont(this.smallFont);
            if (this.commiting) {
                String string = this.getWaitingMessage(l);
                String string2 = "";
                if (this.submitted) {
                    string2 = "Submitting Move..";
                } else if (this.resigned) {
                    string2 = "Resigning Game..";
                } else if (this.drawAccepted) {
                    string2 = "Accepting Draw..";
                } else if (this.drawOffered) {
                    string2 = "Offering Draw..";
                }
                n2 = this.smallFont.stringWidth(string2);
                n = this.canvas.width / 2 - n2 / 2;
                Theme.drawConfirmation(this.canvas, graphics, string, n, null);
            } else if (this.commited) {
                String string = this.getMessage();
                Theme.drawConfirmationCentered(this.canvas, graphics, string, this.checkMark);
            } else if (this.failed) {
                Theme.drawErrorCentered(this.canvas, graphics, this.command, this.errorMark);
            } else {
                String string = this.getConfirmationMessage();
                Theme.drawConfirmationCentered(this.canvas, graphics, string, null);
            }
        }
        if (this.menu) {
            int n11 = this.smallBoldFont.stringWidth("Analysis Board..") + 50;
            int n12 = 7 * n4 + 5;
            n2 = 2;
            n = this.canvas.height - 3 * n4 / 2 + 2 - n12;
            graphics.setColor(255, 255, 255);
            graphics.fillRect(n2, n, n11, n12);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n2, n, n11, n12);
            graphics.setColor(205, 205, 185);
            graphics.fillRect(n2 + 3, n + 3 + this.menuSelected * n4, n11 - 5, n4);
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallBoldFont);
            if (!this.pieceSetDown) {
                graphics.setColor(170, 170, 170);
            }
            graphics.drawString("Submit Move", n2 + 6, n + 3, 20);
            graphics.setFont(this.smallFont);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Resign Game", n2 + 6, n + 3 + n4, 20);
            graphics.drawString("Offer Draw", n2 + 6, n + 3 + n4 * 2, 20);
            if (!this.chessGame.pendingDrawOffer) {
                graphics.setColor(170, 170, 170);
            }
            graphics.drawString("Accept Draw", n2 + 6, n + 3 + n4 * 3, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Messages", n2 + 6, n + 3 + n4 * 4, 20);
            graphics.drawString("Analysis Board", n2 + 6, n + 3 + n4 * 5, 20);
            graphics.drawString("Exit", n2 + 6, n + 3 + n4 * 6, 20);
        }
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (this.menu) {
            if (keys.up) {
                --this.menuSelected;
                if (this.menuSelected == 3 && !this.chessGame.pendingDrawOffer) {
                    --this.menuSelected;
                }
                if (this.menuSelected == 0 && !this.pieceSetDown) {
                    --this.menuSelected;
                }
            }
            if (keys.down) {
                ++this.menuSelected;
                if (this.menuSelected == 3 && !this.chessGame.pendingDrawOffer) {
                    ++this.menuSelected;
                }
            }
            if (this.menuSelected < 0) {
                this.menuSelected = 6;
            }
            if (this.menuSelected > 6) {
                this.menuSelected = 0;
            }
            if (this.menuSelected == 0 && !this.pieceSetDown) {
                ++this.menuSelected;
            }
            if (keys.left) {
                if (this.selectedY == 8) {
                    --this.selectedX;
                    if (this.selectedX < 0) {
                        this.selectedX = 0;
                    }
                }
            } else if (keys.right && this.selectedY == 8) {
                ++this.selectedX;
                if (this.selectedX > 1) {
                    this.selectedX = 1;
                }
            }
        } else if (this.promotion) {
            if (keys.up) {
                --this.promotionY;
                if (this.promotionY < 0) {
                    this.promotionY = 1;
                }
            } else if (keys.down) {
                ++this.promotionY;
                if (this.promotionY > 1) {
                    this.promotionY = 0;
                }
            } else if (keys.left) {
                --this.promotionX;
                if (this.promotionX < 0) {
                    this.promotionX = 1;
                }
            } else if (keys.right) {
                ++this.promotionX;
                if (this.promotionX > 1) {
                    this.promotionX = 0;
                }
            }
        } else if (!this.adjustBoardSizeError) {
            if (!this.chessGame.myMove) {
                if (keys.left) {
                    this.selectedX = 0;
                } else if (keys.right) {
                    this.selectedX = 1;
                }
            } else if (!this.noMove) {
                if (keys.up) {
                    --this.selectedY;
                    if (this.selectedY < 0) {
                        this.selectedY = 8;
                    }
                } else if (keys.down) {
                    ++this.selectedY;
                    if (this.selectedY > 8) {
                        this.selectedY = 0;
                    }
                } else if (keys.left) {
                    --this.selectedX;
                    if (this.selectedY == 8) {
                        this.selectedX = 0;
                    } else if (this.selectedX < 0) {
                        this.selectedX = 7;
                    }
                } else if (keys.right) {
                    ++this.selectedX;
                    if (this.selectedY == 8) {
                        this.selectedX = 1;
                    } else if (this.selectedX > 7) {
                        this.selectedX = 0;
                    }
                }
                if (this.selectedY == 8 && this.showMaxMoves) {
                    this.selectedX = 0;
                } else if (this.selectedY == 8 && this.maxMoves) {
                    this.selectedX = 1;
                }
            } else if (!this.showMaxMoves && !this.commited && (this.submitted || this.resigned || this.drawOffered || this.drawAccepted)) {
                if (keys.left) {
                    this.selectedX = 0;
                } else if (keys.right && !this.failed) {
                    this.selectedX = 1;
                }
            }
        }
        if (keys.fire) {
            if (this.menu) {
                if (this.selectedY == 8) {
                    if (this.selectedX == 0) {
                        this.handleMenuPressed();
                    } else {
                        this.menu = false;
                    }
                } else {
                    this.handleMenuPressed();
                }
            } else if (this.promotion) {
                this.handlePromotionPressed();
            } else if (this.showMaxMoves) {
                this.showMaxMoves = false;
            } else if (this.adjustBoardSizeError) {
                this.adjustBoardSizeError = false;
            } else if (this.failed) {
                this.resetFailed();
            } else {
                this.handlePressed();
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (this.menu) {
            this.menu = false;
        } else if (!this.adjustBoardSizeError) {
            if (this.maxMoves && !this.showMaxMoves) {
                this.gotoGamesListScreen();
            } else if (!this.failed && !this.commited && !this.commiting && (this.submitted || this.resigned || this.drawAccepted || this.drawOffered)) {
                this.cancelCommand();
            } else if (this.pieceSetDown && !this.commited && !this.failed) {
                this.cancelMove();
            } else if (!(this.commiting || this.showMaxMoves || this.failed)) {
                this.gotoGamesListScreen();
            }
        }
    }

    private void handleLeftMenu() {
        if (this.menu) {
            this.handleMenuPressed();
        } else if (!this.failed && !this.commited && !this.commiting && (this.submitted || this.resigned || this.drawAccepted || this.drawOffered)) {
            this.doCommand();
        } else if (this.promotion) {
            this.handlePromotionPressed();
        } else if (this.showMaxMoves) {
            this.showMaxMoves = false;
        } else if (this.adjustBoardSizeError) {
            this.adjustBoardSizeError = false;
        } else if (this.failed) {
            this.resetFailed();
        } else if (this.pieceSetDown && !this.commited && !this.failed && !this.maxMoves) {
            this.submitMove();
        } else if (!(this.commited || this.commiting || this.maxMoves)) {
            this.menu = true;
            this.menuSelected = !this.pieceSetDown ? 6 : 0;
        }
    }

    private void resetFailed() {
        this.commited = false;
        this.commiting = false;
        this.failed = false;
        this.submitted = false;
        this.resigned = false;
        this.drawOffered = false;
        this.drawAccepted = false;
        this.noMove = false;
        this.command = null;
        this.cancelMove();
    }

    private void handlePressed() {
        if (this.selectedY == 8) {
            if (this.selectedX == 0) {
                this.handleLeftMenu();
            } else {
                this.handleRightMenu();
            }
        } else if (!this.noMove) {
            if (!this.pieceSetDown) {
                if (this.pieceSelected) {
                    Piece piece = this.chessGame.pieces[this.pieceSelectedId];
                    if (ChessLogic.validateMove(this.chessGame, piece, this.selectedX, this.selectedY, true)) {
                        this.pieceSetDown = true;
                        this.newToX = this.chessGame.chess960 && this.chessGame.rookCastlingId != -1 ? this.chessGame.kingCastlingXE : this.selectedX;
                        this.newToY = this.selectedY;
                        piece.x = this.newToX;
                        piece.y = this.newToY;
                        this.pieceSelected = false;
                        if (piece.isPawn() && this.newToY == 0) {
                            this.promotion = true;
                        }
                    } else {
                        this.pieceSelected = false;
                        this.cancelMove();
                    }
                } else {
                    int n = this.chessGame.getPieceIdAt(this.selectedX, this.selectedY);
                    if (n != -1 && this.chessGame.pieceIdBelongToPlayer(n)) {
                        this.pieceSelectedId = n;
                        this.newFromX = this.selectedX;
                        this.newFromY = this.selectedY;
                        this.pieceSelected = true;
                    }
                }
            } else {
                this.cancelMove();
            }
        }
    }

    private void handleMenuPressed() {
        switch (this.menuSelected) {
            case 0: {
                this.submitMove();
                break;
            }
            case 1: {
                this.resigned = true;
                this.noMove = true;
                this.selectedY = 8;
                this.menu = false;
                break;
            }
            case 2: {
                this.drawOffered = true;
                this.noMove = true;
                this.selectedY = 8;
                this.menu = false;
                break;
            }
            case 3: {
                this.drawAccepted = true;
                this.noMove = true;
                this.selectedY = 8;
                this.menu = false;
                break;
            }
            case 4: {
                this.gotoMessageScreen();
                break;
            }
            case 5: {
                this.gotoAnalysisScreen();
                break;
            }
            case 6: {
                this.canvas.midlet.destroy();
            }
        }
    }

    private void cancelMove() {
        if (this.pieceSelectedId != -1) {
            Piece piece = this.chessGame.pieces[this.pieceSelectedId];
            piece.x = this.newFromX;
            piece.y = this.newFromY;
            this.promoted = (char)32;
            this.chessGame.resetMove();
            this.pieceSetDown = false;
        }
    }

    private void submitMove() {
        this.submitted = true;
        this.noMove = true;
        this.selectedY = 8;
        this.menu = false;
    }

    private void handlePromotionPressed() {
        char c = 'q';
        if (this.promotionX == 1 && this.promotionY == 0) {
            c = 'n';
        } else if (this.promotionX == 0 && this.promotionY == 1) {
            c = 'r';
        } else if (this.promotionX == 1 && this.promotionY == 1) {
            c = 'b';
        }
        if (this.chessGame.playAsWhite) {
            c = Character.toUpperCase(c);
        }
        this.chessGame.promote(this.pieceSelectedId, c);
        this.promoted = Character.toUpperCase(c);
        this.promotion = false;
    }

    private String getConfirmationMessage() {
        if (this.submitted) {
            return "Submit Move?";
        }
        if (this.resigned) {
            return "Resign Game?";
        }
        if (this.drawAccepted) {
            return "Accept Draw?";
        }
        return "Offer Draw?";
    }

    private String getMessage() {
        if (this.submitted) {
            return "Move Was Submitted.";
        }
        if (this.resigned) {
            return "Game Was Resigned.";
        }
        if (this.drawAccepted) {
            return "Draw Was Accepted.";
        }
        return "Draw was offered.";
    }

    private String getWaitingMessage(long l) {
        String string = null;
        if (this.submitted) {
            if (l / 500L % 3L == 0L) {
                string = "Submitting Move.";
            } else if (l / 500L % 3L == 1L) {
                string = "Submitting Move..";
            } else if (l / 500L % 3L == 2L) {
                string = "Submitting Move...";
            }
        } else if (this.resigned) {
            if (l / 500L % 3L == 0L) {
                string = "Resigning Game.";
            } else if (l / 500L % 3L == 1L) {
                string = "Resigning Game..";
            } else if (l / 500L % 3L == 2L) {
                string = "Resigning Game...";
            }
        } else if (this.drawAccepted) {
            if (l / 500L % 3L == 0L) {
                string = "Accepting Draw.";
            } else if (l / 500L % 3L == 1L) {
                string = "Accepting Draw..";
            } else if (l / 500L % 3L == 2L) {
                string = "Accepting Draw...";
            }
        } else if (l / 500L % 3L == 0L) {
            string = "Offering Draw.";
        } else if (l / 500L % 3L == 1L) {
            string = "Offering Draw..";
        } else if (l / 500L % 3L == 2L) {
            string = "Offering Draw...";
        }
        return string;
    }

    private void doCommand() {
        this.commiting = true;
        if (this.submitted) {
            this.submit();
        } else if (this.resigned) {
            this.resign();
        } else if (this.drawAccepted) {
            this.acceptDraw();
        } else {
            this.offerDraw();
        }
    }

    private void cancelCommand() {
        this.noMove = false;
        this.submitted = false;
        this.resigned = false;
        this.drawOffered = false;
        this.drawAccepted = false;
        this.cancelMove();
    }

    private void checkCommand() {
        if (this.command != null && !this.commited && !this.failed) {
            this.commiting = false;
            if ("OK".equals(this.command)) {
                this.commited = true;
                this.selectedX = 1;
            } else {
                this.failed = true;
                this.selectedX = 0;
            }
        }
    }

    private void submit() {
        CommandThread commandThread = new CommandThread(this.canvas, this);
        commandThread.command = "SUBMIT";
        commandThread.chessId = this.chessGame.id;
        String string = this.chessGame.getLetterX(this.newFromX) + this.chessGame.getNewMoveY(this.newFromY);
        string = this.chessGame.chess960 && this.chessGame.rookCastlingId != -1 ? string + this.chessGame.getLetterX(this.chessGame.rookCastlingX) + this.chessGame.getNewMoveY(this.newToY) : string + this.chessGame.getLetterX(this.newToX) + this.chessGame.getNewMoveY(this.newToY);
        if (this.promoted != ' ') {
            string = string + "=" + this.promoted;
        }
        commandThread.newMove = string;
        commandThread.timeStamp = this.chessGame.timeStamp;
        commandThread.start();
    }

    private void resign() {
        CommandThread commandThread = new CommandThread(this.canvas, this);
        commandThread.command = "RESIGN";
        commandThread.chessId = this.chessGame.id;
        commandThread.newMove = "";
        commandThread.timeStamp = this.chessGame.timeStamp;
        commandThread.start();
    }

    private void offerDraw() {
        CommandThread commandThread = new CommandThread(this.canvas, this);
        commandThread.command = "OFFERDRAW";
        commandThread.chessId = this.chessGame.id;
        commandThread.newMove = "";
        commandThread.timeStamp = this.chessGame.timeStamp;
        commandThread.start();
    }

    private void acceptDraw() {
        CommandThread commandThread = new CommandThread(this.canvas, this);
        commandThread.command = "ACCEPTDRAW";
        commandThread.chessId = this.chessGame.id;
        commandThread.newMove = "";
        commandThread.timeStamp = this.chessGame.timeStamp;
        commandThread.start();
    }

    private void gotoGamesListScreen() {
        if (!this.commited && this.pieceSelectedId != -1) {
            Piece piece = this.chessGame.pieces[this.pieceSelectedId];
            piece.x = this.newFromX;
            piece.y = this.newFromY;
            this.chessGame.resetMove();
        }
        if (this.commited && (this.submitted || this.resigned || this.drawAccepted)) {
            this.canvas.gamesListScreen.removeChessGame(this.chessGameId);
        }
        this.canvas.setScreen(this.canvas.gamesListScreen);
    }

    private void gotoAnalysisScreen() {
        this.canvas.analysisScreen.size = this.size;
        this.canvas.analysisScreen.chessGame = this.chessGame.getAnalysisCopy();
        this.canvas.analysisScreen.current = this.chessGame.getAnalysisCopy();
        this.canvas.setScreen(this.canvas.analysisScreen);
    }

    private void gotoMessageScreen() {
        int n = this.chessGame.opponent.indexOf(" (");
        this.canvas.messageScreen.opponentName = this.chessGame.opponent.substring(0, n);
        this.canvas.messageScreen.myName = this.canvas.loginScreen.screenUserName;
        this.canvas.messageScreen.chessId = this.chessGame.id;
        this.canvas.messageScreen.timeStamp = this.chessGame.timeStamp;
        this.canvas.setScreen(this.canvas.messageScreen);
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.selectedX = 0;
        this.selectedY = this.chessGame.myMove ? 0 : 8;
        this.pieceSelected = false;
        this.pieceSetDown = false;
        this.pieceSelectedId = -1;
        this.newFromX = 0;
        this.newFromY = 0;
        this.newToX = 0;
        this.newToY = 0;
        this.noMove = false;
        this.submitted = false;
        this.resigned = false;
        this.drawOffered = false;
        this.drawAccepted = false;
        this.commited = false;
        this.commiting = false;
        this.command = null;
        this.failed = false;
        this.promotion = false;
        this.promoted = (char)32;
        this.promotionX = 0;
        this.promotionY = 0;
        this.menu = false;
        this.menuSelected = 0;
        if (this.firstInit) {
            this.firstInit = false;
            this.setBoardSize();
            try {
                this.canvas.messageScreen = new MessageScreen(this.canvas);
            }
            catch (IOException iOException) {
                System.out.println("Could not load screens. " + iOException.getMessage());
            }
        }
        if (this.boardSize != this.currentBoardSize) {
            this.setBoardSize();
        }
        if (!this.canvas.midlet.store.allowSubmit(this.membershipLevel)) {
            this.maxMoves = true;
            this.showMaxMoves = true;
            this.selectedX = 0;
        }
        GameHistoryThread gameHistoryThread = new GameHistoryThread(this.canvas, this);
        gameHistoryThread.chessId = this.chessGame.id;
        gameHistoryThread.start();
    }

    public Image getPieceImage(char c) {
        Image image = null;
        switch (c) {
            case 'p': {
                image = this.blackPawn;
                break;
            }
            case 'r': {
                image = this.blackRook;
                break;
            }
            case 'n': {
                image = this.blackKnight;
                break;
            }
            case 'b': {
                image = this.blackBishop;
                break;
            }
            case 'q': {
                image = this.blackQueen;
                break;
            }
            case 'k': {
                image = this.blackKing;
                break;
            }
            case 'P': {
                image = this.whitePawn;
                break;
            }
            case 'R': {
                image = this.whiteRook;
                break;
            }
            case 'N': {
                image = this.whiteKnight;
                break;
            }
            case 'B': {
                image = this.whiteBishop;
                break;
            }
            case 'Q': {
                image = this.whiteQueen;
                break;
            }
            case 'K': {
                image = this.whiteKing;
            }
        }
        return image;
    }
}

