/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.input.Keys;
import com.chess.internet.CreateGameThread;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CreateGameScreen
implements IScreen {
    private ChesscomCanvas canvas;
    private Image createicon;
    private Image errorMark;
    private Image checked;
    private Image unchecked;
    private Font smallBoldFont;
    private int selectedX = 0;
    private int selectedY = 0;
    private boolean createReady = false;
    private boolean direct = true;
    public boolean chess960 = false;
    public String opponentName = "";
    public String min = "";
    public String max = "";
    public int playAsCounter = 0;
    public String[] playAsVals = new String[]{"Random", "White", "Black"};
    public int timeCounter = 2;
    public int[] timeVals = new int[]{1, 2, 3, 5, 7, 10, 14};
    public boolean creatingGame = false;
    public boolean createGameDone = false;
    public String errorMessage;
    public boolean failed = false;
    public boolean gameStarted = false;

    public CreateGameScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.createicon = Image.createImage((String)"/res/createicon.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
        this.checked = Image.createImage((String)"/res/checked.png");
        this.unchecked = Image.createImage((String)"/res/unchecked.png");
    }

    public void draw(Graphics graphics, long l) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.handleInput();
        int n = this.smallBoldFont.getHeight();
        int n2 = 3 * n / 2;
        Theme.drawFader(this.canvas, graphics, 0, n2 - 4);
        int n3 = this.smallBoldFont.stringWidth("Start New Game") + 20;
        graphics.drawImage(this.createicon, this.canvas.width / 2 - n3 / 2, 2, 20);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        graphics.drawString("Start New Game", this.canvas.width / 2 - n3 / 2 + 18, 2, 20);
        int n4 = n2 + n;
        if (this.direct && this.selectedY < 4 || !this.direct && this.selectedY < 5) {
            graphics.setColor(205, 205, 185);
            graphics.fillRect(2, n4 - 4 + this.selectedY * n2, this.canvas.width - 4, n + 6);
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        int n5 = this.smallBoldFont.stringWidth("Direct Chal.:");
        graphics.drawString("Direct Chal.:", 5, n4, 20);
        graphics.drawImage(this.unchecked, 5 + n5 + 10, n4, 20);
        if (this.direct) {
            graphics.drawImage(this.checked, 5 + n5 + 10, n4, 20);
        }
        graphics.drawString("Per Move:", 5, n4 + n2, 20);
        graphics.drawString("" + this.timeVals[this.timeCounter] + (this.timeCounter > 0 ? " Days" : " Day"), 5 + n5 + 15, n4 + n2, 20);
        graphics.drawRect(5 + n5 + 10, n4 + n2 - 1, this.canvas.width - 5 - (5 + n5 + 10), n);
        graphics.drawString("I Play As:", 5, n4 + 2 * n2, 20);
        graphics.drawString(this.playAsVals[this.playAsCounter], 5 + n5 + 15, n4 + 2 * n2, 20);
        graphics.drawRect(5 + n5 + 10, n4 + 2 * n2 - 1, this.canvas.width - 5 - (5 + n5 + 10), n);
        if (this.direct) {
            graphics.drawString("Opponent:", 5, n4 + 3 * n2, 20);
            graphics.drawString(this.opponentName, 5 + n5 + 15, n4 + 3 * n2, 20);
            graphics.drawRect(5 + n5 + 10, n4 + 3 * n2 - 1, this.canvas.width - 5 - (5 + n5 + 10), n);
        } else {
            graphics.drawString("Min Rating:", 5, n4 + 3 * n2, 20);
            graphics.drawString(this.min, 5 + n5 + 15, n4 + 3 * n2, 20);
            graphics.drawRect(5 + n5 + 10, n4 + 3 * n2 - 1, this.canvas.width - 5 - (5 + n5 + 10), n);
            graphics.drawString("Max Rating:", 5, n4 + 4 * n2, 20);
            graphics.drawString(this.max, 5 + n5 + 15, n4 + 4 * n2, 20);
            graphics.drawRect(5 + n5 + 10, n4 + 4 * n2 - 1, this.canvas.width - 5 - (5 + n5 + 10), n);
        }
        if (this.creatingGame) {
            String string = "Creating Game";
            graphics.setFont(this.smallBoldFont);
            int n6 = this.smallBoldFont.stringWidth(string + "..");
            if (l / 1000L % 3L == 0L) {
                Theme.drawConfirmation(this.canvas, graphics, string + ".", this.canvas.width / 2 - n6 / 2, null);
            } else if (l / 1000L % 3L == 1L) {
                Theme.drawConfirmation(this.canvas, graphics, string + "..", this.canvas.width / 2 - n6 / 2, null);
            } else if (l / 1000L % 3L == 2L) {
                Theme.drawConfirmation(this.canvas, graphics, string + "...", this.canvas.width / 2 - n6 / 2, null);
            }
        }
        if (this.failed) {
            Theme.drawErrorCentered(this.canvas, graphics, this.errorMessage, this.errorMark);
        } else if (this.createGameDone) {
            if (this.gameStarted) {
                Theme.drawConfirmationCentered(this.canvas, graphics, "New Game Started.", null);
            } else {
                Theme.drawConfirmationCentered(this.canvas, graphics, "Challenge Created.", null);
            }
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n / 2 + 4, 3 * n / 2 - 4);
        if (this.direct && this.selectedY == 4 || !this.direct && this.selectedY == 5) {
            graphics.setColor(185, 185, 165);
            if (this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.failed) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.createGameDone) {
            graphics.drawString("OK", 5, this.canvas.height - 2, 36);
        } else {
            if (!this.createReady) {
                graphics.setColor(170, 170, 170);
            }
            graphics.drawString("Create", 5, this.canvas.height - 2, 36);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Back", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (!this.failed && !this.createGameDone) {
            if (keys.up) {
                --this.selectedY;
                if (this.selectedY < 0) {
                    this.selectedY = 0;
                }
            } else if (keys.down) {
                ++this.selectedY;
                if (this.direct && this.selectedY >= 4) {
                    this.selectedY = 4;
                    if (this.selectedY == 4 && !this.createReady) {
                        this.selectedX = 1;
                    }
                }
                if (!this.direct && this.selectedY >= 5) {
                    this.selectedY = 5;
                    if (this.selectedY == 5 && !this.createReady) {
                        this.selectedX = 1;
                    }
                }
            } else if (keys.left) {
                if (this.direct && this.selectedY == 4 && this.createReady) {
                    this.selectedX = 0;
                } else if (!this.direct && this.selectedY == 5 && this.createReady) {
                    this.selectedX = 0;
                }
            } else if (keys.right) {
                this.selectedX = 1;
            }
        }
        if (keys.fire) {
            if (this.failed) {
                this.failed = false;
                this.errorMessage = null;
                this.selectedX = 1;
            } else if (this.createGameDone) {
                this.createGameDone = false;
                this.selectedX = 1;
            } else {
                this.handlePressed();
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (!this.failed && !this.createGameDone) {
            this.gotoGamesListScreen();
        }
    }

    private void handleLeftMenu() {
        if (this.failed) {
            this.failed = false;
            this.errorMessage = null;
        } else if (this.createGameDone) {
            this.createGameDone = false;
        } else if (this.createReady) {
            this.submit();
        }
    }

    private void submit() {
        this.creatingGame = true;
        this.createGameDone = false;
        this.gameStarted = false;
        this.selectedX = 0;
        this.selectedY = this.direct ? 4 : 5;
        this.createGame();
    }

    private void createGame() {
        CreateGameThread createGameThread = new CreateGameThread(this.canvas, this);
        createGameThread.start();
    }

    public void setOpponentName(String string) {
        this.opponentName = string;
        this.checkReady();
    }

    public void setMin(String string) {
        this.min = string;
        this.checkReady();
    }

    public void setMax(String string) {
        this.max = string;
        this.checkReady();
    }

    private void checkReady() {
        this.createReady = this.direct ? !"".equals(this.opponentName.trim()) : true;
    }

    private void handlePressed() {
        switch (this.selectedY) {
            case 0: {
                this.direct = !this.direct;
                this.checkReady();
                break;
            }
            case 1: {
                ++this.timeCounter;
                if (this.timeCounter != this.timeVals.length) break;
                this.timeCounter = 0;
                break;
            }
            case 2: {
                ++this.playAsCounter;
                if (this.playAsCounter != this.playAsVals.length) break;
                this.playAsCounter = 0;
                break;
            }
            case 3: {
                if (this.direct) {
                    this.canvas.setOpponentDisplayable(this.opponentName);
                    break;
                }
                this.canvas.setMinDisplayable(this.min);
                break;
            }
            case 4: {
                if (this.direct) {
                    this.handlePressedActions();
                    break;
                }
                this.canvas.setMaxDisplayable(this.max);
                break;
            }
            case 5: {
                if (this.direct) break;
                this.handlePressedActions();
            }
        }
    }

    private void handlePressedActions() {
        if (this.selectedX == 0) {
            this.handleLeftMenu();
        } else {
            this.handleRightMenu();
        }
    }

    private void gotoGamesListScreen() {
        this.canvas.setScreen(this.canvas.gamesListScreen);
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.selectedX = 0;
        this.selectedY = 0;
        this.errorMessage = null;
        this.failed = false;
        this.creatingGame = false;
        this.createGameDone = false;
        this.gameStarted = false;
        this.direct = true;
        this.opponentName = "";
        this.min = "";
        this.max = "";
        this.timeCounter = 2;
        this.playAsCounter = 0;
        this.creatingGame = false;
    }
}

