/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.chessboard.ChessGame;
import com.chess.input.Keys;
import com.chess.internet.RefreshThread;
import com.chess.screens.AnalysisScreen;
import com.chess.screens.BoardScreen;
import com.chess.screens.CreateGameScreen;
import com.chess.screens.IScreen;
import com.chess.screens.SeekGameScreen;
import com.chess.screens.SettingsScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GamesListScreen
implements IScreen,
Runnable {
    private ChesscomCanvas canvas;
    private Image mygamesicon;
    private Image errorMark;
    private Image online;
    private Image chess960;
    private Font smallBoldFont;
    private Font smallFont;
    private int selectedY = 0;
    private int selectedX = 0;
    private int menuSelected = 0;
    private boolean menu = false;
    private boolean about = false;
    public boolean secureAccepted = false;
    public boolean gettingGames = false;
    public ChessGame[] chessGames;
    public int numberOfGames = 0;
    private boolean firstInit = true;
    private boolean getGames = true;
    public boolean showVersion = false;
    public boolean failed = false;
    public String errorMessage;
    public String membershipLevel;
    public boolean viewAllGames = false;

    public GamesListScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.mygamesicon = Image.createImage((String)"/res/mygamesicon.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
        this.online = Image.createImage((String)"/res/online.png");
        this.chess960 = Image.createImage((String)"/res/chess960.png");
    }

    public void draw(Graphics graphics, long l) {
        int n;
        int n2;
        int n3;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        int n4 = this.smallBoldFont.getHeight();
        int n5 = 3 * n4 / 2;
        Theme.drawFader(this.canvas, graphics, 0, n5 - 4);
        int n6 = this.smallBoldFont.stringWidth("Games") + 16;
        graphics.drawImage(this.mygamesicon, this.canvas.width / 2 - n6 / 2, 2, 20);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        graphics.drawString("Games", this.canvas.width / 2 - n6 / 2 + 16, 2, 20);
        int n7 = 19 * this.canvas.width / 24 - this.smallBoldFont.stringWidth("time left") / 2;
        graphics.drawString("Opponent", 5, n5 + 2, 20);
        graphics.drawString("Time Left", n7, n5 + 2, 20);
        boolean bl = false;
        int n8 = this.canvas.height - 2 * n5 - n5 + 4;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.numberOfGames;
        int n12 = 0;
        if (this.numberOfGames * n5 > n8) {
            bl = true;
            n9 = n8 * n8 / (this.numberOfGames * n5);
            n10 = n8 * n5 / (this.numberOfGames * n5);
            n11 = n8 / n5;
            ++n11;
            if ((this.selectedY + 2) * n5 > n8) {
                n12 = ((this.selectedY + 2) * n5 - n8) / n5;
            }
            if (this.selectedY == this.numberOfGames) {
                --n12;
            }
        }
        graphics.setFont(this.smallFont);
        for (n3 = n12; n3 < n11 + n12; ++n3) {
            if (n3 >= this.numberOfGames) continue;
            if (n3 % 2 == 0) {
                graphics.setColor(235, 235, 215);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRect(0, 2 * n5 + (n3 - n12) * n5, this.canvas.width, n5);
            if (n3 == this.selectedY) {
                graphics.setColor(195, 195, 175);
                graphics.fillRect(0, 2 * n5 + (this.selectedY - n12) * n5, this.canvas.width, n5);
                graphics.setColor(0, 0, 0);
                graphics.drawRect(0, 2 * n5 + (this.selectedY - n12) * n5, this.canvas.width - 1, n5 - 1);
                graphics.drawRect(1, 2 * n5 + (this.selectedY - n12) * n5 + 1, this.canvas.width - 3, n5 - 3);
            }
            graphics.setColor(0, 0, 0);
            graphics.setClip(0, 0, n7 - 1, this.canvas.height);
            n2 = 0;
            if (this.chessGames[n3].chess960) {
                graphics.drawImage(this.chess960, 4, 2 * n5 + (n3 - n12) * n5 + 2, 20);
                n2 = 15;
            }
            graphics.drawString(this.chessGames[n3].opponent, 5 + n2, 2 * n5 + (n3 - n12) * n5 + 2, 20);
            n = this.smallFont.stringWidth(this.chessGames[n3].opponent);
            if (this.chessGames[n3].online) {
                graphics.drawImage(this.online, 5 + n + 1 + n2, 2 * n5 + (n3 - n12) * n5 + 4, 20);
            }
            graphics.setClip(0, 0, this.canvas.width, this.canvas.height);
            if (this.chessGames[n3].myMove) {
                graphics.drawString(this.chessGames[n3].timeLeft, 19 * this.canvas.width / 24, 2 * n5 + (n3 - n12) * n5 + 2, 17);
                continue;
            }
            graphics.drawString("Waiting", 19 * this.canvas.width / 24, 2 * n5 + (n3 - n12) * n5 + 2, 17);
        }
        if (this.numberOfGames == 0 && !this.gettingGames) {
            graphics.setColor(0, 0, 0);
            graphics.drawString("No games pending...", 5, 2 * n5 + 2, 20);
        }
        if (bl) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(this.canvas.width - 6, 2 * n5, 6, n8);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.canvas.width - 6, 2 * n5, 5, n8);
            graphics.setColor(195, 195, 175);
            graphics.fillRect(this.canvas.width - 5, 2 * n5 + n10 * n12, 4, n9);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.canvas.width - 6, 2 * n5 + n10 * n12, 5, n9 - 1);
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - n5 + 4, n5 - 4);
        if (this.selectedY == this.numberOfGames) {
            graphics.setColor(185, 185, 165);
            if (this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n4 / 2 + 6, this.canvas.width / 3, n4);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n4 / 2 + 6, this.canvas.width / 3, n4);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.menu) {
            graphics.drawString("Select", 5, this.canvas.height - 2, 36);
            graphics.drawString("Cancel", this.canvas.width - 5, this.canvas.height - 2, 40);
        } else if (this.about) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.failed) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.showVersion) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else {
            graphics.drawString("Menu", 5, this.canvas.height - 2, 36);
            graphics.drawString("Refresh", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
        if (this.about) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(10, n5 + 10, this.canvas.width - 20, this.canvas.height - 2 * n5 - 20);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(10, n5 + 10, this.canvas.width - 21, this.canvas.height - 2 * n5 - 21);
            graphics.drawImage(this.canvas.loginScreen.logo, this.canvas.width / 2 - 71, n5 + 20, 20);
            graphics.setFont(this.smallBoldFont);
            graphics.drawString("Chess.com Mobile Java", this.canvas.width / 2, n5 + 90, 17);
            graphics.drawString("Version 2.7", this.canvas.width / 2, 90 + 2 * n5, 17);
            graphics.drawString("mobile@chess.com", this.canvas.width / 2, 90 + 3 * n5, 17);
        }
        if (this.showVersion && !this.gettingGames) {
            String[] stringArray = new String[]{"There is a newer", "version of Mobile", "Chess available.", "Please go to", "http://Chess.com/mobile", "to update."};
            Theme.drawInformation(this.canvas, graphics, stringArray);
        }
        if (this.failed) {
            Theme.drawErrorCentered(this.canvas, graphics, this.errorMessage, this.errorMark);
        }
        if (this.gettingGames) {
            this.drawGettingGames(graphics, l);
        } else {
            this.handleInput();
        }
        if (this.menu) {
            n3 = this.smallBoldFont.stringWidth("Start New Game") + 50;
            n2 = 7 * n4 + 5;
            n = 2;
            int n13 = this.canvas.height - n5 + 2 - n2;
            graphics.setColor(255, 255, 255);
            graphics.fillRect(n, n13, n3, n2);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(n, n13, n3, n2);
            graphics.setColor(205, 205, 185);
            graphics.fillRect(n + 3, n13 + 3 + this.menuSelected * n4, n3 - 5, n4);
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallFont);
            graphics.drawString("Refresh Games", n + 6, n13 + 3, 20);
            graphics.drawString("Settings", n + 6, n13 + 3 + n4, 20);
            graphics.drawString("Start New Game", n + 6, n13 + 3 + 2 * n4, 20);
            graphics.drawString("Challenges", n + 6, n13 + 3 + 3 * n4, 20);
            graphics.drawString("Back to Login", n + 6, n13 + 3 + 4 * n4, 20);
            graphics.drawString("About", n + 6, n13 + 3 + 5 * n4, 20);
            graphics.drawString("Exit", n + 6, n13 + 3 + 6 * n4, 20);
        }
    }

    private void drawGettingGames(Graphics graphics, long l) {
        graphics.setFont(this.smallBoldFont);
        int n = this.smallBoldFont.stringWidth("Getting Games..");
        if (l / 500L % 3L == 0L) {
            Theme.drawConfirmation(this.canvas, graphics, "Getting Games.", this.canvas.width / 2 - n / 2, null);
        } else if (l / 500L % 3L == 1L) {
            Theme.drawConfirmation(this.canvas, graphics, "Getting Games..", this.canvas.width / 2 - n / 2, null);
        } else if (l / 500L % 3L == 2L) {
            Theme.drawConfirmation(this.canvas, graphics, "Getting Games...", this.canvas.width / 2 - n / 2, null);
        }
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (this.menu) {
            if (keys.up) {
                --this.menuSelected;
            }
            if (keys.down) {
                ++this.menuSelected;
            }
            if (this.menuSelected < 0) {
                this.menuSelected = 6;
            }
            if (this.menuSelected > 6) {
                this.menuSelected = 0;
            }
            if (keys.left) {
                --this.selectedX;
            }
            if (keys.right) {
                ++this.selectedX;
            }
            if (this.selectedX < 0) {
                this.selectedX = 0;
            }
            if (this.selectedX > 1) {
                this.selectedX = 1;
            }
        } else if (!(this.about || this.failed || this.showVersion)) {
            if (keys.up) {
                --this.selectedY;
            }
            if (keys.down) {
                ++this.selectedY;
            }
            if (this.selectedY < 0) {
                this.selectedY = this.numberOfGames;
            }
            if (this.selectedY > this.numberOfGames) {
                this.selectedY = 0;
            }
            if (keys.left) {
                --this.selectedX;
            }
            if (keys.right) {
                ++this.selectedX;
            }
            if (this.selectedX < 0) {
                this.selectedX = 0;
            }
            if (this.selectedX > 1) {
                this.selectedX = 1;
            }
        }
        if (keys.fire) {
            if (this.menu) {
                this.handleMenuPressed();
            } else {
                this.handlePressed();
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (this.menu) {
            this.menu = false;
        } else if (!(this.about || this.failed || this.showVersion)) {
            this.refresh();
        }
    }

    private void handleLeftMenu() {
        if (this.menu) {
            this.handleMenuPressed();
        } else if (this.about) {
            this.about = false;
        } else if (this.failed) {
            this.failed = false;
        } else if (this.showVersion) {
            this.showVersion = false;
        } else {
            this.menu = true;
        }
    }

    private void handleMenuPressed() {
        if (this.selectedX == 0) {
            switch (this.menuSelected) {
                case 0: {
                    this.menu = false;
                    this.refresh();
                    break;
                }
                case 1: {
                    this.gotoSettingsScreen();
                    break;
                }
                case 2: {
                    this.gotoCreateGamesScreen();
                    break;
                }
                case 3: {
                    this.gotoSeekGameScreen();
                    break;
                }
                case 4: {
                    this.gotoLoginScreen();
                    break;
                }
                case 5: {
                    this.menu = false;
                    this.about = true;
                    break;
                }
                case 6: {
                    this.canvas.midlet.destroy();
                }
            }
        } else {
            this.menu = false;
        }
    }

    private void handlePressed() {
        if (this.about) {
            this.about = false;
        } else if (this.showVersion) {
            this.showVersion = false;
        } else if (this.failed) {
            this.failed = false;
        } else if (this.selectedY == this.numberOfGames) {
            if (this.selectedX == 0) {
                this.handleLeftMenu();
            } else {
                this.handleRightMenu();
            }
        } else {
            this.gotoBoardScreen();
        }
    }

    public void init(Graphics graphics) {
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.failed = false;
        this.selectedY = 0;
        this.selectedX = 0;
        if (this.firstInit) {
            try {
                this.canvas.boardScreen = new BoardScreen(this.canvas);
                this.canvas.boardScreen.membershipLevel = this.membershipLevel;
                this.canvas.analysisScreen = new AnalysisScreen(this.canvas);
                this.canvas.createGameScreen = new CreateGameScreen(this.canvas);
                this.canvas.seekGameScreen = new SeekGameScreen(this.canvas);
                this.canvas.settingsScreen = new SettingsScreen(this.canvas);
                this.canvas.settingsScreen.loadSettings();
                this.firstInit = false;
            }
            catch (IOException iOException) {
                System.out.println("Could not load screens. " + iOException.getMessage());
                this.errorMessage = iOException.getMessage();
                this.failed = true;
            }
        }
        if (this.getGames) {
            this.gettingGames = true;
            Thread thread = new Thread(this);
            thread.start();
        } else if (this.showVersion) {
            this.selectedY = this.numberOfGames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            System.out.println("Getting Games start...");
            this.chessGames = this.canvas.midlet.internet.getChessGamesList(this.viewAllGames);
            if (this.chessGames != null) {
                this.numberOfGames = this.chessGames.length - 1 + 1;
            }
            System.out.println("Getting Games end...");
            if (this.showVersion) {
                this.selectedY = this.numberOfGames;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not connect. " + iOException.getMessage());
            this.errorMessage = iOException.getMessage();
            this.failed = true;
        }
        finally {
            this.gettingGames = false;
        }
    }

    public void removeChessGame(int n) {
        if (!this.viewAllGames) {
            int n2;
            this.chessGames[n] = null;
            ChessGame[] chessGameArray = new ChessGame[this.chessGames.length - 1];
            int n3 = 0;
            for (n2 = 0; n2 < this.chessGames.length; ++n2) {
                ChessGame chessGame = this.chessGames[n2];
                if (chessGame == null) continue;
                chessGameArray[n3] = chessGame;
                ++n3;
            }
            this.chessGames = new ChessGame[chessGameArray.length];
            for (n2 = 0; n2 < this.chessGames.length; ++n2) {
                this.chessGames[n2] = chessGameArray[n2];
            }
            chessGameArray = null;
            --this.numberOfGames;
        } else {
            this.chessGames[n].myMove = false;
        }
    }

    private void gotoBoardScreen() {
        this.canvas.boardScreen.chessGameId = this.selectedY;
        this.canvas.boardScreen.chessGame = this.chessGames[this.selectedY];
        this.getGames = false;
        this.canvas.setScreen(this.canvas.boardScreen);
    }

    private void gotoLoginScreen() {
        this.menu = false;
        this.getGames = true;
        this.canvas.loginScreen.backFromGamesList = true;
        this.canvas.setScreen(this.canvas.loginScreen);
    }

    private void gotoSettingsScreen() {
        this.menu = false;
        this.getGames = false;
        this.canvas.setScreen(this.canvas.settingsScreen);
    }

    private void gotoCreateGamesScreen() {
        this.menu = false;
        this.getGames = false;
        this.canvas.setScreen(this.canvas.createGameScreen);
    }

    private void gotoSeekGameScreen() {
        this.menu = false;
        this.getGames = false;
        this.canvas.setScreen(this.canvas.seekGameScreen);
    }

    private void refresh() {
        this.gettingGames = true;
        RefreshThread refreshThread = new RefreshThread(this.canvas, this);
        refreshThread.start();
    }
}

