/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.input.Keys;
import com.chess.input.Pointer;
import com.chess.internet.LoginThread;
import com.chess.rms.StoreData;
import com.chess.screens.GamesListScreen;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LoginScreen
implements IScreen {
    private ChesscomCanvas canvas;
    public Image logo;
    private Image checked;
    private Image unchecked;
    private Image errorMark;
    private Font smallBoldFont;
    private Font smallFont;
    private int selectedY = 0;
    private int selectedX = 0;
    public boolean screenAutoLogin = false;
    public String screenUserName = "";
    public String screenPassword = "";
    public boolean autoLogin = false;
    public boolean backFromGamesList = false;
    private static final long DISPLAY_TIME = 2000L;
    private boolean displayLeftKeyMessage = false;
    private boolean displayRightKeyMessage = false;
    public boolean connecting = false;
    public boolean connected = false;
    public boolean failed = false;
    public String errorMessage = null;
    private boolean loginInProgress = false;

    public LoginScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.logo = Image.createImage((String)"/res/ccmobile.png");
        this.checked = Image.createImage((String)"/res/checked.png");
        this.unchecked = Image.createImage((String)"/res/unchecked.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
    }

    public void draw(Graphics graphics, long l) {
        if (this.canvas.midlet.securityMessage == null) {
            if (this.loginInProgress) {
                this.login(graphics);
            } else if (this.connecting) {
                graphics.setFont(this.smallBoldFont);
                int n = this.smallBoldFont.stringWidth("Connecting..");
                if (l / 500L % 3L == 0L) {
                    Theme.drawConfirmation(this.canvas, graphics, "Connecting.", this.canvas.width / 2 - n / 2, null);
                } else if (l / 500L % 3L == 1L) {
                    Theme.drawConfirmation(this.canvas, graphics, "Connecting..", this.canvas.width / 2 - n / 2, null);
                } else if (l / 500L % 3L == 2L) {
                    Theme.drawConfirmation(this.canvas, graphics, "Connecting...", this.canvas.width / 2 - n / 2, null);
                }
            } else if (!this.connected) {
                if (this.autoLogin && !this.failed) {
                    this.login(graphics);
                } else {
                    graphics.setColor(255, 255, 255);
                    graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
                    this.handleInput(graphics);
                    int n = this.smallBoldFont.getHeight();
                    int n2 = 65;
                    graphics.drawImage(this.logo, this.canvas.width / 2 - 71, 2, 20);
                    int n3 = 3 * n / 2;
                    if (this.selectedY < 3) {
                        graphics.setColor(205, 205, 185);
                        graphics.fillRect(2, n2 + 5 + this.selectedY * n3, this.canvas.width - 4, n + 5);
                    }
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(this.smallBoldFont);
                    int n4 = this.smallBoldFont.stringWidth("Auto Login:");
                    graphics.drawString("Username:", 5, n2 + 8, 20);
                    graphics.drawString(this.screenUserName, 5 + n4 + 15, n2 + 8, 20);
                    graphics.drawRect(5 + n4 + 10, n2 + 7, this.canvas.width - 5 - (5 + n4 + 10), n);
                    graphics.drawString("Password:", 5, n2 + 8 + n3, 20);
                    graphics.drawString(this.screenPassword, 5 + n4 + 15, n2 + 8 + n3, 20);
                    graphics.drawRect(5 + n4 + 10, n2 + 7 + n3, this.canvas.width - 5 - (5 + n4 + 10), n);
                    graphics.drawString("Auto login:", 5, n2 + 8 + n3 + n3, 20);
                    graphics.drawImage(this.unchecked, 5 + n4 + 10, n2 + 8 + n3 + n3, 20);
                    if (this.screenAutoLogin) {
                        graphics.drawImage(this.checked, 5 + n4 + 10, n2 + 8 + n3 + n3, 20);
                    }
                    Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n / 2 + 4, 3 * n / 2 - 4);
                    if (this.selectedY == 3) {
                        graphics.setColor(185, 185, 165);
                        if (this.selectedX == 0) {
                            graphics.fillRect(1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
                        } else {
                            graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
                        }
                    }
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(this.smallBoldFont);
                    if (this.failed) {
                        graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
                    } else {
                        graphics.drawString("Login", 5, this.canvas.height - 2, 36);
                    }
                    graphics.drawString("Exit", this.canvas.width - 5, this.canvas.height - 2, 40);
                    graphics.setFont(this.smallFont);
                    graphics.drawString("Signup at www.Chess.com", this.canvas.width / 2, this.canvas.height - 3 * n + 1, 33);
                    graphics.drawString("for FREE online & mobile play!", this.canvas.width / 2, this.canvas.height - 2 * n, 33);
                    if (this.canvas.customLeftKey != -6 && !this.displayLeftKeyMessage) {
                        this.displayLeftKeyMessage = true;
                        this.canvas.resetTime();
                    }
                    if (this.displayLeftKeyMessage && l < 2000L) {
                        Theme.drawConfirmationCentered(this.canvas, graphics, "Left menu key set to " + this.canvas.customLeftKey, null);
                    }
                    if (this.canvas.customRightKey != -7 && !this.displayRightKeyMessage) {
                        this.displayRightKeyMessage = true;
                        this.canvas.resetTime();
                    }
                    if (this.displayRightKeyMessage && l < 2000L) {
                        Theme.drawConfirmationCentered(this.canvas, graphics, "Right menu key set to " + this.canvas.customRightKey, null);
                    }
                    if (this.failed) {
                        Theme.drawErrorCentered(this.canvas, graphics, this.errorMessage, this.errorMark);
                    }
                }
            } else if (this.connected) {
                this.gotoGamesListScreen();
            }
        } else {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
            int n = this.smallBoldFont.getHeight();
            this.handleExitInput();
            Theme.drawErrorCentered(this.canvas, graphics, this.canvas.midlet.securityMessage, this.errorMark);
            graphics.setColor(185, 185, 165);
            graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallBoldFont);
            graphics.drawString("Exit", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
    }

    private void handleExitInput() {
        Keys keys = this.canvas.getKeys();
        Pointer pointer = this.canvas.getPointer();
        if (keys.menuRight || keys.fire || pointer.fire) {
            this.canvas.midlet.destroy();
        }
    }

    private void handleInput(Graphics graphics) {
        Keys keys = this.canvas.getKeys();
        Pointer pointer = this.canvas.getPointer();
        if (keys.up) {
            --this.selectedY;
        }
        if (keys.down) {
            ++this.selectedY;
        }
        if (this.selectedY < 0) {
            this.selectedY = 0;
        }
        if (this.selectedY > 3) {
            this.selectedY = 3;
        }
        if (keys.left) {
            --this.selectedX;
        }
        if (keys.right) {
            ++this.selectedX;
        }
        if (this.selectedX < 0) {
            this.selectedX = 0;
        }
        if (this.selectedX > 1) {
            this.selectedX = 1;
        }
        if (keys.fire || pointer.fire) {
            if (this.failed) {
                this.failed = false;
            } else {
                if (pointer.x != -1 || pointer.y != -1) {
                    int n = this.smallBoldFont.getHeight();
                    int n2 = 65;
                    int n3 = 3 * n / 2;
                    if (pointer.y > this.canvas.height - 3 * n / 2 + 4) {
                        this.selectedY = 3;
                        this.selectedX = pointer.x > this.canvas.width / 2 ? 1 : 0;
                    } else if (pointer.y > n2 + 8 && pointer.y < n2 + 8 + n3) {
                        this.selectedY = 0;
                    } else if (pointer.y > n2 + 8 + n3 && pointer.y < n2 + 8 + n3 + n3) {
                        this.selectedY = 1;
                    } else if (pointer.y > n2 + 8 + n3 + n3 && pointer.y < n2 + 8 + n3 + n3 + n3) {
                        this.selectedY = 2;
                    }
                }
                this.handlePressed(graphics);
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu(graphics);
        } else if (keys.menuRight) {
            this.canvas.midlet.destroy();
        }
    }

    private void handleLeftMenu(Graphics graphics) {
        if (this.failed) {
            this.failed = false;
        } else {
            this.login(graphics);
        }
    }

    private void handlePressed(Graphics graphics) {
        switch (this.selectedY) {
            case 0: {
                this.canvas.setUserNameDisplayable(this.screenUserName);
                break;
            }
            case 1: {
                this.canvas.setPasswordDisplayable();
                break;
            }
            case 2: {
                this.screenAutoLogin = !this.screenAutoLogin;
                break;
            }
            case 3: {
                if (this.selectedX == 0) {
                    this.handleLeftMenu(graphics);
                    break;
                }
                this.canvas.midlet.destroy();
            }
        }
    }

    private void login(Graphics graphics) {
        this.loginInProgress = true;
        if (!this.canvas.midlet.securityChecked) {
            graphics.setFont(this.smallBoldFont);
            Theme.drawConfirmationCentered(this.canvas, graphics, "Connecting..", null);
            this.canvas.midlet.requestSecurityCheck = true;
        } else {
            this.connecting = true;
            this.loginInProgress = false;
            LoginThread loginThread = new LoginThread(this.canvas, this);
            loginThread.start();
        }
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.connecting = false;
        this.connected = false;
        this.failed = false;
        this.selectedY = 0;
        this.selectedX = 0;
        if (!this.backFromGamesList) {
            try {
                this.canvas.gamesListScreen = new GamesListScreen(this.canvas);
                StoreData storeData = this.canvas.midlet.store.loadAccountInfo();
                if (storeData.valid) {
                    this.screenUserName = storeData.userName;
                    this.screenPassword = "******";
                    this.screenAutoLogin = storeData.autoLogin;
                    this.canvas.midlet.textBox.textUserName.setString(storeData.userName);
                    this.canvas.midlet.textBox.textPassword.setString(storeData.password);
                    this.autoLogin = storeData.autoLogin;
                }
            }
            catch (IOException iOException) {
                System.out.println("Could not create games list screen " + iOException);
            }
        } else {
            this.autoLogin = false;
        }
    }

    private void gotoGamesListScreen() {
        StoreData storeData = new StoreData();
        storeData.userName = this.canvas.midlet.textBox.textUserName.getString();
        storeData.password = this.canvas.midlet.textBox.textPassword.getString();
        storeData.autoLogin = this.screenAutoLogin;
        this.canvas.midlet.store.saveAccountInfo(storeData);
        this.canvas.setScreen(this.canvas.gamesListScreen);
    }
}

