/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.input.Keys;
import com.chess.internet.MessageThread;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MessageScreen
implements IScreen {
    private ChesscomCanvas canvas;
    private Image messageicon;
    private Image errorMark;
    public String chessId;
    public String timeStamp;
    public String opponentName;
    public String myName;
    private Font smallBoldFont;
    private Font smallFont;
    private int selectedX = 0;
    private int selectedY = 0;
    public boolean messageReady = false;
    private boolean scroll = false;
    public String message;
    public String[] lines;
    public int startLine = 0;
    public boolean gettingMessages = false;
    public boolean sendingMessage = false;
    public String errorMessage;
    public boolean failed = false;

    public MessageScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.messageicon = Image.createImage((String)"/res/messageicon.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
    }

    public void draw(Graphics graphics, long l) {
        int n;
        int n2;
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        if (!this.gettingMessages && !this.sendingMessage) {
            this.handleInput();
        }
        int n3 = this.smallBoldFont.getHeight();
        int n4 = 3 * n3 / 2;
        Theme.drawFader(this.canvas, graphics, 0, n4 - 4);
        int n5 = this.smallBoldFont.stringWidth("Messages") + 20;
        graphics.drawImage(this.messageicon, this.canvas.width / 2 - n5 / 2, 2, 20);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        graphics.drawString("Messages", this.canvas.width / 2 - n5 / 2 + 18, 2, 20);
        int n6 = this.canvas.height - (n4 + 5) - (n4 + 9) - (n4 + 10) - 18;
        graphics.drawRect(5, n4 + 5 + 9, this.canvas.width - 10, n6);
        if (this.lines != null && this.lines.length > 0) {
            n2 = n6 + n4 + 5 + 9 - n3 - 2;
            n = n6 / n3;
            if (n < this.lines.length) {
                this.scroll = true;
                if (n + this.startLine > this.lines.length) {
                    this.startLine = this.lines.length - n;
                }
            } else {
                this.scroll = false;
                this.startLine = 0;
            }
            for (int i = 0; i < n; ++i) {
                String string;
                if (i >= this.lines.length || (string = this.lines[i + this.startLine]) == null) continue;
                graphics.setFont(this.smallBoldFont);
                int n7 = 0;
                int n8 = n2 - i * n3;
                String string2 = this.opponentName + ": ";
                String string3 = this.myName + ": ";
                if (string.length() > string2.length() && string2.equals(string.substring(0, string2.length()))) {
                    n7 = this.smallBoldFont.stringWidth(string2);
                    graphics.setColor(132, 132, 132);
                    graphics.drawString(string2, 8, n8, 20);
                    string = string.substring(string2.length());
                } else if (string.length() > string3.length() && string3.equals(string.substring(0, string3.length()))) {
                    n7 = this.smallBoldFont.stringWidth(string3);
                    graphics.setColor(0, 51, 129);
                    graphics.drawString(string3, 8, n8, 20);
                    string = string.substring(string3.length());
                }
                graphics.setColor(0, 0, 0);
                graphics.setFont(this.smallFont);
                graphics.drawString(string, 8 + n7, n8, 20);
            }
        }
        graphics.setColor(205, 205, 185);
        if (this.selectedY == 0) {
            graphics.fillRect(this.canvas.width / 2 - 7, n4 + 4, 14, 8);
        } else if (this.selectedY == 1) {
            graphics.fillRect(this.canvas.width / 2 - 7, n4 + 5 + 9 + n6 + 2, 14, 8);
        } else if (this.selectedY == 2) {
            graphics.fillRect(2, n4 + 5 + 18 + n6 + 3, this.canvas.width - 4, n3 + 6);
        }
        if (this.scroll) {
            graphics.setColor(0, 0, 0);
            graphics.drawLine(this.canvas.width / 2, n4 + 5, this.canvas.width / 2 - 6, n4 + 11);
            graphics.drawLine(this.canvas.width / 2, n4 + 5, this.canvas.width / 2 + 6, n4 + 11);
            graphics.drawLine(this.canvas.width / 2 - 6, n4 + 11, this.canvas.width / 2 + 6, n4 + 11);
            graphics.drawLine(this.canvas.width / 2, n4 + 5 + 9 + n6 + 9, this.canvas.width / 2 - 6, n4 + 5 + 9 + n6 + 3);
            graphics.drawLine(this.canvas.width / 2, n4 + 5 + 9 + n6 + 9, this.canvas.width / 2 + 6, n4 + 5 + 9 + n6 + 3);
            graphics.drawLine(this.canvas.width / 2 - 6, n4 + 5 + 9 + n6 + 3, this.canvas.width / 2 + 6, n4 + 5 + 9 + n6 + 3);
        }
        graphics.setColor(0, 0, 0);
        graphics.drawRect(5, n4 + 5 + 18 + n6 + 5, this.canvas.width - 10, n3);
        if (this.message != null) {
            if (this.smallFont.stringWidth(this.message) > this.canvas.width - 16) {
                n2 = this.message.length() - 4;
                while (this.smallFont.stringWidth(this.message.substring(0, n2)) > this.canvas.width - 16) {
                    if ((n2 -= 4) > 0) continue;
                    n2 = 1;
                    break;
                }
                graphics.drawString(this.message.substring(0, n2) + "...", 8, n4 + 5 + 18 + n6 + 5, 20);
            } else {
                graphics.drawString(this.message, 8, n4 + 5 + 18 + n6 + 5, 20);
            }
        }
        if (this.gettingMessages || this.sendingMessage) {
            String string = this.gettingMessages ? "Getting Messages" : "Sending Message";
            graphics.setFont(this.smallBoldFont);
            n = this.smallBoldFont.stringWidth(string + "..");
            if (l / 500L % 3L == 0L) {
                Theme.drawConfirmation(this.canvas, graphics, string + ".", this.canvas.width / 2 - n / 2, null);
            } else if (l / 500L % 3L == 1L) {
                Theme.drawConfirmation(this.canvas, graphics, string + "..", this.canvas.width / 2 - n / 2, null);
            } else if (l / 500L % 3L == 2L) {
                Theme.drawConfirmation(this.canvas, graphics, string + "...", this.canvas.width / 2 - n / 2, null);
            }
        }
        if (this.failed) {
            Theme.drawErrorCentered(this.canvas, graphics, this.errorMessage, this.errorMark);
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n3 / 2 + 4, 3 * n3 / 2 - 4);
        if (this.selectedY == 3) {
            graphics.setColor(185, 185, 165);
            if (this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n3 / 2 + 6, this.canvas.width / 3, n3);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n3 / 2 + 6, this.canvas.width / 3, n3);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.failed) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else {
            if (!this.messageReady) {
                graphics.setColor(170, 170, 170);
            }
            graphics.drawString("Enter", 5, this.canvas.height - 2, 36);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Back", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
    }

    private String[] getLines(String string) {
        String string2 = this.getName(string);
        int n = (this.smallFont.stringWidth(string.substring(1)) + this.smallBoldFont.stringWidth(string2 + ": ")) / (this.canvas.width - 16);
        String[] stringArray = new String[++n];
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4 = 0;
            if (i == 0) {
                n4 = this.smallBoldFont.stringWidth(string2 + ": ");
            }
            while (this.smallFont.stringWidth(string.substring(n2, n3)) < this.canvas.width - 16 - n4 && ++n3 <= string.length()) {
            }
            if (i == 0) {
                stringArray[0] = string2 + ": " + string.substring(1, n3 - 1);
            } else {
                stringArray[i] = string.substring(n2, n3 - 1);
            }
            n2 = n3 - 1;
        }
        return stringArray;
    }

    private String getName(String string) {
        String string2 = null;
        string2 = "0".equals(string.substring(0, 1)) ? this.myName : this.opponentName;
        return string2;
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (keys.up) {
            if (this.scroll) {
                --this.selectedY;
                if (this.selectedY < 0) {
                    this.selectedY = 0;
                }
            } else {
                this.selectedY = 2;
            }
        } else if (keys.down) {
            if (this.scroll) {
                ++this.selectedY;
                if (this.selectedY > 3) {
                    this.selectedY = 3;
                }
            } else {
                this.selectedY = 3;
            }
            if (!this.messageReady) {
                this.selectedX = 1;
            }
        } else if (keys.left) {
            if (this.selectedY == 3 && this.messageReady) {
                this.selectedX = 0;
            }
        } else if (keys.right) {
            this.selectedX = 1;
        }
        if (keys.fire) {
            if (this.failed) {
                this.failed = false;
                this.errorMessage = null;
            } else {
                this.handlePressed();
            }
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (!this.failed) {
            this.gotoBoardScreen();
        }
    }

    private void handleLeftMenu() {
        if (this.failed) {
            this.failed = false;
            this.errorMessage = null;
        } else if (this.messageReady) {
            this.submit();
        }
    }

    private void submit() {
        this.sendingMessage = true;
        this.getMessages();
    }

    private void getMessages() {
        MessageThread messageThread = new MessageThread(this.canvas, this);
        messageThread.start();
    }

    public void setMessages(String[] stringArray) {
        if (stringArray != null) {
            int n;
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                n2 += this.getLines(string).length;
            }
            this.lines = new String[n2];
            n = n2 - 1;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String[] stringArray2 = this.getLines(string);
                for (int j = 0; j < stringArray2.length; ++j) {
                    this.lines[n] = stringArray2[j];
                    --n;
                }
            }
        }
    }

    private void handlePressed() {
        if (this.selectedY == 3) {
            if (this.selectedX == 0) {
                this.handleLeftMenu();
            } else {
                this.handleRightMenu();
            }
        } else if (this.selectedY == 0) {
            ++this.startLine;
        } else if (this.selectedY == 1) {
            --this.startLine;
            if (this.startLine < 0) {
                this.startLine = 0;
            }
        } else {
            this.canvas.setMessageDisplayable(this.message);
        }
    }

    private void gotoBoardScreen() {
        this.canvas.setScreen(this.canvas.boardScreen);
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.selectedX = 0;
        this.selectedY = 2;
        this.messageReady = false;
        this.message = null;
        this.lines = null;
        this.scroll = false;
        this.gettingMessages = false;
        this.sendingMessage = false;
        this.errorMessage = null;
        this.failed = false;
        this.gettingMessages = true;
        this.getMessages();
    }
}

