/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.Seek;
import com.chess.input.Keys;
import com.chess.internet.AcceptSeekThread;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SeekGameScreen
implements IScreen,
Runnable {
    private ChesscomCanvas canvas;
    private Image seekicon;
    private Image errorMark;
    private Image chess960;
    private Font smallBoldFont;
    private Font smallFont;
    private int selectedX = 0;
    public int selectedY = 0;
    public boolean failed = false;
    public String errorMessage;
    public int numberOfSeeks = 0;
    private boolean gettingSeeks = false;
    public boolean acceptingSeek = false;
    public boolean seekAccepted = false;
    public boolean seekConfirm = false;
    public Seek[] seeks;
    public int acceptId;
    private int selAcceptId;

    public SeekGameScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.seekicon = Image.createImage((String)"/res/seekicon.png");
        this.errorMark = Image.createImage((String)"/res/errormark.png");
        this.chess960 = Image.createImage((String)"/res/chess960.png");
    }

    public void draw(Graphics graphics, long l) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        int n = this.smallBoldFont.getHeight();
        int n2 = 3 * n / 2;
        Theme.drawFader(this.canvas, graphics, 0, n2 - 4);
        int n3 = this.smallBoldFont.stringWidth("Open Seeks") + 16;
        graphics.drawImage(this.seekicon, this.canvas.width / 2 - n3 / 2, 2, 20);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        graphics.drawString("Challenges", this.canvas.width / 2 - n3 / 2 + 16, 2, 20);
        graphics.drawString("Opponent", 5, n2 + 2, 20);
        graphics.drawString("Play As", this.canvas.width / 2, n2 + 2, 20);
        graphics.drawString("Move", 3 * this.canvas.width / 4, n2 + 2, 20);
        boolean bl = false;
        int n4 = this.canvas.height - 2 * n2 - n2 + 4;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.numberOfSeeks;
        int n8 = 0;
        if (this.numberOfSeeks * n2 > n4) {
            bl = true;
            n5 = n4 * n4 / (this.numberOfSeeks * n2);
            n6 = n4 * n2 / (this.numberOfSeeks * n2);
            n7 = n4 / n2;
            ++n7;
            if ((this.selectedY + 2) * n2 > n4) {
                n8 = ((this.selectedY + 2) * n2 - n4) / n2;
            }
            if (this.selectedY == this.numberOfSeeks) {
                --n8;
            }
        }
        graphics.setFont(this.smallFont);
        for (int i = n8; i < n7 + n8; ++i) {
            if (i >= this.numberOfSeeks) continue;
            if (i % 2 == 0) {
                graphics.setColor(235, 235, 215);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRect(0, 2 * n2 + (i - n8) * n2, this.canvas.width, n2);
            if (i == this.selectedY) {
                graphics.setColor(195, 195, 175);
                graphics.fillRect(0, 2 * n2 + (this.selectedY - n8) * n2, this.canvas.width, n2);
                graphics.setColor(0, 0, 0);
                graphics.drawRect(0, 2 * n2 + (this.selectedY - n8) * n2, this.canvas.width - 1, n2 - 1);
                graphics.drawRect(1, 2 * n2 + (this.selectedY - n8) * n2 + 1, this.canvas.width - 3, n2 - 3);
            }
            graphics.setColor(0, 0, 0);
            graphics.setClip(0, 0, this.canvas.width / 2 - 1, this.canvas.height);
            int n9 = 0;
            if (this.seeks[i].chess960) {
                graphics.drawImage(this.chess960, 4, 2 * n2 + (i - n8) * n2 + 2, 20);
                n9 = 15;
            }
            graphics.drawString(this.seeks[i].opponent, 5 + n9, 2 * n2 + (i - n8) * n2 + 2, 20);
            graphics.setClip(0, 0, 3 * this.canvas.width / 4 - 1, this.canvas.height);
            graphics.drawString(this.seeks[i].iPlayAs, this.canvas.width / 2, 2 * n2 + (i - n8) * n2 + 2, 20);
            graphics.setClip(0, 0, this.canvas.width, this.canvas.height);
            graphics.drawString(this.seeks[i].perMove, 3 * this.canvas.width / 4, 2 * n2 + (i - n8) * n2 + 2, 20);
        }
        if (this.numberOfSeeks == 0 && !this.gettingSeeks) {
            graphics.setColor(0, 0, 0);
            graphics.drawString("No Open Seeks...", 5, 2 * n2 + 2, 20);
        }
        if (bl) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(this.canvas.width - 6, 2 * n2, 6, n4);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.canvas.width - 6, 2 * n2, 5, n4);
            graphics.setColor(195, 195, 175);
            graphics.fillRect(this.canvas.width - 5, 2 * n2 + n6 * n8, 4, n5);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.canvas.width - 6, 2 * n2 + n6 * n8, 5, n5 - 1);
        }
        Theme.drawFader(this.canvas, graphics, this.canvas.height - n2 + 4, n2 - 4);
        if (this.selectedY == this.numberOfSeeks) {
            graphics.setColor(185, 185, 165);
            if (this.failed || this.seekAccepted || this.seekConfirm && this.selectedX == 0) {
                graphics.fillRect(1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
            } else {
                graphics.fillRect(this.canvas.width - this.canvas.width / 3 - 1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        if (this.failed) {
            graphics.drawString("Cancel", 5, this.canvas.height - 2, 36);
        } else if (this.seekAccepted) {
            graphics.drawString("OK", 5, this.canvas.height - 2, 36);
        } else if (this.seekConfirm) {
            graphics.drawString("OK", 5, this.canvas.height - 2, 36);
            graphics.drawString("Cancel", this.canvas.width - 5, this.canvas.height - 2, 40);
        } else {
            if (this.selectedY == this.numberOfSeeks) {
                graphics.setColor(170, 170, 170);
            }
            graphics.drawString("Accept", 5, this.canvas.height - 2, 36);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Back", this.canvas.width - 5, this.canvas.height - 2, 40);
        }
        if (this.failed) {
            Theme.drawErrorCentered(this.canvas, graphics, this.errorMessage, this.errorMark);
        } else if (this.seekConfirm) {
            Theme.drawConfirmationCentered(this.canvas, graphics, "Accept Challenge?", null);
        } else if (this.seekAccepted) {
            Theme.drawConfirmationCentered(this.canvas, graphics, "New Game Started.", null);
        }
        if (this.gettingSeeks || this.acceptingSeek) {
            this.drawStatus(graphics, l);
        } else {
            this.handleInput();
        }
    }

    private void drawStatus(Graphics graphics, long l) {
        String string = "Getting Challenges.";
        if (this.acceptingSeek) {
            string = "Accepting Challenge.";
        }
        graphics.setFont(this.smallBoldFont);
        int n = this.smallBoldFont.stringWidth(string + ".");
        if (l / 500L % 3L == 0L) {
            Theme.drawConfirmation(this.canvas, graphics, string, this.canvas.width / 2 - n / 2, null);
        } else if (l / 500L % 3L == 1L) {
            Theme.drawConfirmation(this.canvas, graphics, string + ".", this.canvas.width / 2 - n / 2, null);
        } else if (l / 500L % 3L == 2L) {
            Theme.drawConfirmation(this.canvas, graphics, string + "..", this.canvas.width / 2 - n / 2, null);
        }
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        if (this.seekConfirm) {
            if (keys.left) {
                this.selectedX = 0;
            }
            if (keys.right) {
                this.selectedX = 1;
            }
        } else if (!this.failed && !this.seekAccepted) {
            if (keys.up) {
                --this.selectedY;
            }
            if (keys.down) {
                ++this.selectedY;
            }
            if (this.selectedY < 0) {
                this.selectedY = 0;
            }
            if (this.selectedY > this.numberOfSeeks) {
                this.selectedY = this.numberOfSeeks;
            }
        }
        if (keys.fire) {
            this.handlePressed();
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        } else if (keys.menuRight) {
            this.handleRightMenu();
        }
    }

    private void handleRightMenu() {
        if (this.seekConfirm) {
            this.seekConfirm = false;
        } else if (!this.failed && !this.seekAccepted) {
            this.gotoGamesListScreen();
        }
    }

    private void handleLeftMenu() {
        if (this.failed) {
            this.failed = false;
        } else if (this.seekAccepted) {
            this.seekAccepted = false;
            this.selectedX = 1;
        } else if (this.seekConfirm) {
            this.seekConfirm = false;
            this.accept();
        } else if (this.numberOfSeeks > 0 && this.selectedY != this.numberOfSeeks) {
            this.confirm();
        }
    }

    private void handlePressed() {
        if (this.failed) {
            this.failed = false;
        } else if (this.seekAccepted) {
            this.seekAccepted = false;
            this.selectedX = 1;
        } else if (this.selectedY == this.numberOfSeeks) {
            if (this.selectedX == 0) {
                this.handleLeftMenu();
            } else {
                this.handleRightMenu();
            }
        } else {
            this.confirm();
        }
    }

    private void confirm() {
        this.seekConfirm = true;
        this.selAcceptId = this.selectedY;
        this.selectedY = this.numberOfSeeks;
    }

    private void accept() {
        this.selectedY = this.numberOfSeeks;
        this.selectedX = 0;
        this.acceptingSeek = true;
        this.acceptId = this.seeks[this.selAcceptId].id;
        AcceptSeekThread acceptSeekThread = new AcceptSeekThread(this.canvas, this);
        acceptSeekThread.start();
    }

    public void init(Graphics graphics) {
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.acceptingSeek = false;
        this.seekAccepted = false;
        this.acceptId = -1;
        this.failed = false;
        this.selectedX = 1;
        this.selectedY = 0;
        this.selAcceptId = 0;
        this.numberOfSeeks = 0;
        this.seeks = null;
        this.gettingSeeks = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.seeks = this.canvas.midlet.internet.getSeeksList(-1);
            if (this.seeks != null) {
                this.numberOfSeeks = this.seeks.length - 1 + 1;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not connect. " + iOException.getMessage());
            this.errorMessage = iOException.getMessage();
            this.failed = true;
        }
        finally {
            this.gettingSeeks = false;
        }
    }

    private void gotoGamesListScreen() {
        this.canvas.setScreen(this.canvas.gamesListScreen);
    }
}

