/*
 * Decompiled with CFR 0.152.
 */
package com.chess.screens;

import com.chess.ChesscomCanvas;
import com.chess.input.Keys;
import com.chess.input.Pointer;
import com.chess.screens.IScreen;
import com.chess.screens.Theme;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SettingsScreen
implements IScreen {
    private ChesscomCanvas canvas;
    private Image settingsicon;
    private Font smallBoldFont;
    private int selectedY = 0;
    private static final int SETTINGS = 3;
    public int boardSizeCounter = 1;
    private String[] boardSize = new String[]{"Small", "Normal", "Large", "Very Large"};
    public boolean viewAllGames = false;
    public boolean analysisRules = true;

    public SettingsScreen(ChesscomCanvas chesscomCanvas) throws IOException {
        this.canvas = chesscomCanvas;
        this.settingsicon = Image.createImage((String)"/res/settingsicon.png");
    }

    public void draw(Graphics graphics, long l) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.handleInput();
        int n = this.smallBoldFont.getHeight();
        int n2 = 3 * n / 2;
        Theme.drawFader(this.canvas, graphics, 0, n2 - 4);
        int n3 = this.smallBoldFont.stringWidth("Settings") + 17;
        graphics.drawImage(this.settingsicon, this.canvas.width / 2 - n3 / 2, 1, 20);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallBoldFont);
        graphics.drawString("Settings", this.canvas.width / 2 - n3 / 2 + 17, 2, 20);
        if (this.selectedY < 3) {
            graphics.setColor(205, 205, 185);
            graphics.fillRect(2, n2 + 5 + this.selectedY * n2, this.canvas.width - 4, n + 5);
        }
        graphics.setColor(0, 0, 0);
        int n4 = this.smallBoldFont.stringWidth("Analysis Board:");
        graphics.drawString("Board Size:", 5, n2 + 8, 20);
        graphics.drawString(this.boardSize[this.boardSizeCounter], 5 + n4 + 20, n2 + 8, 20);
        graphics.drawString("View Games:", 5, 2 * n2 + 8, 20);
        graphics.drawString(this.viewAllGames ? "All" : "Pending", 5 + n4 + 20, 2 * n2 + 8, 20);
        graphics.drawString("Analysis Board:", 5, 3 * n2 + 8, 20);
        graphics.drawString(this.analysisRules ? "Rules On" : "Rules Off", 5 + n4 + 20, 3 * n2 + 8, 20);
        Theme.drawFader(this.canvas, graphics, this.canvas.height - 3 * n / 2 + 4, 3 * n / 2 - 4);
        if (this.selectedY == 3) {
            graphics.setColor(185, 185, 165);
            graphics.fillRect(1, this.canvas.height - 3 * n / 2 + 6, this.canvas.width / 3, n);
        }
        graphics.setColor(0, 0, 0);
        graphics.drawString("Back", 5, this.canvas.height - 2, 36);
    }

    private void handleInput() {
        Keys keys = this.canvas.getKeys();
        Pointer pointer = this.canvas.getPointer();
        if (keys.up) {
            --this.selectedY;
        }
        if (keys.down) {
            ++this.selectedY;
        }
        if (this.selectedY < 0) {
            this.selectedY = 0;
        }
        if (this.selectedY > 3) {
            this.selectedY = 3;
        }
        if (keys.fire || pointer.fire) {
            this.handlePressed();
        }
        if (this.selectedY < 3 && (keys.left || keys.right)) {
            this.handlePressed();
        }
        if (keys.menuLeft) {
            this.handleLeftMenu();
        }
    }

    private void handleLeftMenu() {
        this.gotoGamesListScreen();
    }

    private void handlePressed() {
        switch (this.selectedY) {
            case 0: {
                ++this.boardSizeCounter;
                if (this.boardSizeCounter <= this.boardSize.length - 1) break;
                this.boardSizeCounter = 0;
                break;
            }
            case 1: {
                this.viewAllGames = !this.viewAllGames;
                break;
            }
            case 2: {
                this.analysisRules = !this.analysisRules;
                break;
            }
            case 3: {
                this.gotoGamesListScreen();
            }
        }
    }

    public void init(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.smallBoldFont = Font.getFont((int)0, (int)1, (int)8);
    }

    public void loadSettings() {
        int n = Math.min(this.canvas.width, this.canvas.height);
        if (n >= 230) {
            this.boardSizeCounter = 1;
        }
        if (n >= 310) {
            this.boardSizeCounter = 2;
        }
        if (n >= 470) {
            this.boardSizeCounter = 3;
        }
        this.canvas.boardScreen.boardSize = this.boardSizeCounter;
        this.canvas.gamesListScreen.viewAllGames = false;
        this.canvas.analysisScreen.rules = true;
        try {
            String string = this.canvas.midlet.store.loadSettings();
            if (string != null) {
                if (string.length() >= 1) {
                    this.boardSizeCounter = "S".equals(string.substring(0, 1)) ? 0 : ("L".equals(string.substring(0, 1)) ? 2 : ("V".equals(string.substring(0, 1)) ? 3 : 1));
                    this.canvas.boardScreen.boardSize = this.boardSizeCounter;
                }
                if (string.length() >= 2) {
                    this.canvas.gamesListScreen.viewAllGames = this.viewAllGames = "A".equals(string.substring(1, 2));
                }
                if (string.length() >= 3) {
                    this.canvas.analysisScreen.rules = this.analysisRules = "N".equals(string.substring(2, 3));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Settings NOT loaded...");
        }
        this.saveSettings();
    }

    private void saveSettings() {
        try {
            String string = this.boardSize[this.boardSizeCounter].substring(0, 1) + (this.viewAllGames ? "A" : "P") + (this.analysisRules ? "N" : "F");
            this.canvas.midlet.store.saveSettings(string);
        }
        catch (Exception exception) {
            System.out.println("Settings NOT saved...");
        }
    }

    private void gotoGamesListScreen() {
        this.saveSettings();
        this.canvas.boardScreen.boardSize = this.boardSizeCounter;
        this.canvas.gamesListScreen.viewAllGames = this.viewAllGames;
        this.canvas.analysisScreen.rules = this.analysisRules;
        this.canvas.setScreen(this.canvas.gamesListScreen);
    }
}

