/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordStore;
import sheet.Backable;
import sheet.Cell;
import sheet.CellResize;
import sheet.Quitable;
import sheet.SheetShow;
import sheet.Table;

final class SheetShow
extends Canvas
implements CommandListener,
Backable {
    private static final short TBL_WIDTH = 10;
    private static final short TBL_HEIGHT = 9;
    private static final short M_CELL_DATA = 0;
    private static final short M_CELL_FORMAT = 1;
    private static final short M_RECALC = 2;
    private static final short M_FILE = 3;
    private static final short M_CANCEL = 4;
    private static final short M_HELP = 5;
    private static final short M_E_COLOUR = 6;
    private static final short M_E_ALIGN = 7;
    private static final short MCD_EDIT = 0;
    private static final short MCD_CLEAR = 1;
    private static final short MCD_COPY = 2;
    private static final short MCD_PASTE = 3;
    private static final short MCD_BACK = 4;
    private static final short MCF_SIZE = 0;
    private static final short MCF_COLOUR = 1;
    private static final short MCF_ALIGN = 2;
    private static final short MCF_BACK = 3;
    private static final short MFM_NEW = 0;
    private static final short MFM_LOAD = 1;
    private static final short MFM_SAVE = 2;
    private static final short MFM_EXIT = 3;
    private static final short MFM_BACK = 4;
    private static final Command[] COMMANDS = new Command[]{new Command("Cell Data", 1, 0), new Command("Cell Format", 1, 1), new Command("Recalculate", 1, 2), new Command("File", 1, 3), new Command("Cancel", 3, 4), new Command("Help", 5, 5)};
    private static final List[] MENUS = new List[]{new List("Cell Data", 3, new String[]{"Edit Cell", "Clear Cell", "Copy", "Paste", "Back to sheet"}, null), new List("Cell Format", 3, new String[]{"Cell Size", "Cell Colour", "Cell Alignment", "Back to sheet"}, null), null, new List("File", 3, new String[]{"New sheet", "Open", "Save", "Exit", "Back to sheet"}, null), null, null};
    private static final Command okCommand = new Command("Ok", 4, 1);
    private static final Command cancelCommand = new Command("Cancel", 3, 1);
    private static int appWidth;
    private static int appHeight;
    private static Display display;
    private static Quitable winQuit;
    private Table data;
    private Cell clipBoard;
    private boolean moved;

    public SheetShow() {
        int i = 0;
        while (i < COMMANDS.length) {
            this.addCommand(COMMANDS[i]);
            ++i;
        }
        appWidth = this.getWidth();
        appHeight = this.getHeight();
        this.data = this.newSheet();
        this.moved = true;
        try {
            Class.forName("sheet.Cell");
            Class.forName("sheet.Operation");
            Class.forName("sheet.CellCalc");
            Class.forName("sheet.CellCalc$IntegerStack");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void show(Display disp, Quitable toQuit) {
        winQuit = toQuit;
        display = disp;
        this.show();
    }

    public void show() {
        display.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, appWidth, appHeight);
        this.data.paint(g, appWidth, appHeight, 0);
    }

    private void actualSave(String fname) {
        try {
            this.data.save(fname);
            this.show();
        }
        catch (IllegalArgumentException e) {
            Alert err = new Alert("File error", e.getMessage(), null, AlertType.ERROR);
            display.setCurrent(err, (Displayable)this);
        }
    }

    private void actualLoad(String fname) {
        try {
            Table tmpdata;
            this.data = tmpdata = Table.load(fname);
            if (this.data != null) {
                this.data.calculate();
            }
            this.show();
        }
        catch (IllegalArgumentException e) {
            Alert err = new Alert("File error", e.getMessage(), null, AlertType.ERROR);
            display.setCurrent(err, (Displayable)this);
        }
    }

    private void showWait(final String message, final Runnable action) {
        Canvas wait = new Canvas(){

            protected void paint(Graphics g) {
                g.drawString(message, this.getWidth() / 2, this.getHeight() / 2, 17);
                display.callSerially(action);
            }
        };
        display.setCurrent((Displayable)wait);
    }

    private void save(final Runnable action) {
        TextBox fnameEdit = new TextBox("Enter sheet name", this.data.getName(), 32, 4);
        fnameEdit.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable obj) {
                if (cmd == okCommand) {
                    String fname = ((TextBox)obj).getString();
                    SheetShow.this.showWait("Saving...", new Runnable(this, fname){
                        private final /* synthetic */ String val$fname;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$fname = val$fname;
                        }

                        public void run() {
                            SheetShow.access$300(2.access$200(this.this$1), this.val$fname);
                            if (2.access$400(this.this$1) != null) {
                                2.access$400(this.this$1).run();
                            }
                        }
                    });
                } else {
                    SheetShow.this.show();
                }
            }

            static /* synthetic */ SheetShow access$200(2 x0) {
                return x0.SheetShow.this;
            }

            static /* synthetic */ Runnable access$400(2 x0) {
                return x0.action;
            }
        });
        fnameEdit.addCommand(okCommand);
        fnameEdit.addCommand(cancelCommand);
        display.setCurrent((Displayable)fnameEdit);
    }

    private void load() {
        SheetShow back = this;
        this.showWait("Reading...", new Runnable((Displayable)back){
            private final /* synthetic */ Displayable val$back;
            {
                this.val$back = val$back;
            }

            public void run() {
                try {
                    String[] nameList = RecordStore.listRecordStores();
                    Alert errAlert = new Alert("Info", "No files to open", null, AlertType.ERROR);
                    if (nameList != null) {
                        List list = new List("Open a sheet", 3, nameList, null);
                        Command deleteCommand = new Command("Delete", 1, 1);
                        list.setCommandListener(new CommandListener(this, deleteCommand, errAlert){
                            private final /* synthetic */ Command val$deleteCommand;
                            private final /* synthetic */ Alert val$errAlert;
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$deleteCommand = val$deleteCommand;
                                this.val$errAlert = val$errAlert;
                            }

                            public void commandAction(Command cmd, Displayable obj) {
                                List flist = (List)obj;
                                int idx = flist.getSelectedIndex();
                                if (cmd == SheetShow.access$100() || cmd == List.SELECT_COMMAND) {
                                    SheetShow.access$500(4.access$700(this.this$1), "Loading...", new Runnable(this, flist, idx){
                                        private final /* synthetic */ List val$flist;
                                        private final /* synthetic */ int val$idx;
                                        private final /* synthetic */ 5 this$2;
                                        {
                                            this.this$2 = this$2;
                                            this.val$flist = val$flist;
                                            this.val$idx = val$idx;
                                        }

                                        public void run() {
                                            SheetShow.access$800(4.access$700(5.access$600(this.this$2)), this.val$flist.getString(this.val$idx));
                                        }
                                    });
                                } else if (cmd == this.val$deleteCommand) {
                                    SheetShow.access$500(4.access$700(this.this$1), "Deleting...", new Runnable(this, flist, idx){
                                        private final /* synthetic */ List val$flist;
                                        private final /* synthetic */ int val$idx;
                                        private final /* synthetic */ 5 this$2;
                                        {
                                            this.this$2 = this$2;
                                            this.val$flist = val$flist;
                                            this.val$idx = val$idx;
                                        }

                                        public void run() {
                                            try {
                                                RecordStore.deleteRecordStore((String)this.val$flist.getString(this.val$idx));
                                                this.val$flist.delete(this.val$idx);
                                                if (this.val$flist.size() > 0) {
                                                    SheetShow.access$000().setCurrent((Displayable)this.val$flist);
                                                } else {
                                                    SheetShow.access$000().setCurrent(5.access$900(this.this$2), 4.access$1000(5.access$600(this.this$2)));
                                                }
                                            }
                                            catch (Exception e) {
                                                Alert err = new Alert("File error", e.getMessage(), null, AlertType.ERROR);
                                                SheetShow.access$000().setCurrent(err, (Displayable)this.val$flist);
                                            }
                                        }
                                    });
                                } else {
                                    4.access$700(this.this$1).show();
                                }
                            }

                            static /* synthetic */ 4 access$600(5 x0) {
                                return x0.this$1;
                            }

                            static /* synthetic */ Alert access$900(5 x0) {
                                return x0.val$errAlert;
                            }
                        });
                        list.addCommand(okCommand);
                        list.addCommand(cancelCommand);
                        list.addCommand(deleteCommand);
                        display.setCurrent((Displayable)list);
                    } else {
                        display.setCurrent(errAlert, this.val$back);
                    }
                }
                catch (Exception e) {
                    Alert err = new Alert("File error", e.getMessage(), null, AlertType.ERROR);
                    display.setCurrent(err, this.val$back);
                }
            }

            static /* synthetic */ SheetShow access$700(4 x0) {
                return x0.SheetShow.this;
            }

            static /* synthetic */ Displayable access$1000(4 x0) {
                return x0.val$back;
            }
        });
    }

    private void checkModified(final Runnable action) {
        if (this.data.isChanged()) {
            final Command yesCommand = new Command("Yes", 1, 1);
            final Command noCommand = new Command("No", 1, 1);
            Form wantsave = new Form("Warning");
            wantsave.append((Item)new StringItem(null, "The data was modified. Save?"));
            wantsave.setCommandListener(new CommandListener(){

                public void commandAction(Command cmd, Displayable obj) {
                    if (cmd == yesCommand) {
                        SheetShow.this.save(action);
                    } else if (cmd == noCommand) {
                        action.run();
                    } else {
                        SheetShow.this.show();
                    }
                }
            });
            wantsave.addCommand(yesCommand);
            wantsave.addCommand(noCommand);
            wantsave.addCommand(cancelCommand);
            display.setCurrent((Displayable)wantsave);
        } else {
            action.run();
        }
    }

    public void keyPressed(int code) {
        int key = this.getGameAction(code);
        switch (key) {
            case 1: {
                this.data.moveCursor(1);
                this.moved = true;
                break;
            }
            case 6: {
                this.data.moveCursor(2);
                this.moved = true;
                break;
            }
            case 2: {
                this.data.moveCursor(3);
                this.moved = true;
                break;
            }
            case 5: {
                this.data.moveCursor(4);
                this.moved = true;
                break;
            }
            case 8: {
                Cell cur = this.data.getCurrentCell(false);
                Alert details = cur != null ? new Alert(cur.getName() + " details", cur.getDetails(), null, null) : new Alert("Details", "This cell is empty", null, null);
                this.moved = true;
                details.setTimeout(-2);
                display.setCurrent(details, (Displayable)this);
                break;
            }
            default: {
                if (code == -12) {
                    this.menuAction((short)3, (short)3);
                    this.moved = true;
                    break;
                }
                if (code == 35) {
                    this.data.getCurrentCell(true).edit(null, this, display);
                    break;
                }
                if (code == 42 && this.moved) {
                    code = 61;
                    this.data.getCurrentCell(true).edit(String.valueOf((char)code), this, display);
                    this.data.moveCursor(2);
                    break;
                }
                if (code == 42) {
                    code = 8;
                }
                this.moved = !this.data.getCurrentCell(true).appendChar((char)code, this.moved);
            }
        }
        this.repaint();
    }

    private void setSubmenu(Displayable parent, final short menuIdx) {
        final SheetShow sheet = this;
        parent.setCommandListener(new CommandListener(){

            public void commandAction(Command cmd, Displayable obj) {
                short opt = (short)((List)obj).getSelectedIndex();
                sheet.menuAction(menuIdx, opt);
            }
        });
    }

    public void commandAction(Command cmd, Displayable obj) {
        short menuIdx = (short)cmd.getPriority();
        this.moved = true;
        if (MENUS[menuIdx] != null) {
            this.setSubmenu((Displayable)MENUS[menuIdx], menuIdx);
            display.setCurrent((Displayable)MENUS[menuIdx]);
        } else {
            this.menuAction(menuIdx, (short)0);
        }
    }

    private Table newSheet() {
        Font fnt = Font.getFont((int)64, (int)0, (int)8);
        short defw = (short)fnt.stringWidth("0000");
        short defh = (short)(fnt.getHeight() + 1);
        this.clipBoard = null;
        return new Table(10, 9, defw, defh);
    }

    public void menuAction(short menu, short opt) {
        switch (menu) {
            case 2: {
                this.showWait("Calculating...", new Runnable(){

                    public void run() {
                        SheetShow.this.data.calculate();
                        SheetShow.this.show();
                    }
                });
                break;
            }
            case 4: {
                this.show();
                break;
            }
            case 0: {
                switch (opt) {
                    case 0: {
                        this.data.getCurrentCell(true).edit(null, this, display);
                        break;
                    }
                    case 1: {
                        this.data.clearCurrentCell();
                        this.show();
                        break;
                    }
                    case 2: {
                        this.clipBoard = this.data.getCurrentCell(false);
                        this.show();
                        break;
                    }
                    case 3: {
                        if (this.clipBoard != null) {
                            this.data.getCurrentCell(true).paste(this.clipBoard);
                        }
                    }
                    case 4: {
                        this.show();
                    }
                }
                break;
            }
            case 1: {
                switch (opt) {
                    case 0: {
                        CellResize resz = new CellResize(this.data, this);
                        display.setCurrent((Displayable)resz);
                        break;
                    }
                    case 1: {
                        List list = new List("Cell Colour", 3, Cell.colors, null);
                        this.setSubmenu((Displayable)list, (short)6);
                        display.setCurrent((Displayable)list);
                        break;
                    }
                    case 2: {
                        List list = new List("Cell Alignment", 3, Cell.aligns, null);
                        this.setSubmenu((Displayable)list, (short)7);
                        display.setCurrent((Displayable)list);
                        break;
                    }
                    case 3: {
                        this.show();
                    }
                }
                break;
            }
            case 5: {
                Alert scr = new Alert("Sheet help", "This is a small spreadsheet application capable of simple integer and string operations. You can find some hints in the Formula help (accessible from the formula editor).\n- To enter a numeric value, simply type the number ('*' serves as a backspace).\n- To enter a formula, press '*' key, then the formula editor will be opened with '=' pre-entered.\n- To simply edit a cell formula, press '#'.\n- Left softkey shows the full cell data.\n---\nMC, 2001", null, null);
                scr.setTimeout(-2);
                display.setCurrent(scr, (Displayable)this);
                break;
            }
            case 3: {
                switch (opt) {
                    case 0: {
                        this.checkModified(new Runnable(){

                            public void run() {
                                SheetShow.this.data = SheetShow.this.newSheet();
                                System.gc();
                                SheetShow.this.show();
                            }
                        });
                        break;
                    }
                    case 1: {
                        this.checkModified(new Runnable(){

                            public void run() {
                                SheetShow.this.load();
                            }
                        });
                        break;
                    }
                    case 2: {
                        this.save(null);
                        break;
                    }
                    case 3: {
                        this.checkModified(new Runnable(){

                            public void run() {
                                winQuit.quit();
                            }
                        });
                        break;
                    }
                    case 4: {
                        this.show();
                    }
                }
                break;
            }
            case 6: {
                this.data.getCurrentCell(true).setColor(opt);
                this.show();
                break;
            }
            case 7: {
                this.data.getCurrentCell(true).setAlign(opt);
                this.show();
            }
        }
    }

    static /* synthetic */ void access$300(SheetShow x0, String x1) {
        x0.actualSave(x1);
    }

    static /* synthetic */ void access$800(SheetShow x0, String x1) {
        x0.actualLoad(x1);
    }
}

