/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import org.j4me.logging.Log;

class BluetoothDeviceDiscovery
implements DiscoveryListener {
    public static final int INQUIRY_IN_PROGRESS = -1;
    public static final int SERVICE_SEARCH_IN_PROGRESS = -1;
    private DiscoveryAgent discoveryAgent;
    private Vector discoveredDevices = new Vector();
    private Vector services = new Vector();
    private int deviceDiscoveryResult = -1;
    private int serviceSearchResult = -1;

    BluetoothDeviceDiscovery() {
    }

    public String[][] discoverNearbyDeviceNamesAndAddresses() throws IOException, SecurityException {
        this.doDiscoverDevices();
        while (this.getDeviceDiscoveryResult() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (this.getDeviceDiscoveryResult() != 0) {
            throw new IOException("Search for Bluetooth devices failed (code " + this.getDeviceDiscoveryResult() + ").");
        }
        Vector vector = this.getDiscoveredDevices();
        Enumeration enumeration = vector.elements();
        String[][] stringArray = new String[vector.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            RemoteDevice remoteDevice = (RemoteDevice)enumeration.nextElement();
            String string = remoteDevice.getFriendlyName(false);
            String string2 = remoteDevice.getBluetoothAddress();
            if (string == null) {
                string = string2;
            }
            String[] stringArray2 = new String[]{string, string2};
            stringArray[n] = stringArray2;
            ++n;
        }
        return stringArray;
    }

    public void doDiscoverDevices() throws BluetoothStateException {
        Log.debug("Starting Bluetooth device discovery");
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        this.discoveryAgent = localDevice.getDiscoveryAgent();
        this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
    }

    public void doDiscoverService(RemoteDevice remoteDevice) throws BluetoothStateException {
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        this.discoveryAgent.searchServices(nArray, new UUID[]{new UUID(256L)}, remoteDevice, (DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        Log.debug("Discovered device " + remoteDevice.getBluetoothAddress());
        this.discoveredDevices.addElement(remoteDevice);
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (Log.isInfoEnabled()) {
            Log.info("Found services " + serviceRecordArray.length);
        }
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            ServiceRecord serviceRecord = serviceRecordArray[i];
            this.services.addElement(serviceRecord);
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        this.serviceSearchResult = n2;
    }

    public void inquiryCompleted(int n) {
        this.deviceDiscoveryResult = n;
    }

    public Vector getDiscoveredDevices() {
        return this.discoveredDevices;
    }

    public RemoteDevice getDeviceByFriendlyName(String string) throws IOException {
        Enumeration enumeration = this.discoveredDevices.elements();
        RemoteDevice remoteDevice = null;
        while (enumeration.hasMoreElements() && !(remoteDevice = (RemoteDevice)enumeration.nextElement()).getFriendlyName(false).equals(string)) {
        }
        return remoteDevice;
    }

    public ServiceRecord getFirstDiscoveredService() {
        if (this.services.size() > 0) {
            return (ServiceRecord)this.services.elementAt(0);
        }
        return null;
    }

    public int getDeviceDiscoveryResult() {
        return this.deviceDiscoveryResult;
    }

    public String getDeviceDiscoveryResultAsString() {
        switch (this.deviceDiscoveryResult) {
            case 0: {
                return "Completed";
            }
            case 7: {
                return "Error";
            }
            case 5: {
                return "Terminated";
            }
        }
        return "Unknown Code";
    }

    public int getServiceSearchResult() {
        return this.serviceSearchResult;
    }

    public String getServiceSearchResultAsString() {
        switch (this.serviceSearchResult) {
            case 1: {
                return "Completed";
            }
            case 2: {
                return "Terminated";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "No Records";
            }
            case 6: {
                return "Device Not Reachable";
            }
        }
        return "Unknown Code";
    }

    public static String findChannelId(ServiceRecord serviceRecord) {
        DataElement dataElement = serviceRecord.getAttributeValue(4);
        Enumeration enumeration = (Enumeration)dataElement.getValue();
        while (enumeration.hasMoreElements()) {
            DataElement dataElement2 = (DataElement)enumeration.nextElement();
            Enumeration enumeration2 = (Enumeration)dataElement2.getValue();
            DataElement dataElement3 = (DataElement)enumeration2.nextElement();
            if (!dataElement3.getValue().equals(new UUID(3L))) continue;
            DataElement dataElement4 = (DataElement)enumeration2.nextElement();
            int n = (int)dataElement4.getLong();
            return Integer.toString(n);
        }
        return null;
    }
}

