/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;
import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.BluetoothReadTimeoutThread;
import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.NMEAParser;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.logging.Log;
import org.j4me.util.ConnectorHelper;

class BluetoothGPS
implements Runnable {
    private static final short BLUETOOTH_TIMEOUT = 3000;
    private static final short BREAK = 500;
    private static final short DISCONNECT_WAIT = 1000;
    public static final short SLEEP_BEFORE_READ = 100;
    public static final short READ_TIMEOUT = 3100;
    public static final short BLUETOOTH_CONNECTION_INIT_SLEEP = 200;
    private static final float MS_PER_KNOT = 0.5144445f;
    private static final int[] MONTH_OFFSET = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private StreamConnection connection;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread runner;
    private boolean stop = false;
    private String url;
    private LocationListener locationListener;
    private final BluetoothLocationProvider locationProvider;
    private long locationUpdateInterval;
    private long lastLocationUpdateTime;
    private Location location;

    public BluetoothGPS(BluetoothLocationProvider bluetoothLocationProvider, String string) {
        this.locationProvider = bluetoothLocationProvider;
        this.url = string;
    }

    public Location getLastKnownLocation() {
        return this.location;
    }

    private synchronized void connect() throws ConnectionNotFoundException, IOException, SecurityException {
        if (!this.isConnected()) {
            Log.info("Connecting to Bluetooth device at " + this.url);
            this.connection = (StreamConnection)ConnectorHelper.open(this.url, 3, 3000);
            Log.debug("Bluetooth connection established");
            this.configureBluetoothGPSSettings(this.connection);
            this.inputStream = this.connection.openInputStream();
            this.outputStream = this.connection.openOutputStream();
        }
    }

    private void configureBluetoothGPSSettings(StreamConnection streamConnection) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,00,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,02,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,04,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,01,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,03,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,05,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,06,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,07,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,08,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,09,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,10,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,,2"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPGGA,1"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPGSA,1"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPRMC,1"));
                this.outputStream.flush();
                Log.debug("Configured GPS device settings");
            }
            catch (IOException iOException) {
                Log.warn("Could not send configuration sentences to Bluetooth GPS", iOException);
            }
        }
    }

    public static byte[] createSentence(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n ^= byArray[i];
        }
        String string2 = Integer.toHexString(n);
        string2 = string2.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('$');
        stringBuffer.append(string);
        stringBuffer.append('*');
        stringBuffer.append(string2);
        stringBuffer.append("\r\n");
        String string3 = stringBuffer.toString();
        byte[] byArray2 = string3.getBytes();
        return byArray2;
    }

    private synchronized void disconnect() {
        Log.debug("Disconnecting from GPS device");
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            Log.warn("Problem closing GPS connection", iOException);
        }
        this.inputStream = null;
        this.outputStream = null;
        this.connection = null;
    }

    public synchronized boolean isConnected() {
        return this.connection != null && this.inputStream != null;
    }

    public void reacquireFix() {
        if (this.outputStream != null) {
            try {
                String string = "PSRF104,0,0,0,0,0,0,12,2";
                if (this.location != null && this.location.isValid()) {
                    QualifiedCoordinates qualifiedCoordinates = this.location.getQualifiedCoordinates();
                    long l = this.location.getTimestamp() - 936921587000L;
                    long l2 = l / 604800000L;
                    long l3 = l % 604800000L / 1000L;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("PSRF104,");
                    stringBuffer.append(qualifiedCoordinates.getLatitude());
                    stringBuffer.append(",");
                    stringBuffer.append(qualifiedCoordinates.getLongitude());
                    stringBuffer.append(",");
                    stringBuffer.append(Float.isNaN(qualifiedCoordinates.getAltitude()) ? 0.0f : qualifiedCoordinates.getAltitude());
                    stringBuffer.append(",0,");
                    stringBuffer.append(l3);
                    stringBuffer.append(",");
                    stringBuffer.append(l2);
                    stringBuffer.append(",12,3");
                    string = stringBuffer.toString();
                }
                this.outputStream.write(BluetoothGPS.createSentence(string));
            }
            catch (IOException iOException) {
                Log.warn("Could not re-acquire Bluetooth GPS fix", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        boolean bl2 = false;
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        NMEAParser nMEAParser = new NMEAParser();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BluetoothReadTimeoutThread bluetoothReadTimeoutThread = new BluetoothReadTimeoutThread(this.runner, 3100);
        boolean bl3 = true;
        while (bl) {
            BluetoothGPS bluetoothGPS;
            try {
                if (this.stop) {
                    this.stop();
                    return;
                }
                if (!this.isConnected()) {
                    this.connect();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                byArray = new byte[2048];
                if (bl3) {
                    bluetoothReadTimeoutThread.start();
                    bl3 = false;
                } else {
                    bluetoothReadTimeoutThread.restart();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = this.inputStream.read(byArray, 0, 2048);
                if (n2 < 0) {
                    throw new IOException("Bluetooth device closed connection");
                }
                bluetoothReadTimeoutThread.setReadSuccess(true);
                if (bl2 && n2 >= 2048 && n < 4) {
                    nMEAParser.flush();
                    n = (short)(n + 1);
                    continue;
                }
                bl2 = false;
                n = 0;
                try {
                    int n3 = nMEAParser.parse(byArray, n2);
                    if ((n3 & 1) != 0) {
                        bl2 = true;
                        this.processRecord(nMEAParser.getRecordBuffer());
                        bluetoothGPS = this;
                        synchronized (bluetoothGPS) {
                            try {
                                this.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (n3 != -1) continue;
                    bluetoothGPS = this;
                    synchronized (bluetoothGPS) {
                        try {
                            this.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    Log.warn("Problem parsing GPS data", throwable);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedIOException) {
                    Log.info("Bluetooth GPS stalled.  Disconnecting and reconnecting.");
                } else if (throwable instanceof IOException) {
                    Log.info("Bluetooth device dropped connection.  Reconnecting.");
                } else if (throwable instanceof InterruptedException) {
                    bl = false;
                } else {
                    Log.warn("Unexpected GPS read error", throwable);
                }
                this.setProviderState(2);
                this.disconnect();
                bluetoothGPS = this;
                synchronized (bluetoothGPS) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                nMEAParser.flush();
            }
        }
    }

    private void processRecord(GPSRecord gPSRecord) {
        block8: {
            if (gPSRecord == null || gPSRecord.quality == null) {
                return;
            }
            if (gPSRecord.quality.equals("1") || gPSRecord.quality.equals("2") || gPSRecord.quality.equals("3")) {
                try {
                    long l;
                    float f = gPSRecord.altitude == null ? Float.NaN : Float.parseFloat(gPSRecord.altitude);
                    float f2 = Float.parseFloat(gPSRecord.hdop);
                    float f3 = Float.parseFloat(gPSRecord.vdop);
                    float f4 = Float.parseFloat(gPSRecord.speed);
                    f4 *= 0.5144445f;
                    float f5 = gPSRecord.course == null ? Float.NaN : Float.parseFloat(gPSRecord.course);
                    float f6 = BluetoothGPS.convertToDegress(gPSRecord.lattitude, gPSRecord.lattitudeDirection);
                    float f7 = BluetoothGPS.convertToDegress(gPSRecord.longitude, gPSRecord.longitudeDirection);
                    QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(f6, f7, f, f2, f3);
                    long l2 = BluetoothGPS.convertUTCTime(gPSRecord.date, gPSRecord.secondsSinceMidnight);
                    this.location = new LocationImpl(qualifiedCoordinates, f4, f5, l2);
                    this.setProviderState(1);
                    if (this.locationListener == null || (l = System.currentTimeMillis()) - this.lastLocationUpdateTime < this.locationUpdateInterval) break block8;
                    this.lastLocationUpdateTime = l;
                    try {
                        this.locationListener.locationUpdated(this.locationProvider, this.location);
                    }
                    catch (Throwable throwable) {
                        Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + this.location, throwable);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                this.setProviderState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviderState(int n) {
        if (this.locationProvider.getState() != n) {
            this.locationProvider.setState(n);
            if (this.locationListener != null) {
                try {
                    this.locationListener.providerStateChanged(this.locationProvider, n);
                }
                catch (Throwable throwable) {
                    Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + n, throwable);
                }
            }
            BluetoothGPS bluetoothGPS = this;
            synchronized (bluetoothGPS) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static float convertToDegress(String string, char c) {
        int n;
        if (string != null && (n = string.indexOf(46)) > 0) {
            int n2 = n - 2;
            float f = Float.parseFloat(string.substring(0, n2));
            float f2 = Float.parseFloat(string.substring(n2));
            float f3 = f2 / 60.0f;
            float f4 = f + f3;
            if (c == 'S' || c == 's') {
                return f4 * -1.0f;
            }
            if (c == 'W' || c == 'w') {
                return f4 * -1.0f;
            }
            return f4;
        }
        return 0.0f;
    }

    public static long convertUTCTime(String string, String string2) {
        if (string == null || string2 == null) {
            return System.currentTimeMillis();
        }
        double d = Double.parseDouble(string2);
        int n = (int)(d *= 1000.0);
        int n2 = Integer.parseInt(string.substring(0, 2));
        int n3 = Integer.parseInt(string.substring(2, 4));
        int n4 = Integer.parseInt(string.substring(4, 6));
        long l = 10957L;
        l += (long)(n4 * 365);
        l += (long)((n4 - 1) / 4 + 1);
        l += (long)MONTH_OFFSET[n3 - 1];
        if (n4 % 4 == 0 && n3 >= 3) {
            ++l;
        }
        long l2 = (l += (long)n2) * 86400000L;
        return l2 += (long)n;
    }

    public synchronized void start() throws IOException {
        this.connect();
        if (this.runner == null) {
            this.stop = false;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.runner != null) {
            if (Thread.currentThread() == this.runner) {
                this.runner = null;
                this.disconnect();
                this.setProviderState(2);
            } else {
                this.stop = true;
                this.runner.interrupt();
            }
        } else {
            this.disconnect();
        }
        BluetoothGPS bluetoothGPS = this;
        synchronized (bluetoothGPS) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.locationListener = locationListener;
        this.locationUpdateInterval = n < 1 ? 1000L : (long)(n * 1000);
    }
}

