/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import org.j4me.bluetoothgps.BluetoothGPS;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.logging.Log;

class BluetoothLocationProvider
extends LocationProvider {
    private static final String BLUETOOTH_PROTOCOL = "btspp://";
    private static final String BLUETOOTH_GPS_OPTIONS = ";master=false;encrypt=false;authenticate=false";
    private static BluetoothLocationProvider instance = null;
    private BluetoothGPS gps = null;
    private String bluetoothURL = null;
    private int state = 2;

    public static LocationProvider getInstance(Criteria criteria) throws LocationException, IOException {
        if (instance != null) {
            throw new LocationException("Bluetooth GPS socket already in use.");
        }
        if (BluetoothLocationProvider.matchesCriteria(criteria)) {
            String string = criteria.getRemoteDeviceAddress();
            return BluetoothLocationProvider.getInstance(string);
        }
        return null;
    }

    private BluetoothLocationProvider(String string, String string2) throws ConnectionNotFoundException, IOException, SecurityException {
        if (string2 == null) {
            for (int i = 1; i <= 2; ++i) {
                try {
                    this.bluetoothURL = BluetoothLocationProvider.constructBTURL(string, Integer.toString(i));
                    this.gps = this.connect(this.bluetoothURL);
                    break;
                }
                catch (IOException iOException) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Channel ID = " + i + " failed:  " + iOException.toString());
                    }
                    if (i != 2) continue;
                    throw iOException;
                }
            }
        } else {
            this.bluetoothURL = BluetoothLocationProvider.constructBTURL(string, string2);
            this.gps = this.connect(this.bluetoothURL);
        }
    }

    public static boolean matchesCriteria(Criteria criteria) {
        if (criteria.getHorizontalAccuracy() < 1) {
            return false;
        }
        if (criteria.isAltitudeRequired() && criteria.getVerticalAccuracy() < 1) {
            return false;
        }
        if (criteria.getPreferredResponseTime() > 500 && criteria.getPreferredResponseTime() < 500) {
            return false;
        }
        if (criteria.getPreferredPowerConsumption() == 1) {
            return false;
        }
        if (criteria.isAddressInfoRequired()) {
            return false;
        }
        return criteria.getRemoteDeviceAddress() != null;
    }

    public static BluetoothLocationProvider getInstance(String string) throws ConnectionNotFoundException, IOException, SecurityException {
        if (instance == null) {
            instance = new BluetoothLocationProvider(string, null);
        }
        return instance;
    }

    private BluetoothGPS connect(String string) throws ConnectionNotFoundException, IOException, SecurityException {
        BluetoothGPS bluetoothGPS = new BluetoothGPS(this, string);
        bluetoothGPS.start();
        return bluetoothGPS;
    }

    protected static String constructBTURL(String string, String string2) {
        if (string2 == null || string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.substring(0, BLUETOOTH_PROTOCOL.length()).equalsIgnoreCase(BLUETOOTH_PROTOCOL)) {
            stringBuffer.append(BLUETOOTH_PROTOCOL);
        }
        stringBuffer.append(string);
        if (string.indexOf(58, BLUETOOTH_PROTOCOL.length() + 1) < 0) {
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        if (string.indexOf(59) < 0) {
            stringBuffer.append(BLUETOOTH_GPS_OPTIONS);
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public Location getLocation(int n) throws LocationException, InterruptedException {
        Location location;
        if (n == 0 || n < -1) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis();
        n *= 1000;
        do {
            if (this.state == 3 || this.gps == null) {
                throw new LocationException("Bluetooth location provider is out of service");
            }
            location = this.gps.getLastKnownLocation();
            if (location != null) continue;
            Thread.sleep(250L);
            if (System.currentTimeMillis() - l <= (long)n) continue;
            throw new LocationException("Timed out getting location from Bluetooth location provider");
        } while (location == null);
        return location;
    }

    protected Location getLastKnownLocationToProvider() {
        return this.gps.getLastKnownLocation();
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.gps.setLocationListener(locationListener, n, n2, n3);
    }

    public String getBluetoothURL() {
        return this.bluetoothURL;
    }

    public void reset() throws IOException {
        if (this.gps != null) {
            this.gps.reacquireFix();
            this.gps.setProviderState(2);
        }
    }

    public void close() {
        if (this.gps != null) {
            this.gps.stop();
            this.state = 3;
            this.gps.setLocationListener(null, -1, -1, -1);
        }
    }
}

