/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.util.MathFunc;

public class Coordinates {
    private static final double METERS_PER_RADIAN = 6371000.0;
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    private float altitude;
    private double latitude;
    private double longitude;

    public Coordinates(double d, double d2, float f) {
        this.setLatitude(d);
        this.setLongitude(d2);
        this.setAltitude(f);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float f) {
        this.altitude = f;
    }

    public void setLatitude(double d) {
        if (Double.isNaN(d) || d < -90.0 || d >= 90.0) {
            throw new IllegalArgumentException("Latitude (" + d + ") is invalid.");
        }
        this.latitude = d;
    }

    public void setLongitude(double d) {
        if (Double.isNaN(d) || d < -180.0 || d >= 180.0) {
            throw new IllegalArgumentException("Longitude (" + d + ") is invalid.");
        }
        this.longitude = d;
    }

    public float azimuthTo(Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("azimuthTo does not accept a null parameter.");
        }
        double d = Math.toRadians(this.latitude);
        double d2 = Math.toRadians(this.longitude);
        double d3 = Math.toRadians(coordinates.latitude);
        double d4 = Math.toRadians(coordinates.longitude);
        double d5 = d4 - d2;
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d5) * d6;
        double d8 = Math.cos(d) * Math.sin(d3) - Math.sin(d) * d6 * Math.cos(d5);
        double d9 = MathFunc.atan2(d7, d8);
        double d10 = Math.toDegrees(d9);
        d10 = (360.0 + d10) % 360.0;
        return (float)d10;
    }

    public float distance(Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("distance does not accept a null parameter.");
        }
        double d = Math.toRadians(this.latitude);
        double d2 = Math.toRadians(this.longitude);
        double d3 = Math.toRadians(coordinates.latitude);
        double d4 = Math.toRadians(coordinates.longitude);
        double d5 = Math.sin((d - d3) / 2.0);
        double d6 = d5 * d5;
        double d7 = Math.cos(d) * Math.cos(d3);
        double d8 = Math.sin((d2 - d4) / 2.0);
        double d9 = d8 * d8;
        double d10 = d6 + d7 * d9;
        double d11 = 2.0 * MathFunc.asin(Math.sqrt(d10));
        double d12 = 6371000.0 * d11;
        return (float)d12;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Coordinates)) {
            return false;
        }
        Coordinates coordinates = (Coordinates)object;
        if (this.latitude < coordinates.latitude - 1.0E-6 || this.latitude > coordinates.latitude + 1.0E-6) {
            return false;
        }
        if (this.longitude < coordinates.longitude - 1.0E-6 || this.longitude > coordinates.longitude + 1.0E-6) {
            return false;
        }
        if (Float.isNaN(this.altitude) && !Float.isNaN(coordinates.altitude)) {
            return false;
        }
        if (!Float.isNaN(this.altitude) && Float.isNaN(coordinates.altitude)) {
            return false;
        }
        if (Float.isNaN(this.altitude) && Float.isNaN(coordinates.altitude)) {
            return true;
        }
        return !((double)this.altitude < (double)coordinates.altitude - 1.0E-6) && !((double)this.altitude > (double)coordinates.altitude + 1.0E-6);
    }

    public String toString() {
        String string;
        if (this.latitude >= 0.0) {
            string = String.valueOf(this.latitude);
            string = string + "\u00b0N ";
        } else {
            string = String.valueOf(-1.0 * this.latitude);
            string = string + "\u00b0S ";
        }
        if (this.longitude >= 0.0) {
            string = string + String.valueOf(this.longitude);
            string = string + "\u00b0E";
        } else {
            string = string + String.valueOf(-1.0 * this.longitude);
            string = string + "\u00b0W";
        }
        if (!Float.isNaN(this.altitude)) {
            string = string + " " + this.altitude + "m";
        }
        return string;
    }
}

