/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.collections.CubbyHole;
import org.j4me.logging.Log;

class JSR179LocationProvider
extends LocationProvider
implements Runnable {
    private final javax.microedition.location.LocationProvider original;
    private final CubbyHole update = new CubbyHole();
    private LocationListener locationListener;
    private final Thread worker = new Thread(this);
    private boolean hasBeenAvailable = false;
    private int lastState = 2;
    private int interval;
    private int timeout;
    private int maxAge;

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        try {
            javax.microedition.location.Criteria criteria2 = JSR179LocationProvider.convertCriteria(criteria);
            javax.microedition.location.LocationProvider locationProvider = javax.microedition.location.LocationProvider.getInstance((javax.microedition.location.Criteria)criteria2);
            if (locationProvider != null) {
                return new JSR179LocationProvider(locationProvider);
            }
        }
        catch (javax.microedition.location.LocationException locationException) {
            throw JSR179LocationProvider.convertLocationException(locationException);
        }
        return null;
    }

    private JSR179LocationProvider(javax.microedition.location.LocationProvider locationProvider) {
        this.original = locationProvider;
    }

    public int getState() {
        int n = this.original.getState();
        n = JSR179LocationProvider.convertAvailabilityStatusCode(this.lastState);
        return n;
    }

    public Location getLocation(int n) throws LocationException, InterruptedException {
        try {
            javax.microedition.location.Location location = this.original.getLocation(n);
            Location location2 = JSR179LocationProvider.convertLocation(location);
            return location2;
        }
        catch (javax.microedition.location.LocationException locationException) {
            throw JSR179LocationProvider.convertLocationException(locationException);
        }
    }

    protected Location getLastKnownLocationToProvider() {
        javax.microedition.location.Location location = javax.microedition.location.LocationProvider.getLastKnownLocation();
        Location location2 = JSR179LocationProvider.convertLocation(location);
        return location2;
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.locationListener = locationListener;
        this.interval = n;
        this.timeout = n2;
        this.maxAge = n3;
        if (this.original.getState() == 1) {
            this.hasBeenAvailable = true;
        }
        if (this.worker.isAlive()) {
            this.worker.interrupt();
        }
        if (locationListener == null) {
            this.original.setLocationListener(null, n, n2, n3);
        } else {
            this.lastState = 2;
            this.original.setLocationListener((javax.microedition.location.LocationListener)new JSR179Listener(), n, n2, n3);
            this.worker.start();
        }
    }

    public void reset() {
        this.original.reset();
        if (this.locationListener != null) {
            this.original.setLocationListener((javax.microedition.location.LocationListener)new JSR179Listener(), this.interval, this.timeout, this.maxAge);
        }
    }

    public void close() {
        this.reset();
        this.setLocationListener(null, -1, -1, -1);
        this.worker.interrupt();
    }

    public void run() {
        try {
            while (true) {
                Integer n;
                Object object;
                if ((object = this.update.get()) instanceof Integer) {
                    n = (Integer)object;
                    int n2 = n;
                    this.raiseStateChangeEvent(n2);
                    if (!this.hasBeenAvailable || n2 != 2) continue;
                    Thread.sleep(this.interval * 1000);
                    if (this.original.getState() != 2) continue;
                    Log.info("Resetting the location provider to get another fix");
                    this.reset();
                    continue;
                }
                n = (javax.microedition.location.Location)object;
                if (this.lastState != 1 && n.isValid()) {
                    this.raiseStateChangeEvent(1);
                }
                this.raiseLocationEvent((javax.microedition.location.Location)n);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void raiseStateChangeEvent(int n) {
        this.lastState = n;
        if (this.locationListener != null) {
            int n2 = JSR179LocationProvider.convertAvailabilityStatusCode(n);
            try {
                this.locationListener.providerStateChanged(this, n2);
            }
            catch (Throwable throwable) {
                Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + n2, throwable);
            }
        }
    }

    private void raiseLocationEvent(javax.microedition.location.Location location) {
        if (this.locationListener != null) {
            Location location2 = JSR179LocationProvider.convertLocation(location);
            try {
                this.locationListener.locationUpdated(this, location2);
            }
            catch (Throwable throwable) {
                Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + location2, throwable);
            }
        }
    }

    protected static LocationException convertLocationException(javax.microedition.location.LocationException locationException) {
        LocationException locationException2 = new LocationException(locationException.getMessage());
        return locationException2;
    }

    protected static javax.microedition.location.Criteria convertCriteria(Criteria criteria) {
        javax.microedition.location.Criteria criteria2 = new javax.microedition.location.Criteria();
        criteria2.setAddressInfoRequired(criteria.isAddressInfoRequired());
        criteria2.setAltitudeRequired(criteria.isAltitudeRequired());
        criteria2.setCostAllowed(criteria.isAllowedToCost());
        criteria2.setHorizontalAccuracy(criteria.getHorizontalAccuracy());
        criteria2.setPreferredResponseTime(criteria.getPreferredResponseTime());
        criteria2.setSpeedAndCourseRequired(criteria.isSpeedAndCourseRequired());
        criteria2.setVerticalAccuracy(criteria.getVerticalAccuracy());
        int n = criteria.getPreferredPowerConsumption();
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
            }
        }
        criteria2.setPreferredPowerConsumption(n);
        return criteria2;
    }

    protected static QualifiedCoordinates convertQualifiedCoordinates(javax.microedition.location.QualifiedCoordinates qualifiedCoordinates) {
        if (qualifiedCoordinates == null) {
            return null;
        }
        double d = qualifiedCoordinates.getLatitude();
        double d2 = qualifiedCoordinates.getLongitude();
        float f = qualifiedCoordinates.getAltitude();
        float f2 = qualifiedCoordinates.getHorizontalAccuracy();
        float f3 = qualifiedCoordinates.getVerticalAccuracy();
        QualifiedCoordinates qualifiedCoordinates2 = new QualifiedCoordinates(d, d2, f, f2, f3);
        return qualifiedCoordinates2;
    }

    protected static Location convertLocation(javax.microedition.location.Location location) {
        LocationImpl locationImpl = null;
        if (location != null) {
            if (location.isValid()) {
                QualifiedCoordinates qualifiedCoordinates = JSR179LocationProvider.convertQualifiedCoordinates(location.getQualifiedCoordinates());
                locationImpl = new LocationImpl(qualifiedCoordinates, location.getSpeed(), location.getCourse(), location.getTimestamp());
            } else {
                locationImpl = new LocationImpl();
            }
        }
        return locationImpl;
    }

    protected static int convertAvailabilityStatusCode(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        return n2;
    }

    private final class JSR179Listener
    implements javax.microedition.location.LocationListener {
        private JSR179Listener() {
        }

        public void providerStateChanged(javax.microedition.location.LocationProvider locationProvider, int n) {
            if (n != 1) {
                Integer n2 = new Integer(n);
                JSR179LocationProvider.this.update.set(n2);
            }
        }

        public void locationUpdated(javax.microedition.location.LocationProvider locationProvider, javax.microedition.location.Location location) {
            JSR179LocationProvider.this.hasBeenAvailable = true;
            JSR179LocationProvider.this.update.set(location);
        }
    }
}

