/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.QualifiedCoordinates;

public class LocationImplTest
extends J4METestCase {
    public LocationImplTest() {
    }

    public LocationImplTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new LocationImplTest("testInvalid", new TestMethod(){

            public void run(TestCase testCase) {
                ((LocationImplTest)testCase).testInvalid();
            }
        }));
        testSuite.addTest(new LocationImplTest("testValid", new TestMethod(){

            public void run(TestCase testCase) {
                ((LocationImplTest)testCase).testValid();
            }
        }));
        return testSuite;
    }

    public void testInvalid() {
        LocationImpl locationImpl = new LocationImpl();
        this.assertTrue("Location is invalid.", !locationImpl.isValid());
        String string = ((Object)locationImpl).toString();
        this.assertNotNull("Invalid toString", string);
    }

    public void testValid() {
        QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(37.345832, -120.832345, -7.1f, 1.8f, Float.NaN);
        float f = 3.2f;
        float f2 = 270.0f;
        long l = System.currentTimeMillis();
        LocationImpl locationImpl = new LocationImpl(qualifiedCoordinates, f, f2, l);
        this.assertTrue("Location is valid.", locationImpl.isValid());
        this.assertEquals("Coordinates", qualifiedCoordinates, locationImpl.getQualifiedCoordinates());
        this.assertEquals("Speed", f, locationImpl.getSpeed(), 1.0E-5);
        this.assertEquals("Course", f2, locationImpl.getCourse(), 1.0E-5);
        this.assertEquals("Timestamp", l, locationImpl.getTimestamp());
        String string = ((Object)locationImpl).toString();
        this.assertNotNull("Valid toString", string);
    }
}

