/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.BluetoothDeviceDiscovery;
import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.JSR179LocationProvider;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.logging.Log;

public abstract class LocationProvider {
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;
    private static LocationProvider instance;

    protected LocationProvider() {
    }

    public static String[][] discoverBluetoothDevices() throws IOException, SecurityException {
        String[][] stringArray = null;
        if (!LocationProvider.supportsBluetoothAPI()) {
            return null;
        }
        BluetoothDeviceDiscovery bluetoothDeviceDiscovery = null;
        try {
            bluetoothDeviceDiscovery = (BluetoothDeviceDiscovery)Class.forName("org.j4me.bluetoothgps.BluetoothDeviceDiscovery").newInstance();
        }
        catch (Exception exception) {
            Log.warn("Cannot discover Bluetooth devices", exception);
            return null;
        }
        stringArray = bluetoothDeviceDiscovery.discoverNearbyDeviceNamesAndAddresses();
        return stringArray;
    }

    public static LocationProvider getInstance(Criteria criteria) throws LocationException, IOException, SecurityException {
        LocationProvider locationProvider = null;
        LocationException locationException = null;
        if (criteria.isLocalLBSAllowed() && LocationProvider.supportsLocationAPI()) {
            try {
                locationProvider = JSR179LocationProvider.getInstance(criteria);
            }
            catch (LocationException locationException2) {
                locationException = locationException2;
            }
        }
        if (locationProvider == null) {
            try {
                locationProvider = BluetoothLocationProvider.getInstance(criteria);
            }
            catch (LocationException locationException3) {
                if (locationException != null) {
                    throw locationException;
                }
                throw locationException3;
            }
        }
        instance = locationProvider;
        return locationProvider;
    }

    public static boolean supportsLocationAPI() {
        try {
            Class.forName("javax.microedition.location.LocationProvider");
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static boolean supportsBluetoothAPI() {
        try {
            Class.forName("javax.bluetooth.LocalDevice");
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public abstract int getState();

    public abstract Location getLocation(int var1) throws LocationException, InterruptedException;

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void close();

    public abstract void reset() throws IOException;

    public static Location getLastKnownLocation() {
        if (instance == null) {
            return null;
        }
        return instance.getLastKnownLocationToProvider();
    }

    protected abstract Location getLastKnownLocationToProvider();
}

