/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.logging.Log;

class NMEAParser {
    private static final String DOLLAR_SIGN_GPGSA = "$GPGSA";
    private static final String DOLLAR_SIGN_GPGGA = "$GPGGA";
    private static final String DOLLAR_SIGN_GPRMC = "$GPRMC";
    public static final short OUTPUT_BUFFER_MAX_SIZE = 2048;
    private static final short MAX_SENTENCE_SIZE = 128;
    private static final byte SENTENCE_START = 36;
    private static final byte CHECKSUM_START = 42;
    private static final byte SENTENCE_END = 10;
    private static final byte DELIMITER = 44;
    public static final short TYPE_NOTHING_TO_PROCESS = -1;
    public static final short TYPE_NONE = 0;
    public static final short TYPE_GPRMC = 1;
    public static final short TYPE_GPGGA = 2;
    public static final short TYPE_GPGSA = 4;
    public static final short ALL_TYPES_MASK = 7;
    private byte[] data = new byte[2048];
    private int dataLength = 0;
    private GPSRecord record = new GPSRecord();
    private GPSRecord recordBuffer = null;

    private void append(byte[] byArray, int n) {
        if (this.dataLength + n >= this.data.length) {
            this.flush();
        }
        int n2 = 0;
        int n3 = n;
        if (n > this.data.length) {
            n2 = n - this.data.length;
            n3 = n - n2;
        }
        System.arraycopy(byArray, n2, this.data, this.dataLength, n3);
        this.dataLength += n;
    }

    public void flush() {
        this.dataLength = 0;
    }

    public int parse(byte[] byArray, int n) {
        this.append(byArray, n);
        return this.doParse();
    }

    private int doParse() {
        int n;
        int n2 = 0;
        if (this.dataLength < 40) {
            return 0;
        }
        int n3 = this.dataLength - 1;
        boolean bl = true;
        int n4 = -1;
        while (n3 > 0 && (n = NMEAParser.lastIndexOf(this.data, (byte)36, n3)) != -1) {
            int n5 = NMEAParser.indexOf(this.data, (byte)10, n, this.dataLength);
            if (n5 != -1) {
                int n6 = NMEAParser.indexOf(this.data, (byte)44, n, n5);
                if (n6 != -1 && n5 <= n3) {
                    try {
                        String string = new String(this.data, n, n6 - n);
                        if (string.equals(DOLLAR_SIGN_GPRMC) && (n2 & 1) == 0) {
                            n2 |= this.processSentence(this.data, n, n5, (short)1);
                        } else if (string.equals(DOLLAR_SIGN_GPGGA) && (n2 & 2) == 0) {
                            n2 |= this.processSentence(this.data, n, n5, (short)2);
                        } else if (string.equals(DOLLAR_SIGN_GPGSA) && (n2 & 4) == 0) {
                            n2 |= this.processSentence(this.data, n, n5, (short)4);
                        }
                    }
                    catch (Throwable throwable) {
                        Log.warn("processSentence: dataLength=" + this.dataLength + ", Start=" + n + ", End=" + n5, throwable);
                        this.flush();
                        return n2;
                    }
                    n3 = n - 1;
                    if (n2 == 7) {
                        break;
                    }
                } else {
                    n3 = n - 1;
                }
            } else {
                if (bl) {
                    n4 = n;
                }
                n3 = n - 1;
            }
            bl = false;
        }
        if (n4 < 0) {
            this.flush();
        } else {
            this.dataLength -= n4;
            System.arraycopy(this.data, n4, this.data, 0, this.dataLength);
        }
        if (n2 != 0) {
            this.setRecordBuffer(this.record);
            this.record = new GPSRecord(this.record);
        }
        return n2;
    }

    protected static int indexOf(byte[] byArray, byte by, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    protected static int lastIndexOf(byte[] byArray, byte by, int n) {
        for (int i = n; i >= 0; --i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public synchronized GPSRecord getRecordBuffer() {
        return this.recordBuffer;
    }

    private synchronized void setRecordBuffer(GPSRecord gPSRecord) {
        this.recordBuffer = gPSRecord;
    }

    private short processSentence(byte[] byArray, int n, int n2, short s) {
        short s2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n2 - n <= 128) {
            SentenceData sentenceData = this.contructSentenceData(s);
            for (int i = n; i < n2; ++i) {
                byte by = byArray[i];
                if (by == 36) continue;
                if (by == 42) {
                    sentenceData.processToken(s2, byArray, n3, i - n3);
                    try {
                        String string = new String(byArray, i + 1, 2);
                        n5 = Integer.valueOf(string, 16);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0;
                    }
                }
                n4 ^= by;
                if (by != 44) continue;
                sentenceData.processToken(s2, byArray, n3, i - n3);
                s2 = (short)(s2 + 1);
                n3 = i + 1;
            }
            if (n4 == n5) {
                sentenceData.applySentenceData(this.record);
                return s;
            }
        }
        return 0;
    }

    private SentenceData contructSentenceData(int n) {
        switch (n) {
            case 1: {
                return new GPRMCRecord();
            }
            case 2: {
                return new GPGGARecord();
            }
            case 4: {
                return new GPGSARecord();
            }
        }
        return null;
    }

    private static final class GPRMCRecord
    implements SentenceData {
        public String date = null;
        public String secondsSinceMidnight = null;
        public String lattitude = null;
        public char lattitudeDirection;
        public String longitude = null;
        public char longitudeDirection;
        private String speed = null;
        private String course = null;

        private GPRMCRecord() {
        }

        public void processToken(short s, byte[] byArray, int n, int n2) {
            switch (s) {
                case 1: {
                    this.secondsSinceMidnight = new String(byArray, n, n2);
                    break;
                }
                case 3: {
                    this.lattitude = new String(byArray, n, n2);
                    break;
                }
                case 4: {
                    if (n2 <= 0) break;
                    this.lattitudeDirection = (char)byArray[n];
                    break;
                }
                case 5: {
                    this.longitude = new String(byArray, n, n2);
                    break;
                }
                case 6: {
                    if (n2 <= 0) break;
                    this.longitudeDirection = (char)byArray[n];
                    break;
                }
                case 7: {
                    this.speed = new String(byArray, n, n2);
                    break;
                }
                case 8: {
                    if (n2 <= 0) break;
                    this.course = new String(byArray, n, n2);
                    break;
                }
                case 9: {
                    if (n2 != 6) break;
                    this.date = new String(byArray, n, n2);
                }
            }
        }

        public void applySentenceData(GPSRecord gPSRecord) {
            gPSRecord.date = this.date;
            gPSRecord.secondsSinceMidnight = this.secondsSinceMidnight;
            gPSRecord.lattitude = this.lattitude;
            gPSRecord.lattitudeDirection = this.lattitudeDirection;
            gPSRecord.longitude = this.longitude;
            gPSRecord.longitudeDirection = this.longitudeDirection;
            gPSRecord.speed = this.speed;
            gPSRecord.course = this.course;
        }
    }

    private static final class GPGGARecord
    implements SentenceData {
        public String quality = null;
        public String satelliteCount = null;
        public String altitude = null;

        private GPGGARecord() {
        }

        public void processToken(short s, byte[] byArray, int n, int n2) {
            switch (s) {
                case 6: {
                    this.quality = new String(byArray, n, n2);
                    break;
                }
                case 7: {
                    this.satelliteCount = new String(byArray, n, n2);
                    break;
                }
                case 9: {
                    this.altitude = n2 > 0 ? new String(byArray, n, n2) : null;
                }
            }
        }

        public void applySentenceData(GPSRecord gPSRecord) {
            gPSRecord.quality = this.quality;
            gPSRecord.satelliteCount = this.satelliteCount;
            gPSRecord.altitude = this.altitude;
        }
    }

    private static final class GPGSARecord
    implements SentenceData {
        public String hdop = null;
        public String vdop = null;

        private GPGSARecord() {
        }

        public void processToken(short s, byte[] byArray, int n, int n2) {
            switch (s) {
                case 16: {
                    this.hdop = new String(byArray, n, n2);
                    break;
                }
                case 17: {
                    this.vdop = new String(byArray, n, n2);
                }
            }
        }

        public void applySentenceData(GPSRecord gPSRecord) {
            gPSRecord.hdop = this.hdop;
            gPSRecord.vdop = this.vdop;
        }
    }

    private static interface SentenceData {
        public void processToken(short var1, byte[] var2, int var3, int var4);

        public void applySentenceData(GPSRecord var1);
    }
}

