/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.bluetoothgps.NMEAParser;

public class NMEAParserTest
extends J4METestCase {
    public NMEAParserTest() {
    }

    public NMEAParserTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new NMEAParserTest("testByteArrayFinds", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testByteArrayFinds();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testParseCorruptSentence", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testParseCorruptSentence();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testThrowAwaySentence", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testThrowAwaySentence();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testGPRMC", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testGPRMC();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testGPGGA", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testGPGGA();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testGPGSA", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testGPGSA();
            }
        }));
        testSuite.addTest(new NMEAParserTest("testBatchData", new TestMethod(){

            public void run(TestCase testCase) {
                ((NMEAParserTest)testCase).testBatchData();
            }
        }));
        return testSuite;
    }

    public void testByteArrayFinds() {
        byte[] byArray = "abcdefghijklmnopqrstuvwxyz".getBytes();
        byte by = 122;
        int n = NMEAParser.indexOf(byArray, by, 20, byArray.length);
        this.assertEquals("indexOf() should find z last", byArray.length - 1, n);
        n = NMEAParser.indexOf(byArray, by, 0, byArray.length - 1);
        this.assertEquals("indexOf() should stop before z", -1L, n);
        n = NMEAParser.lastIndexOf(byArray, by, byArray.length - 1);
        this.assertEquals("lastIndexOf() should find z when starting at the end", byArray.length - 1, n);
        n = NMEAParser.lastIndexOf(byArray, by, byArray.length - 2);
        this.assertEquals("lastIndexOf() should not find z when starting before it", -1L, n);
    }

    public void testParseCorruptSentence() {
        String string = "$GPRMC,190350.000,A,3746.0164,N,12226.1176,W,0.45,210.68,031006,,*15\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("Invalid checksum should have been discarded", 0L, n);
        string = "GPGGA,190353.000,3746.0164,N,12226.1176,W,1,08,1.0,67.5,M,-25.3,M,,0000*56\r\n";
        byArray = string.getBytes();
        nMEAParser = new NMEAParser();
        n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("No opening '$' should have been discarded", 0L, n);
        string = "1171,W,1,08,1.0,68.8,M,-25.3,M,,0000*5C\r\n";
        byArray = string.getBytes();
        nMEAParser = new NMEAParser();
        n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("Partial sentence should have been discarded", 0L, n);
        string = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n";
        byArray = string.getBytes();
        nMEAParser = new NMEAParser();
        n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("Merged sentences should have been discarded", 0L, n);
    }

    public void testThrowAwaySentence() {
        String string = "$GPGSV,3,2,09,19,32,069,27,10,25,288,25,03,14,043,30,23,12,143,16*70\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("NMEA sentence should have been discarded", 0L, n);
        string = "$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n";
        byArray = string.getBytes();
        nMEAParser = new NMEAParser();
        n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("SiRF sentence should have been discarded", 0L, n);
    }

    public void testGPRMC() {
        String string = "$GPRMC,063605.000,A,3746.0188,N,12226.1276,W,0.40,130.67,140207,,*10\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("GPRMC sentence should have been parsed", 1L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPRMC latitude", "3746.0188", gPSRecord.lattitude);
        this.assertEquals("GPRMC latitude direction", 78L, gPSRecord.lattitudeDirection);
        this.assertEquals("GPRMC longitude", "12226.1276", gPSRecord.longitude);
        this.assertEquals("GPRMC longitude direction", 87L, gPSRecord.longitudeDirection);
        this.assertEquals("GPRMC speed", "0.40", gPSRecord.speed);
        this.assertEquals("GPRMC course", "130.67", gPSRecord.course);
    }

    public void testGPGGA() {
        String string = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,M,-25.3,M,,0000*5C\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("GPGGA sentence should have been parsed", 2L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPGGA altitude", "55.1", gPSRecord.altitude);
    }

    public void testGPGSA() {
        String string = "$GPGSA,A,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse(byArray, byArray.length);
        this.assertEquals("GPGSA sentence should have been parsed", 4L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPGSA horizontal accuracy", "2.1", gPSRecord.hdop);
        this.assertEquals("GPGSA vertical accuracy", "3.6", gPSRecord.vdop);
    }

    public void testBatchData() {
        String string = "$GPGSV,3,1,11,23,67,353,35,20,58,177,26,16,44,074,34,13,41,308,29*76\r\n$GPGSV,3,2,11,25,36,049,,27,25,246,32,04,16,292,,01,14,093,*70\r\n$GPGSV,3,3,11,31,05,054,,03,02,128,,08,00,236,*4A\r\n$GPRMC,063559.998,A,3746.0171,N,12226.1277,W,0.50,149.79,140207,,*15\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$PSRFTXT,Version2:F-GPS-03-0510032\r\n$PSRFTXT,WAAS Enable\r\n$PSRFTXT,TOW:  282973\r\n$PSRFTXT,WK:   1414\r\n$PSRFTXT,POS:  -2707674 -4260780 3885049\r\n$PSRFTXT,CLK:  94976\r\n$PSRFTXT,CHNL: 12\r\n$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n$GPGGA,063601.002,3746.0171,N,12226.1278,W,1,05,2.1,59.7,M,-25.3,M,,0000*52\r\n$GPGSA,A,3,23,16,13,27,,,,,,,,,6.0,2.8,5.3*39\r\n$GPRMC,063601.002,A,3746.0171,N,12226.1278,W,0.47,305.20,140207,,*1E\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$GPRMC,063601.002,A,3745.1313,N,12226.6666,W,0.47,305.20,140207,,*EE\r\n";
        byte[] byArray = string.getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = 0;
        for (int i = 0; i < byArray.length; i += 35) {
            int n2 = i + 35;
            if (n2 >= byArray.length) {
                n2 = byArray.length - 1;
            }
            int n3 = n2 - i;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i, byArray2, 0, n3);
            n |= nMEAParser.parse(byArray2, n3);
        }
        this.assertEquals("All sentences should have been parsed", 7L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPRMC latitude", "3746.0171", gPSRecord.lattitude);
        this.assertEquals("GPRMC latitude direction", 78L, gPSRecord.lattitudeDirection);
        this.assertEquals("GPRMC longitude", "12226.1278", gPSRecord.longitude);
        this.assertEquals("GPRMC longitude direction", 87L, gPSRecord.longitudeDirection);
        this.assertEquals("GPRMC speed", "0.47", gPSRecord.speed);
        this.assertEquals("GPRMC course", "305.20", gPSRecord.course);
        this.assertEquals("GPGGA altitude", "59.7", gPSRecord.altitude);
        this.assertEquals("GPGSA horizontal accuracy", "2.8", gPSRecord.hdop);
        this.assertEquals("GPGSA vertical accuracy", "5.3", gPSRecord.vdop);
    }
}

