/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Coordinates;

public class QualifiedCoordinates
extends Coordinates {
    private float horizontalAccuracy;
    private float verticalAccuracy;

    public QualifiedCoordinates(double d, double d2, float f, float f2, float f3) {
        super(d, d2, f);
        this.setHorizontalAccuracy(f2);
        this.setVerticalAccuracy(f3);
    }

    public float getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public void setHorizontalAccuracy(float f) {
        if (!Float.isNaN(f) && !(f >= 0.0f)) {
            throw new IllegalArgumentException("Horizontal accuracy (" + f + ") is invalid.");
        }
        this.horizontalAccuracy = f;
    }

    public float getVerticalAccuracy() {
        return this.verticalAccuracy;
    }

    public void setVerticalAccuracy(float f) {
        if (!Float.isNaN(f) && !(f >= 0.0f)) {
            throw new IllegalArgumentException("Vertical accuracy (" + f + ") is invalid.");
        }
        this.verticalAccuracy = f;
    }

    public String toString() {
        String string = super.toString();
        if (!Float.isNaN(this.horizontalAccuracy)) {
            string = string + " \u00b1" + this.horizontalAccuracy + "mH";
        }
        if (!Float.isNaN(this.verticalAccuracy)) {
            string = string + " \u00b1" + this.verticalAccuracy + "mV";
        }
        return string;
    }
}

