/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import java.util.Hashtable;

public class Cache {
    private int max;
    private Hashtable cache;
    private Item mru;
    private Item lru;

    public Cache(int n) {
        this.cache = new Hashtable(n * 2);
        this.mru = null;
        this.lru = null;
        this.setMaxCapacity(n);
    }

    public void clear() {
        this.cache.clear();
        this.mru = null;
        this.lru = null;
    }

    public int size() {
        return this.cache.size();
    }

    public int getMaxCapacity() {
        return this.max;
    }

    public void setMaxCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = this.cache.size() - n; i > 0; --i) {
            this.cache.remove(this.lru.key);
            this.lru.previous.next = null;
            this.lru = this.lru.previous;
        }
        this.max = n;
    }

    public void add(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.max > 0) {
            Item item = new Item();
            int n = this.cache.size();
            if (n > this.max) {
                throw new IllegalStateException();
            }
            Object object3 = this.get(object);
            if (object3 != null) {
                if (object3 != object2) {
                    Item item2 = (Item)this.cache.get(object);
                    item2.data = object2;
                }
            } else {
                if (n == this.max) {
                    this.cache.remove(this.lru.key);
                    if (this.lru.previous != null) {
                        this.lru.previous.next = null;
                    }
                    this.lru = this.lru.previous;
                }
                item.key = object;
                item.data = object2;
                item.next = this.mru;
                item.previous = null;
                if (this.cache.size() == 0) {
                    this.lru = item;
                } else {
                    this.mru.previous = item;
                }
                this.mru = item;
                this.cache.put(object, item);
            }
        }
    }

    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Object v = this.cache.get(object);
        if (v == null) {
            return null;
        }
        Item item = (Item)v;
        if (this.mru != item) {
            if (this.lru == item) {
                this.lru = item.previous;
            }
            if (item.next != null) {
                item.next.previous = item.previous;
            }
            item.previous.next = item.next;
            this.mru.previous = item;
            item.previous = null;
            item.next = this.mru;
            this.mru = item;
        }
        return item.data;
    }

    private static final class Item {
        public Object key;
        public Object data;
        public Item next;
        public Item previous;

        private Item() {
        }
    }
}

