/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.collections.CubbyHole;

public class CubbyHoleTest
extends J4METestCase {
    public CubbyHoleTest() {
    }

    public CubbyHoleTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new CubbyHoleTest("testBasics", new TestMethod(){

            public void run(TestCase testCase) {
                ((CubbyHoleTest)testCase).testBasics();
            }
        }));
        testSuite.addTest(new CubbyHoleTest("testBlocking", new TestMethod(){

            public void run(TestCase testCase) {
                ((CubbyHoleTest)testCase).testBlocking();
            }
        }));
        return testSuite;
    }

    public void testBasics() {
        try {
            CubbyHole cubbyHole = new CubbyHole();
            boolean bl = cubbyHole.empty();
            this.assertTrue("The cubby hole is empty.", bl);
            Object object = cubbyHole.peek();
            this.assertNull("Nothing comes from peaking into an empty cubby hole.", object);
            Integer n = new Integer(13);
            cubbyHole.set(n);
            bl = cubbyHole.empty();
            this.assertFalse("The cubby hole has something in it.", bl);
            object = cubbyHole.peek();
            this.assertSame("The cubby hole correctly stored our object.", n, object);
            Object object2 = cubbyHole.get();
            this.assertSame("Got the object stored in the cubby.", n, object2);
            bl = cubbyHole.empty();
            this.assertTrue("The cubby hole is empty again.", bl);
            object = cubbyHole.peek();
            this.assertNull("Nothing comes from peaking into the empty again cubby hole.", object);
            Integer n2 = new Integer(1);
            Integer n3 = new Integer(2);
            Integer n4 = new Integer(3);
            object2 = cubbyHole.set(n2);
            this.assertNull("Nothing returned from empty cubby hole.", object2);
            object2 = cubbyHole.set(n3);
            this.assertSame("Old data i1 returned from cubby hole.", n2, object2);
            object2 = cubbyHole.set(n4);
            this.assertSame("Old data i2 returned from cubby hole.", n3, object2);
            object2 = cubbyHole.get();
            this.assertSame("Newest data is in cubby hole.", n4, object2);
        }
        catch (InterruptedException interruptedException) {
            this.fail(interruptedException.toString());
        }
    }

    public void testBlocking() {
        CubbyHole cubbyHole = new CubbyHole();
        CubbyHole cubbyHole2 = new CubbyHole();
        try {
            class Consumer
            extends Thread {
                private final /* synthetic */ CubbyHole val$one;
                private final /* synthetic */ CubbyHole val$two;

                Consumer(CubbyHole cubbyHole, CubbyHole cubbyHole2) {
                    this.val$one = cubbyHole;
                    this.val$two = cubbyHole2;
                }

                public void run() {
                    try {
                        Object object = this.val$one.get();
                        this.val$two.set(object);
                    }
                    catch (Throwable throwable) {
                        CubbyHoleTest.this.fail(throwable.toString());
                    }
                }
            }
            Consumer consumer = new Consumer(cubbyHole, cubbyHole2);
            consumer.start();
            Thread.sleep(0L);
            Integer n = new Integer(13);
            cubbyHole.set(n);
            Integer n2 = (Integer)cubbyHole2.get();
            this.assertSame("Data integrety verified.", n, n2);
        }
        catch (InterruptedException interruptedException) {
            this.fail(interruptedException.toString());
        }
    }
}

