/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

public class TreeNode {
    private TreeNode parent;
    private TreeNode[] children = new TreeNode[0];
    private Object m_userData;

    public TreeNode() {
    }

    public TreeNode(Object object) {
        this.m_userData = object;
    }

    public void add(TreeNode treeNode, int n) {
        if (n < 0 || n == this.children.length) {
            TreeNode[] treeNodeArray = new TreeNode[this.children.length + 1];
            System.arraycopy(this.children, 0, treeNodeArray, 0, this.children.length);
            treeNodeArray[this.children.length] = treeNode;
            this.children = treeNodeArray;
        } else {
            if (n > this.children.length) {
                throw new IllegalArgumentException("Cannot add child to index " + n + ".  There are only " + this.children.length + " children.");
            }
            TreeNode[] treeNodeArray = new TreeNode[this.children.length + 1];
            if (n > 0) {
                System.arraycopy(this.children, 0, treeNodeArray, 0, n);
            }
            treeNodeArray[n] = treeNode;
            System.arraycopy(this.children, n, treeNodeArray, n + 1, this.children.length - n);
            this.children = treeNodeArray;
        }
        treeNode.parent = this;
    }

    public void add(TreeNode treeNode) {
        this.add(treeNode, -1);
    }

    public TreeNode remove(int n) {
        if (n < 0 || n >= this.children.length) {
            throw new IllegalArgumentException("Cannot remove element with index " + n + " when there are " + this.children.length + " elements.");
        }
        TreeNode treeNode = this.children[n];
        treeNode.parent = null;
        TreeNode[] treeNodeArray = new TreeNode[this.children.length - 1];
        if (n > 0) {
            System.arraycopy(this.children, 0, treeNodeArray, 0, n);
        }
        if (n != this.children.length - 1) {
            System.arraycopy(this.children, n + 1, treeNodeArray, n, this.children.length - n - 1);
        }
        this.children = treeNodeArray;
        return treeNode;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            int n = this.index();
            this.parent.remove(n);
            this.parent = null;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TreeNode[] children() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.length != 0;
    }

    public int index() {
        if (this.parent != null) {
            int n = 0;
            while (true) {
                TreeNode treeNode;
                if (this == (treeNode = this.parent.children[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int depth() {
        int n = this.recurseDepth(this.parent, 0);
        return n;
    }

    private int recurseDepth(TreeNode treeNode, int n) {
        if (treeNode == null) {
            return n;
        }
        return this.recurseDepth(treeNode.parent, n + 1);
    }

    public void setUserObject(Object object) {
        this.m_userData = object;
    }

    public Object getUserObject() {
        return this.m_userData;
    }
}

