/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.bluetoothgps.Pedometer;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;

public class AcquiringLocationAlert
extends ProgressAlert {
    private final LocationModel model;
    private final DeviceScreen previous;
    private boolean canceled = false;

    public AcquiringLocationAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Acquiring Location...", "The GPS is getting a fix on your location.");
        Boolean bl = locationModel.isGPSOnDevice();
        if (bl != null && !bl.booleanValue()) {
            String string = locationModel.getBluetoothGPSName();
            String string2 = this.getText() + "\n" + "Using device:  " + string;
            this.setText(string2);
        }
        this.model = locationModel;
        this.previous = deviceScreen;
    }

    public void onCancel() {
        Log.debug("Canceling waiting for GPS fix.");
        this.previous.show();
    }

    public void cancel() {
        super.cancel();
        this.canceled = true;
    }

    protected DeviceScreen doWork() {
        Object object;
        QualifiedCoordinates qualifiedCoordinates = null;
        while (!this.canceled && qualifiedCoordinates == null) {
            object = LocationProvider.getLastKnownLocation();
            if (object == null || (qualifiedCoordinates = object.getQualifiedCoordinates()) != null) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = new Pedometer(this.model);
        return object;
    }
}

