/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import org.j4me.bluetoothgps.Criteria;
import org.j4me.examples.bluetoothgps.FindingGPSDevicesAlert;
import org.j4me.examples.bluetoothgps.InitializingGPSAlert;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.ui.Dialog;
import org.j4me.ui.components.CheckBox;
import org.j4me.ui.components.RadioButton;
import org.j4me.ui.components.TextBox;

public class CriteriaSelectionScreen
extends Dialog {
    private final LocationModel model;
    private final RadioButton source;
    private final TextBox horizontalAccuracy;
    private final CheckBox altitudeRequired;
    private final CheckBox speedAndCourseRequired;

    public CriteriaSelectionScreen(LocationModel locationModel) {
        this.model = locationModel;
        this.setTitle("LBS Criteria");
        this.setMenuText(null, "OK");
        this.source = new RadioButton();
        this.source.setLabel("LBS source");
        this.source.append("Device");
        this.source.append("Bluetooth");
        this.append(this.source);
        this.horizontalAccuracy = new TextBox();
        this.horizontalAccuracy.setLabel("Horizontal accuracy in meters");
        this.horizontalAccuracy.setForNumericOnly();
        this.append(this.horizontalAccuracy);
        this.altitudeRequired = new CheckBox();
        this.altitudeRequired.setLabel("Altitude required");
        this.append(this.altitudeRequired);
        this.speedAndCourseRequired = new CheckBox();
        this.speedAndCourseRequired.setLabel("Speed and course required");
        this.append(this.speedAndCourseRequired);
        Criteria criteria = locationModel.getCriteria();
        if (criteria == null) {
            this.source.setSelectedIndex(0);
            this.horizontalAccuracy.setString("10");
        } else {
            if (criteria.getRemoteDeviceAddress() == null) {
                this.source.setSelectedIndex(0);
            } else {
                this.source.setSelectedIndex(1);
            }
            this.horizontalAccuracy.setString(Integer.toString(criteria.getHorizontalAccuracy()));
            this.altitudeRequired.setChecked(criteria.isAltitudeRequired());
            this.speedAndCourseRequired.setChecked(criteria.isSpeedAndCourseRequired());
        }
    }

    protected void acceptNotify() {
        ProgressAlert progressAlert;
        Criteria criteria = new Criteria();
        criteria.setCostAllowed(false);
        criteria.setSpeedAndCourseRequired(this.speedAndCourseRequired.isChecked());
        criteria.setAltitudeRequired(this.altitudeRequired.isChecked());
        criteria.setHorizontalAccuracy(Integer.parseInt(this.horizontalAccuracy.getString()));
        if (this.source.getSelectedIndex() == 0) {
            criteria.setAllowLocalLBS(true);
            criteria.setRemoteDeviceAddress(null);
            progressAlert = new InitializingGPSAlert(this.model, this);
        } else {
            criteria.setAllowLocalLBS(false);
            progressAlert = new FindingGPSDevicesAlert(this.model, this);
        }
        this.model.setCriteria(criteria);
        progressAlert.show();
        super.acceptNotify();
    }
}

