/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.bluetoothgps.SelectGPSScreen;
import org.j4me.examples.ui.screens.ErrorAlert;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;

public class FindingGPSDevicesAlert
extends ProgressAlert {
    private final LocationModel model;
    protected static Object bluetoothLock = new Object();
    private final DeviceScreen previous;

    public FindingGPSDevicesAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Finding GPS...", "Looking for nearby Bluetooth devices.");
        this.model = locationModel;
        this.previous = deviceScreen;
    }

    public void onCancel() {
        Log.info("Canceling Bluetooth device discovery.");
        this.previous.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceScreen doWork() {
        String[][] stringArray = null;
        String string = null;
        Object object = bluetoothLock;
        synchronized (object) {
            Dialog dialog;
            LocationProvider locationProvider = this.model.getLocationProvider();
            if (locationProvider != null) {
                locationProvider.close();
            }
            try {
                Log.info("Discovering Bluetooth devices.");
                stringArray = LocationProvider.discoverBluetoothDevices();
                if (stringArray == null) {
                    Log.error("Problem with Bluetooh device discovery.  Operation returned null.");
                    string = "Bluetooth GPS device discovery failed.";
                }
            }
            catch (SecurityException securityException) {
                Log.error("User denied Bluetooth access.", securityException);
                string = "You must allow access for the GPS to work.\nPlease restart and allow all connections.";
            }
            catch (IOException iOException) {
                Log.error("Problem with Bluetooth device discovery.", iOException);
                string = "Bluetooth GPS device discovery failed.\nExit the application and verify your phone's Bluetooth is on.  If it is please restart your phone and GPS device and try again.";
            }
            if (string != null) {
                dialog = new ErrorAlert("Discovery Error", string, this.previous);
            } else {
                Log.info("Found list of " + stringArray.length + " available devices and presenting them to the user.");
                SelectGPSScreen selectGPSScreen = new SelectGPSScreen(this.model, this.previous);
                selectGPSScreen.setAvailableDevices(stringArray);
                if (stringArray.length == 0) {
                    String string2 = "No devices were found.\nMake sure your Bluetooth GPS device is on and within 10 feet of you.";
                    dialog = new ErrorAlert("Discovery Error", string2, selectGPSScreen);
                } else {
                    dialog = selectGPSScreen;
                }
            }
            return dialog;
        }
    }
}

