/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.examples.bluetoothgps.AcquiringLocationAlert;
import org.j4me.examples.bluetoothgps.FindingGPSDevicesAlert;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.ui.screens.ErrorAlert;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;

public class InitializingGPSAlert
extends ProgressAlert {
    private final LocationModel model;
    private final DeviceScreen previous;

    public InitializingGPSAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Initializing GPS...", "Connecting to the location provider.");
        Boolean bl = locationModel.isGPSOnDevice();
        if (bl != null && !bl.booleanValue()) {
            String string = locationModel.getBluetoothGPSName();
            String string2 = this.getText() + "\n" + "Using device:  " + string;
            this.setText(string2);
        }
        this.model = locationModel;
        this.previous = deviceScreen;
    }

    public void onCancel() {
        Log.debug("Canceling GPS initialization.");
        this.previous.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceScreen doWork() {
        LocationProvider locationProvider = null;
        Dialog dialog = null;
        try {
            Object object = FindingGPSDevicesAlert.bluetoothLock;
            synchronized (object) {
                LocationProvider locationProvider2 = this.model.getLocationProvider();
                if (locationProvider2 != null) {
                    locationProvider2.close();
                }
                Criteria criteria = this.model.getCriteria();
                locationProvider = LocationProvider.getInstance(criteria);
            }
            this.model.setLocationProvider(locationProvider);
            if (locationProvider != null) {
                dialog = new AcquiringLocationAlert(this.model, this.previous);
            } else {
                Log.info("No location provider matched the criteria.");
                dialog = new ErrorAlert("GPS Error", "No location provider matched the criteria.", this.previous);
            }
        }
        catch (LocationException locationException) {
            Log.error("All the location providers are currently out of service.", locationException);
            dialog = new ErrorAlert("GPS Error", "The GPS is already in use by another application.  Please shut it down and try again.", null);
        }
        catch (SecurityException securityException) {
            Log.error("The user blocked access to the location provider.", securityException);
            dialog = new ErrorAlert("GPS Error", "You must allow access for the application to work.\nPlease restart and allow all connections.", null);
        }
        catch (IOException iOException) {
            Log.error("An I/O error occured while connecting to the location provider.", iOException);
            String string = "A problem occurred connecting to the GPS.\nExit the application and verify your phone's Bluetooth is on.  If it is please restart your phone and GPS device and try again.";
            dialog = new ErrorAlert("GPS Error", string, null);
        }
        return dialog;
    }
}

