/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import java.io.IOException;
import java.util.Date;
import javax.microedition.lcdui.Font;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.examples.bluetoothgps.CriteriaSelectionScreen;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.log.LogScreen;
import org.j4me.logging.Log;
import org.j4me.ui.Dialog;
import org.j4me.ui.Menu;
import org.j4me.ui.MenuItem;
import org.j4me.ui.components.HorizontalRule;
import org.j4me.ui.components.Label;

public class Pedometer
extends Dialog
implements LocationListener {
    private static final float YARDS_PER_METER = 1.0936133f;
    private static final int INTERVAL = 5;
    private static final int TIMEOUT = -1;
    private static final int MAX_AGE = -1;
    private static final Font LARGE_FONT = Font.getFont((int)0, (int)1, (int)16);
    private static final Font NORMAL_FONT = Font.getFont((int)0, (int)0, (int)0);
    private final LocationModel model;
    private Label state = new Label();
    private FieldValue traveled = new FieldValue("Traveled (ft)");
    private FieldValue avgSpeed = new FieldValue("Avg speed (MPH)");
    private FieldValue latitude = new FieldValue("Latitude");
    private FieldValue longitude = new FieldValue("Longitude");
    private FieldValue horizontalAccuracy = new FieldValue("Horizontal accuracy (ft)");
    private FieldValue altitude = new FieldValue("Altitude (ft)");
    private FieldValue verticalAccuracy = new FieldValue("Vertical accuracy (ft)");
    private FieldValue speed = new FieldValue("Speed (MPH)");
    private FieldValue course = new FieldValue("Course (deg)");
    private FieldValue time = new FieldValue("Timestamp");
    private float totalDistance;
    private long startTime;
    private QualifiedCoordinates lastCoordinates;

    public Pedometer(LocationModel locationModel) {
        this.model = locationModel;
        this.setMenuText(null, "Menu");
        this.state.setHorizontalAlignment(1);
        this.setStateLabel(locationModel.getLocationProvider().getState());
        this.append(this.state);
        this.createNewSection("Pedometer");
        this.append(this.traveled);
        this.append(this.avgSpeed);
        this.createNewSection("Location");
        this.append(this.latitude);
        this.append(this.longitude);
        this.append(this.horizontalAccuracy);
        this.append(new Label());
        this.append(this.altitude);
        this.append(this.verticalAccuracy);
        this.createNewSection("Movement");
        this.append(this.speed);
        this.append(this.course);
        this.createNewSection("Time");
        this.append(this.time);
        LocationProvider locationProvider = locationModel.getLocationProvider();
        locationProvider.setLocationListener(this, 5, -1, -1);
    }

    private void createNewSection(String string) {
        this.append(new HorizontalRule());
        Label label = new Label();
        label.setFont(LARGE_FONT);
        label.setLabel(string);
        this.append(label);
    }

    protected void acceptNotify() {
        Menu menu = new Menu("Menu", this);
        menu.appendMenuOption(new CriteriaSelectionScreen(this.model));
        menu.appendMenuOption(new MenuItem(){

            public String getText() {
                return "Reset Location Provider";
            }

            public void onSelection() {
                try {
                    Pedometer.this.model.getLocationProvider().reset();
                }
                catch (IOException iOException) {
                    Log.warn("Could not reset the location provider", iOException);
                }
                Pedometer.this.show();
            }
        });
        menu.appendMenuOption(new LogScreen(this));
        menu.show();
        super.acceptNotify();
    }

    public void locationUpdated(LocationProvider locationProvider, Location location) {
        if (location.isValid()) {
            QualifiedCoordinates qualifiedCoordinates = location.getQualifiedCoordinates();
            if (this.lastCoordinates == null) {
                this.lastCoordinates = qualifiedCoordinates;
                this.startTime = System.currentTimeMillis();
            } else {
                this.totalDistance += this.lastCoordinates.distance(qualifiedCoordinates);
                float f = this.totalDistance / (float)(System.currentTimeMillis() - this.startTime) * 1000.0f;
                this.lastCoordinates = qualifiedCoordinates;
                float f2 = Pedometer.convertMetersToFeet(this.totalDistance);
                this.traveled.setLabel(f2);
                f = Pedometer.convertMPStoMPH(f);
                this.avgSpeed.setLabel(f);
            }
            double d = qualifiedCoordinates.getLatitude();
            this.latitude.setLabel(d);
            double d2 = qualifiedCoordinates.getLongitude();
            this.longitude.setLabel(d2);
            float f = qualifiedCoordinates.getHorizontalAccuracy();
            f = Pedometer.convertMetersToFeet(f);
            this.horizontalAccuracy.setLabel(f);
            float f3 = qualifiedCoordinates.getAltitude();
            f3 = Pedometer.convertMetersToFeet(f3);
            this.altitude.setLabel(f3);
            float f4 = qualifiedCoordinates.getVerticalAccuracy();
            f4 = Pedometer.convertMetersToFeet(f4);
            this.verticalAccuracy.setLabel(f4);
            float f5 = location.getSpeed();
            f5 = Pedometer.convertMPStoMPH(f5);
            this.speed.setLabel(f5);
            float f6 = location.getCourse();
            this.course.setLabel(f6);
            long l = location.getTimestamp();
            this.time.setLabel(l);
            this.repaint();
        }
    }

    public void providerStateChanged(LocationProvider locationProvider, int n) {
        this.setStateLabel(n);
        this.repaint();
    }

    private void setStateLabel(int n) {
        switch (n) {
            case 1: {
                this.state.setLabel("Available");
                break;
            }
            case 2: {
                this.state.setLabel("Temporarily unavailable");
                break;
            }
            case 3: {
                this.state.setLabel("Out of service");
            }
        }
    }

    public static float convertMetersToFeet(float f) {
        float f2 = f * 1.0936133f;
        float f3 = f2 * 3.0f;
        return f3;
    }

    public static float convertMPStoMPH(float f) {
        float f2 = Pedometer.convertMetersToFeet(f);
        float f3 = f2 * 3600.0f;
        float f4 = f3 / 5280.0f;
        return f4;
    }

    private static final class FieldValue
    extends Label {
        private final String name;

        public FieldValue(String string) {
            this.name = string;
            this.setFont(NORMAL_FONT);
        }

        public void setLabel(String string) {
            super.setLabel(this.name + ":  " + string);
        }

        public void setLabel(double d) {
            String string = Double.toString(d);
            this.setLabel(string);
        }

        public void setLabel(float f) {
            String string = Float.toString(f);
            this.setLabel(string);
        }

        public void setLabel(long l) {
            Date date = new Date(l);
            String string = date.toString();
            this.setLabel(string);
        }
    }
}

