/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import org.j4me.bluetoothgps.Criteria;
import org.j4me.examples.bluetoothgps.FindingGPSDevicesAlert;
import org.j4me.examples.bluetoothgps.InitializingGPSAlert;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.MenuItem;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.MenuOption;

public class SelectGPSScreen
extends Dialog {
    private final LocationModel model;
    private final DeviceScreen previous;

    public SelectGPSScreen(LocationModel locationModel, DeviceScreen deviceScreen) {
        this.setTitle("Select GPS Device");
        this.model = locationModel;
        this.previous = deviceScreen;
    }

    public void setAvailableDevices(String[][] stringArray) {
        this.deleteAll();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            GPSDeviceOption gPSDeviceOption = new GPSDeviceOption(string, string2);
            this.append(new MenuOption(gPSDeviceOption));
        }
        this.append(new MenuOption(new MenuItem(){

            public String getText() {
                return "Try Again";
            }

            public void onSelection() {
                FindingGPSDevicesAlert findingGPSDevicesAlert = new FindingGPSDevicesAlert(SelectGPSScreen.this.model, SelectGPSScreen.this.previous);
                findingGPSDevicesAlert.show();
            }
        }));
    }

    protected void declineNotify() {
        if (this.previous != null) {
            this.previous.show();
        }
        super.declineNotify();
    }

    protected void acceptNotify() {
        int n = this.getSelected();
        Component component = this.get(n);
        if (component instanceof MenuOption) {
            MenuOption menuOption = (MenuOption)component;
            menuOption.select();
        }
        super.acceptNotify();
    }

    private final class GPSDeviceOption
    implements MenuItem {
        private final String name;
        private final String address;

        public GPSDeviceOption(String string, String string2) {
            this.name = string;
            this.address = string2;
        }

        public String getText() {
            return this.name;
        }

        public void onSelection() {
            SelectGPSScreen.this.model.setBluetoothGPS(this.name, this.address);
            Criteria criteria = SelectGPSScreen.this.model.getCriteria();
            criteria.setAllowLocalLBS(false);
            criteria.setRemoteDeviceAddress(this.address);
            SelectGPSScreen.this.model.setCriteria(criteria);
            InitializingGPSAlert initializingGPSAlert = new InitializingGPSAlert(SelectGPSScreen.this.model, SelectGPSScreen.this);
            initializingGPSAlert.show();
        }
    }
}

