/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.log;

import org.j4me.logging.Level;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.components.CheckBox;
import org.j4me.ui.components.RadioButton;

public class LogOptionsScreen
extends Dialog {
    private final DeviceScreen previous;
    private final RadioButton logLevel;
    private final CheckBox clear;

    public LogOptionsScreen(DeviceScreen deviceScreen) {
        this.previous = deviceScreen;
        this.setTitle("Log Options");
        this.logLevel = new RadioButton();
        this.logLevel.setLabel("Level");
        this.logLevel.append(Level.DEBUG.toString());
        this.logLevel.append(Level.INFO.toString());
        this.logLevel.append(Level.WARN.toString());
        this.logLevel.append(Level.ERROR.toString());
        this.logLevel.append(Level.OFF.toString());
        this.append(this.logLevel);
        this.clear = new CheckBox();
        this.clear.setLabel("Clear log");
        this.append(this.clear);
        Level level = Log.getLogLevel();
        int n = -1;
        if (level == Level.DEBUG) {
            n = 0;
        } else if (level == Level.INFO) {
            n = 1;
        } else if (level == Level.WARN) {
            n = 2;
        } else if (level == Level.ERROR) {
            n = 3;
        } else if (level == Level.OFF) {
            n = 4;
        }
        this.logLevel.setSelectedIndex(n);
    }

    public void showNotify() {
        this.clear.setChecked(false);
        super.showNotify();
    }

    protected void declineNotify() {
        this.previous.show();
    }

    protected void acceptNotify() {
        Level level = Log.getLogLevel();
        int n = this.logLevel.getSelectedIndex();
        if (n == 0) {
            level = Level.DEBUG;
        } else if (n == 1) {
            level = Level.INFO;
        } else if (n == 2) {
            level = Level.WARN;
        } else if (n == 3) {
            level = Level.ERROR;
        } else if (n == 4) {
            level = Level.OFF;
        }
        Log.setLevel(level);
        if (this.clear.isChecked()) {
            Log.clear();
        }
        this.previous.show();
    }
}

