/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;

public class EtchASketch
extends DeviceScreen {
    private final DeviceScreen parent;
    private Vector points = new Vector();
    private int[] current = new int[2];

    public EtchASketch(DeviceScreen deviceScreen) {
        this.parent = deviceScreen;
        this.setTitle("Etch A Sketch");
        this.setMenuText("Back", "Shake");
    }

    public void showNotify() {
        this.current[0] = this.getWidth() / 2;
        this.current[1] = this.getHeight() / 2;
    }

    protected void declineNotify() {
        this.parent.show();
    }

    protected void acceptNotify() {
        this.points = new Vector();
        this.repaint();
    }

    protected void keyPressed(int n) {
        this.move(n);
        super.keyPressed(n);
    }

    protected void keyRepeated(int n) {
        this.move(n);
        super.keyRepeated(n);
    }

    private void move(int n) {
        if (n == -2 || n == -5 || n == -1 || n == -6) {
            this.points.addElement(new int[]{this.current[0], this.current[1]});
            if (n == -2 && this.current[0] > 0) {
                this.current[0] = this.current[0] - 3;
            } else if (n == -5 && this.current[0] < this.getWidth() - 1) {
                this.current[0] = this.current[0] + 3;
            } else if (n == -1 && this.current[1] > 0) {
                this.current[1] = this.current[1] - 3;
            } else if (n == -6 && this.current[1] < this.getScreenHeight() - 1) {
                this.current[1] = this.current[1] + 3;
            }
            this.repaint();
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.move(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.move(n, n2);
    }

    private void move(int n, int n2) {
        this.current[0] = n;
        this.current[1] = n2;
        this.points.addElement(new int[]{n, n2});
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        Theme theme = UIManager.getTheme();
        int n = theme.getHighlightColor();
        graphics.setColor(n);
        int[] nArray = null;
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray2 = (int[])enumeration.nextElement();
            if (nArray != null) {
                graphics.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            nArray = nArray2;
        }
    }
}

