/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.ui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Label;

public class Stopwatch
extends DeviceScreen {
    private final DeviceScreen previous;
    private long startTime = -1L;
    private Label elapsedTime;
    private Timer timer;

    public Stopwatch(DeviceScreen deviceScreen) {
        this.previous = deviceScreen;
        this.setTitle("Stopwatch");
        this.setMenuText("Back", "Start");
        this.elapsedTime = new Label();
        this.elapsedTime.setLabel("Press Start to begin");
        this.elapsedTime.setHorizontalAlignment(1);
        Font font = Font.getFont((int)32, (int)1, (int)16);
        this.elapsedTime.setFont(font);
    }

    protected void declineNotify() {
        if (this.previous != null) {
            this.previous.show();
        }
    }

    protected void acceptNotify() {
        if (this.startTime < 0L) {
            this.setMenuText(this.getLeftMenuText(), "Stop");
            this.startTime = System.currentTimeMillis();
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StopwatchTimerTask(), 0L, 15L);
        } else {
            this.setMenuText(this.getLeftMenuText(), "Start");
            this.startTime = -1L;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (n == -8) {
            this.acceptNotify();
        }
        super.keyPressed(n);
    }

    public void showNotify() {
        this.elapsedTime.visible(true);
    }

    public void hideNotify() {
        this.elapsedTime.visible(false);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected synchronized void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Theme theme = UIManager.getTheme();
        int[] nArray = this.elapsedTime.getPreferredSize(theme, n, n2);
        int n3 = nArray[1];
        int n4 = (n2 - n3) / 2;
        this.elapsedTime.paint(graphics, theme, this, 0, n4, n, n2, true);
    }

    private final class StopwatchTimerTask
    extends TimerTask {
        private StopwatchTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Stopwatch stopwatch = Stopwatch.this;
            synchronized (stopwatch) {
                long l = System.currentTimeMillis() - Stopwatch.this.startTime;
                long l2 = l % 1000L;
                long l3 = l / 1000L;
                long l4 = l3 / 60L;
                l3 %= 60L;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(l4);
                stringBuffer.append(":");
                if (l3 < 10L) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(l3);
                stringBuffer.append(".");
                if (l2 < 10L) {
                    stringBuffer.append("00");
                } else if (l2 < 100L) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(l2);
                String string = stringBuffer.toString();
                Stopwatch.this.elapsedTime.setLabel(string);
                Stopwatch.this.repaint();
            }
        }
    }
}

