/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.ui.components;

import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.components.Label;
import org.j4me.ui.components.ProgressBar;

public class ProgressBarExample
extends Dialog {
    private DeviceScreen previous;
    private ProgressBar bar = new ProgressBar();

    public ProgressBarExample(DeviceScreen deviceScreen) {
        this.previous = deviceScreen;
        this.setTitle("ProgressBar Example");
        this.setMenuText("Back", null);
        Label label = new Label();
        this.append(label);
        label.setLabel("Move the joystick left and right to advance the progress bar.");
        this.bar.setMaxValue(10);
        this.bar.setLabel("0 of " + this.bar.getMaxValue());
        this.append(this.bar);
        ProgressBar progressBar = new ProgressBar();
        progressBar.setLabel("Max of 0 shows a spinner to indicate an unknown duration.");
        this.append(progressBar);
    }

    protected void keyPressed(int n) {
        this.updateProgressBar(n);
        super.keyPressed(n);
    }

    protected void keyRepeated(int n) {
        this.updateProgressBar(n);
        super.keyRepeated(n);
    }

    private void updateProgressBar(int n) {
        if (n == -2 || n == -5) {
            int n2 = this.bar.getValue();
            if (n == -2) {
                --n2;
            } else if (n == -5) {
                ++n2;
            }
            this.bar.setValue(n2);
            this.bar.setLabel(this.bar.getValue() + " of " + this.bar.getMaxValue());
            this.bar.repaint();
        }
    }

    protected void declineNotify() {
        this.previous.show();
    }
}

