/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.ui.components;

import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;

public class ScrollbarExample
extends DeviceScreen {
    private DeviceScreen previous;
    private int totalHeight;
    private int scrolledDown;
    private int scrollIncrement;

    public ScrollbarExample(DeviceScreen deviceScreen) {
        this.previous = deviceScreen;
        this.setTitle("Scrollbar Example");
        this.setMenuText("Back", null);
        this.totalHeight = this.getHeight() * 5;
        this.scrolledDown = 0;
        this.scrollIncrement = (int)((double)this.totalHeight / 7.5);
    }

    protected void declineNotify() {
        this.previous.show();
    }

    protected void paint(Graphics graphics) {
        Theme theme = UIManager.getTheme();
        int n = this.getWidth();
        int n2 = this.getHeight();
        theme.paintVerticalScrollbar(graphics, 0, 0, n, n2, this.scrolledDown, this.totalHeight);
        int n3 = this.totalHeight / 10;
        int n4 = graphics.getFont().getHeight();
        int n5 = n4 / 2;
        int n6 = n - theme.getVerticalScrollbarWidth();
        int n7 = 24;
        for (int i = 0; i <= 10; ++i) {
            String string = String.valueOf(i * 10) + "% ";
            int n8 = graphics.getFont().stringWidth(string);
            int n9 = i * n3 - this.scrolledDown;
            int n10 = n9 - n5;
            graphics.drawString(string, n6, n10, n7);
            graphics.drawLine(0, n9, n6 - n8 - 3, n9);
        }
    }

    protected void keyPressed(int n) {
        if (n == -1) {
            this.scrolledDown -= this.scrollIncrement;
            if (this.scrolledDown < 0) {
                this.scrolledDown = 0;
            }
            this.repaint();
        } else if (n == -6) {
            this.scrolledDown += this.scrollIncrement;
            if (this.scrolledDown >= this.totalHeight - this.getHeight()) {
                this.scrolledDown = this.totalHeight - this.getHeight() - 1;
            }
            this.repaint();
        }
        super.keyPressed(n);
    }
}

