/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.ui.screens;

import org.j4me.examples.ui.screens.ErrorAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Label;
import org.j4me.ui.components.ProgressBar;

public abstract class ProgressAlert
extends Dialog
implements Runnable {
    private Label label = new Label();
    private ProgressBar spinner;
    private boolean canceled = false;

    public ProgressAlert(String string, String string2) {
        this.setTitle(string);
        this.setText(string2);
        this.label.setHorizontalAlignment(1);
        this.append(this.label);
        this.spinner = new ProgressBar();
        this.spinner.setHorizontalAlignment(1);
        this.append(this.spinner);
        Theme theme = UIManager.getTheme();
        String string3 = theme.getMenuTextForCancel();
        this.setMenuText(string3, null);
    }

    public void setText(String string) {
        this.label.setLabel(string);
    }

    public String getText() {
        return this.label.getLabel();
    }

    public void showNotify() {
        Thread thread = new Thread(this);
        thread.start();
        super.showNotify();
    }

    protected void declineNotify() {
        this.cancel();
        this.onCancel();
        super.declineNotify();
    }

    public abstract void onCancel();

    public void cancel() {
        this.canceled = true;
    }

    public void run() {
        try {
            DeviceScreen deviceScreen = this.doWork();
            if (!this.canceled && deviceScreen != null) {
                deviceScreen.show();
            }
        }
        catch (Throwable throwable) {
            Log.error("Unhandled exception in UI worker thread for " + this.getTitle(), throwable);
            ErrorAlert errorAlert = new ErrorAlert("Unhandled Exception", throwable.toString(), this);
            errorAlert.show();
        }
    }

    protected abstract DeviceScreen doWork();
}

