/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.logging;

import org.j4me.logging.Level;
import org.j4me.logging.LogMessage;

public class Log {
    private static final int MAX_LOG_MESSAGES = 25;
    private static LogMessage[] store;
    private static int oldestMessageIndex;
    private static int newestMessageIndex;
    private static Level level;

    public static Level getLogLevel() {
        return level;
    }

    public static void setLevel(int n) {
        if (n == Level.DEBUG.levelInt) {
            level = Level.DEBUG;
        } else if (n == Level.INFO.levelInt) {
            level = Level.INFO;
        } else if (n == Level.WARN.levelInt) {
            level = Level.WARN;
        } else if (n == Level.ERROR.levelInt) {
            level = Level.ERROR;
        } else if (n == Level.OFF.levelInt) {
            level = Level.OFF;
        } else {
            throw new IllegalArgumentException("getLevel(" + n + ") not a valid level");
        }
    }

    public static void setLevel(Level level) {
        Log.level = level;
    }

    public static void debug(String string) {
        if (Log.level.levelInt <= Level.DEBUG.levelInt) {
            Log.addLogMessage(string, Level.DEBUG, null);
        }
    }

    public static void debug(String string, Throwable throwable) {
        if (Log.level.levelInt <= Level.DEBUG.levelInt) {
            Log.addLogMessage(string, Level.DEBUG, throwable);
        }
    }

    public static void info(String string) {
        if (Log.level.levelInt <= Level.INFO.levelInt) {
            Log.addLogMessage(string, Level.INFO, null);
        }
    }

    public static void info(String string, Throwable throwable) {
        if (Log.level.levelInt <= Level.INFO.levelInt) {
            Log.addLogMessage(string, Level.INFO, throwable);
        }
    }

    public static void warn(String string) {
        if (Log.level.levelInt <= Level.WARN.levelInt) {
            Log.addLogMessage(string, Level.WARN, null);
        }
    }

    public static void warn(String string, Throwable throwable) {
        if (Log.level.levelInt <= Level.WARN.levelInt) {
            Log.addLogMessage(string, Level.WARN, throwable);
        }
    }

    public static void error(String string) {
        if (Log.level.levelInt <= Level.ERROR.levelInt) {
            Log.addLogMessage(string, Level.ERROR, null);
        }
    }

    public static void error(String string, Throwable throwable) {
        if (Log.level.levelInt <= Level.ERROR.levelInt) {
            Log.addLogMessage(string, Level.ERROR, throwable);
        }
    }

    public static boolean isDebugEnabled() {
        return Log.level.levelInt <= Level.DEBUG.levelInt;
    }

    public static boolean isInfoEnabled() {
        return Log.level.levelInt <= Level.INFO.levelInt;
    }

    private static synchronized void addLogMessage(String string, Level level, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        String string2 = string;
        if (throwable != null) {
            string2 = string2 + "\n" + throwable.toString();
        }
        System.err.print("[");
        System.err.print(level);
        System.err.print("] ");
        System.err.println(string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
        if ((newestMessageIndex = (newestMessageIndex + 1) % 25) == oldestMessageIndex) {
            store[newestMessageIndex].setLogMessage(level, string2);
            oldestMessageIndex = (oldestMessageIndex + 1) % 25;
        } else {
            Log.store[Log.newestMessageIndex] = new LogMessage(level, string2);
            if (oldestMessageIndex < 0) {
                oldestMessageIndex = 0;
            }
        }
    }

    public static synchronized LogMessage[] getLogMessages() {
        int n = newestMessageIndex < 0 ? 0 : (newestMessageIndex >= oldestMessageIndex ? newestMessageIndex - oldestMessageIndex + 1 : 25);
        LogMessage[] logMessageArray = new LogMessage[n];
        for (int i = 0; i < n; ++i) {
            int n2 = newestMessageIndex - i;
            if (n2 < 0) {
                n2 = 25 + n2;
            }
            logMessageArray[n - i - 1] = store[n2];
        }
        return logMessageArray;
    }

    public static synchronized void clear() {
        oldestMessageIndex = -1;
        newestMessageIndex = -1;
        store = new LogMessage[25];
    }

    static {
        level = Level.INFO;
        Log.clear();
    }
}

