/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;

final class CanvasWrapper
extends Canvas
implements CommandListener {
    private static final short REPEAT_PERIOD = 200;
    private static boolean blackberry;
    private static boolean ibmJ9;
    private static boolean tao;
    private final DeviceScreen master;
    private Timer keyRepeatTimer = null;
    private boolean highlightLeftMenu;
    private boolean highlightRightMenu;
    private Command lcduiLeftMenuCommand;
    private Command lcduiRightMenuCommand;

    public CanvasWrapper(DeviceScreen deviceScreen) {
        this.master = deviceScreen;
        this.setFullScreenMode(true);
        this.setCommandListener(this);
    }

    private synchronized void stopRepeatTimer() {
        if (this.keyRepeatTimer != null) {
            this.keyRepeatTimer.cancel();
            this.keyRepeatTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        int n2 = this.translateKeyCode(n);
        this.stopRepeatTimer();
        this.master.keyPressed(n2);
        if (n2 == -21) {
            if (this.master.hasMenuBar()) {
                this.highlightLeftMenu = true;
                this.repaintMenuBar(true);
            }
            this.master.declineNotify();
        } else if (n2 == -22) {
            if (this.master.hasMenuBar()) {
                this.highlightRightMenu = true;
                this.repaintMenuBar(true);
            }
            this.master.acceptNotify();
        }
        CanvasWrapper canvasWrapper = this;
        synchronized (canvasWrapper) {
            this.keyRepeatTimer = new Timer();
            this.keyRepeatTimer.schedule((TimerTask)new KeyRepeater(n2), 200L, 200L);
        }
    }

    protected void keyReleased(int n) {
        this.stopRepeatTimer();
        int n2 = this.translateKeyCode(n);
        this.master.keyReleased(n2);
        if (this.master.hasMenuBar()) {
            if (n2 == -21) {
                this.highlightLeftMenu = false;
                this.repaintMenuBar(false);
            } else if (n2 == -22) {
                this.highlightRightMenu = false;
                this.repaintMenuBar(false);
            }
        }
    }

    private int translateKeyCode(int n) {
        int n2;
        if (tao && n == 13) {
            return -8;
        }
        if (n > 6) {
            return n;
        }
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {
            return n;
        }
        if (n2 != 0) {
            return -1 * n2;
        }
        if (n == -6 || n == -21 || n == -1) {
            return -21;
        }
        if (n == -7 || n == -22 || n == -4) {
            return -22;
        }
        return n;
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        int n4;
        Theme theme = UIManager.getTheme();
        boolean bl = false;
        if (this.master.hasMenuBar()) {
            n4 = theme.getMenuHeight();
            n3 = super.getHeight() - n4;
            if (n2 > n3) {
                int n5 = super.getWidth();
                if (n < n5 / 2) {
                    this.master.declineNotify();
                } else {
                    this.master.acceptNotify();
                }
                bl = true;
            }
        }
        n4 = this.master.hasTitleBar() ? 1 : 0;
        if (!bl && n4 == 1 && n2 < (n3 = theme.getTitleHeight())) {
            bl = true;
        }
        if (!bl) {
            n3 = n2;
            if (n4 != 0) {
                n3 -= theme.getTitleHeight();
            }
            this.master.pointerPressed(n, n3);
        }
        super.pointerPressed(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        int n3 = n2;
        if (this.master.hasTitleBar()) {
            Theme theme = UIManager.getTheme();
            n3 -= theme.getTitleHeight();
        }
        this.master.pointerDragged(n, n3);
        super.pointerDragged(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        int n3 = n2;
        if (this.master.hasTitleBar()) {
            Theme theme = UIManager.getTheme();
            n3 -= theme.getTitleHeight();
        }
        this.master.pointerReleased(n, n3);
        super.pointerReleased(n, n2);
    }

    public void setTitle(String string) {
        if (!this.supportsTitleBar()) {
            super.setTitle(string);
        }
    }

    public void setMenuText(String string, String string2) {
        if (!this.supportsMenuBar()) {
            int n;
            if (this.lcduiLeftMenuCommand != null) {
                this.removeCommand(this.lcduiLeftMenuCommand);
                this.lcduiLeftMenuCommand = null;
            }
            if (this.lcduiRightMenuCommand != null) {
                this.removeCommand(this.lcduiRightMenuCommand);
                this.lcduiRightMenuCommand = null;
            }
            if (string != null) {
                n = blackberry ? 2 : 1;
                this.lcduiLeftMenuCommand = new Command(string, 3, n);
                this.addCommand(this.lcduiLeftMenuCommand);
            }
            if (string2 != null) {
                n = blackberry ? 1 : 2;
                this.lcduiRightMenuCommand = new Command(string2, 4, n);
                this.addCommand(this.lcduiRightMenuCommand);
                if ((ibmJ9 || tao) && string == null) {
                    this.lcduiLeftMenuCommand = new Command("", 3, 1);
                    this.addCommand(this.lcduiLeftMenuCommand);
                }
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.lcduiLeftMenuCommand != null && command == this.lcduiLeftMenuCommand) {
            this.keyPressed(-21);
            this.keyReleased(-21);
        }
        if (this.lcduiRightMenuCommand != null && command == this.lcduiRightMenuCommand) {
            this.keyPressed(-22);
            this.keyReleased(-22);
        }
    }

    public boolean supportsMenuBar() {
        return !blackberry && !ibmJ9 && !tao;
    }

    public boolean supportsTitleBar() {
        return !ibmJ9 && !tao;
    }

    protected void hideNotify() {
        this.stopRepeatTimer();
        this.highlightLeftMenu = false;
        this.highlightRightMenu = false;
        super.hideNotify();
    }

    private void repaintMenuBar(boolean bl) {
        Theme theme = UIManager.getTheme();
        int n = theme.getMenuHeight();
        int n2 = this.getHeight() - n;
        this.repaint(0, n2, this.getWidth(), n);
        if (bl) {
            this.serviceRepaints();
        }
    }

    protected void paint(Graphics graphics) {
        try {
            int n;
            Theme theme = UIManager.getTheme();
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = 0;
            int n5 = 0;
            String string = null;
            String string2 = null;
            String string3 = null;
            int n6 = graphics.getClipX();
            int n7 = graphics.getClipY();
            int n8 = graphics.getClipWidth();
            int n9 = graphics.getClipHeight();
            if (!this.master.isFullScreenMode()) {
                string = this.master.getTitle();
                if (this.master.hasTitleBar()) {
                    n4 = theme.getTitleHeight();
                }
                if (this.master.hasMenuBar()) {
                    string2 = this.master.getLeftMenuText();
                    string3 = this.master.getRightMenuText();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string3 == null) {
                        string3 = "";
                    }
                    n5 = theme.getMenuHeight();
                }
                n3 = n3 - n4 - n5;
                graphics.translate(0, n4);
                graphics.clipRect(0, 0, n2, n3);
            }
            if (DeviceScreen.intersects(graphics, 0, 0, n2, n3)) {
                this.master.paintBackground(graphics);
                graphics.setFont(theme.getFont());
                graphics.setColor(theme.getFontColor());
                this.master.paint(graphics);
            }
            graphics.translate(0, -n4);
            graphics.setClip(n6, n7, n8, n9);
            if (n4 > 0 && DeviceScreen.intersects(graphics, 0, 0, n2, n4)) {
                graphics.clipRect(0, 0, n2, n4);
                this.master.paintTitleBar(graphics, string, n2, n4);
                graphics.setClip(n6, n7, n8, n9);
            }
            if (n5 > 0 && DeviceScreen.intersects(graphics, 0, n = this.getHeight() - n5, n2, n5)) {
                graphics.translate(0, n);
                graphics.clipRect(0, 0, n2, n5);
                int n10 = theme.getMenuBarBackgroundColor();
                graphics.setColor(n10);
                graphics.fillRect(0, 0, n2, n5);
                this.master.paintMenuBar(graphics, string2, this.highlightLeftMenu, string3, this.highlightRightMenu, n2, n5);
                graphics.translate(0, -n);
                graphics.setClip(n6, n7, n8, n9);
            }
        }
        catch (Throwable throwable) {
            Log.warn("Unhandled exception in paint for " + this.master, throwable);
        }
    }

    static {
        String string = System.getProperty("microedition.platform");
        string = string.toLowerCase();
        try {
            Class.forName("net.rim.device.api.ui.UiApplication");
            blackberry = true;
        }
        catch (Throwable throwable) {
            blackberry = false;
        }
        try {
            Class.forName("java.lang.J9VMInternals");
            ibmJ9 = true;
        }
        catch (Throwable throwable) {
            ibmJ9 = false;
        }
        tao = string.indexOf("intent") > -1;
    }

    private final class KeyRepeater
    extends TimerTask {
        private int key;

        public KeyRepeater(int n) {
            this.key = n;
        }

        public void run() {
            if (CanvasWrapper.this.master.isShown()) {
                try {
                    CanvasWrapper.this.master.keyRepeated(this.key);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

