/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Component;
import org.j4me.util.MathFunc;

public abstract class Dialog
extends DeviceScreen {
    private Vector components = new Vector();
    private int highlightedComponent = -1;
    private int margin;
    private int spacing = this.margin = 5;
    private int topOfScreen = 0;
    private int[] componentWidths = null;
    private int[] absoluteHeights = null;
    boolean invalidated;

    public Dialog() {
        Theme theme = UIManager.getTheme();
        String string = theme.getMenuTextForCancel();
        String string2 = theme.getMenuTextForOK();
        this.setMenuText(string, string2);
    }

    public void hideNotify() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.visible(false);
        }
        super.hideNotify();
    }

    public void append(Component component) {
        this.invalidate();
        this.components.addElement(component);
    }

    public void insert(Component component, int n) {
        this.invalidate();
        this.components.insertElementAt(component, n);
    }

    public void set(Component component, int n) {
        this.invalidate();
        this.components.setElementAt(component, n);
    }

    public void delete(Component component) {
        int n = this.components.indexOf(component);
        this.delete(n);
    }

    public void delete(int n) {
        if (n >= 0) {
            this.components.removeElementAt(n);
            if (this.highlightedComponent == n) {
                this.highlightedComponent = -1;
            } else if (this.highlightedComponent > n) {
                --this.highlightedComponent;
            }
            this.invalidate();
        }
    }

    public void deleteAll() {
        this.components.removeAllElements();
        this.highlightedComponent = -1;
        this.invalidate();
    }

    public Enumeration components() {
        return this.components.elements();
    }

    public int size() {
        return this.components.size();
    }

    public Component get(int n) {
        Component component = null;
        if (n >= 0 && n < this.components.size()) {
            component = (Component)this.components.elementAt(n);
        }
        return component;
    }

    public int getSelected() {
        if (this.highlightedComponent < 0) {
            return 0;
        }
        return this.highlightedComponent;
    }

    private int getAt(int n, int n2) {
        int n3 = -1;
        int n4 = this.topOfScreen + n2;
        for (int i = 0; i < this.absoluteHeights.length - 1; ++i) {
            int n5 = this.absoluteHeights[i];
            int n6 = this.absoluteHeights[i + 1];
            int n7 = n6 - this.spacing;
            int n8 = this.margin;
            int n9 = n8 + this.componentWidths[i];
            if (n4 >= n5 && n4 < n7 && n >= n8 && n < n9) {
                n3 = i;
            }
            if (n4 < n6) break;
        }
        return n3;
    }

    public void setSelected(int n) {
        if (n < 0 || n >= this.components.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.highlightedComponent = n;
        if (this.absoluteHeights == null) {
            this.calculateLayout(UIManager.getTheme(), this.getWidth(), this.getHeight());
        }
        this.topOfScreen = n == 0 ? 0 : this.absoluteHeights[n] - this.spacing;
        int n2 = this.absoluteHeights[this.absoluteHeights.length - 1] - this.getHeight();
        if (n2 <= 0) {
            this.topOfScreen = 0;
        } else if (this.topOfScreen > n2) {
            this.topOfScreen = n2;
        }
    }

    public void setSelected(Component component) {
        Component component2;
        int n = 0;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements() && (component2 = (Component)enumeration.nextElement()) != component) {
            ++n;
        }
        if (n < this.size()) {
            this.setSelected(n);
        }
    }

    protected synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.invalidated) {
            this.layout();
            this.invalidated = false;
        }
        Theme theme = UIManager.getTheme();
        int n3 = this.getHeight();
        if (this.hasVerticalScrollbar()) {
            n2 = super.getWidth();
            n = this.absoluteHeights[this.absoluteHeights.length - 1];
            this.paintVerticalScrollbar(graphics, 0, 0, n2, n3, this.topOfScreen, n);
        }
        n2 = this.getWidth();
        n = this.topOfScreen + n3;
        Enumeration enumeration = this.components.elements();
        for (int i = 0; i < this.absoluteHeights.length - 1; ++i) {
            Component component = (Component)enumeration.nextElement();
            int n4 = this.absoluteHeights[i];
            int n5 = this.absoluteHeights[i + 1] - this.spacing;
            if (n4 >= n) {
                component.visible(false);
                continue;
            }
            if (n5 <= this.topOfScreen) {
                component.visible(false);
                continue;
            }
            component.visible(true);
            int n6 = this.margin;
            int n7 = n4 - this.topOfScreen;
            int n8 = n2;
            int n9 = n5 - n4;
            if (!DeviceScreen.intersects(graphics, n6, n7, n8, n9)) continue;
            boolean bl = i == this.highlightedComponent;
            component.paint(graphics, theme, this, n6, n7, n8, n9, bl);
        }
    }

    protected void paintVerticalScrollbar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        UIManager.getTheme().paintVerticalScrollbar(graphics, n, n2, n3, n4, n5, n6);
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        if (n >= 0 && this.margin != n) {
            this.margin = n;
            this.invalidate();
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n >= 0 && this.spacing != n) {
            this.spacing = n;
            this.invalidate();
        }
    }

    public int getWidth() {
        int n = super.getWidth();
        int n2 = n - 2 * this.margin;
        if (this.hasVerticalScrollbar()) {
            int n3 = UIManager.getTheme().getVerticalScrollbarWidth();
            n2 -= n3;
        }
        return n2;
    }

    public synchronized boolean hasVerticalScrollbar() {
        int n = this.getHeight();
        int n2 = super.getWidth() - 2 * this.margin;
        boolean bl = false;
        Theme theme = UIManager.getTheme();
        if (this.invalidated || this.absoluteHeights == null) {
            this.calculateLayout(theme, n2, n);
            bl = true;
        }
        if (this.absoluteHeights[this.absoluteHeights.length - 1] > n) {
            if (bl) {
                this.calculateLayout(theme, n2 -= theme.getVerticalScrollbarWidth(), n);
            }
            return true;
        }
        return false;
    }

    public void invalidate() {
        this.invalidated = true;
    }

    private synchronized void layout() {
        int n = 0;
        int n2 = 0;
        if (this.absoluteHeights != null) {
            if (this.highlightedComponent >= 0) {
                n = this.highlightedComponent;
            }
            n2 = this.absoluteHeights[n] - this.topOfScreen;
        }
        this.componentWidths = null;
        this.absoluteHeights = null;
        this.topOfScreen = 0;
        this.hasVerticalScrollbar();
        if (n != 0) {
            this.highlightedComponent = n;
            this.topOfScreen = this.absoluteHeights[n] - n2;
        }
    }

    private synchronized void calculateLayout(Theme theme, int n, int n2) {
        this.componentWidths = new int[this.components.size() + 1];
        this.absoluteHeights = new int[this.componentWidths.length];
        int n3 = this.margin;
        Enumeration enumeration = this.components.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            this.absoluteHeights[n4] = n3;
            Component component = (Component)enumeration.nextElement();
            int[] nArray = component.getPreferredSize(theme, n, n2);
            this.componentWidths[n4] = nArray[0];
            n3 += nArray[1] + this.spacing;
            ++n4;
        }
        if (this.highlightedComponent < 0) {
            this.highlightedComponent = 0;
        }
        this.absoluteHeights[this.absoluteHeights.length - 1] = n3;
    }

    private int nextHighlightableComponent(boolean bl, int n) {
        if (bl) {
            int n2 = this.highlightedComponent < 0 ? this.topOfScreen : this.topOfScreen + this.getHeight();
            n2 += n;
            int n3 = this.size();
            for (int i = this.highlightedComponent + 1; i < n3; ++i) {
                int n4 = this.absoluteHeights[i + 1];
                if (n4 > n2) {
                    if (i - 1 == this.highlightedComponent) {
                        return i;
                    }
                    return i - 1;
                }
                Component component = this.get(i);
                if (!component.acceptsInput()) continue;
                return i;
            }
            return n3 - 1;
        }
        if (this.highlightedComponent > 0) {
            int n5 = this.topOfScreen - n;
            for (int i = this.highlightedComponent - 1; i >= 0; --i) {
                int n6 = this.absoluteHeights[i];
                if (n6 < n5) {
                    if (i + 1 == this.highlightedComponent) {
                        return i;
                    }
                    return i + 1;
                }
                Component component = this.get(i);
                if (!component.acceptsInput()) continue;
                return i;
            }
        }
        return 0;
    }

    private void scroll(boolean bl) {
        if (this.absoluteHeights == null) {
            this.hasVerticalScrollbar();
        }
        if (this.components.size() == 0) {
            return;
        }
        int n = 0;
        int n2 = this.getHeight();
        int n3 = this.absoluteHeights[this.absoluteHeights.length - 1] - n2;
        int n4 = this.topOfScreen + n2;
        int n5 = n2 * 9 / 10;
        int n6 = this.highlightedComponent;
        this.highlightedComponent = this.nextHighlightableComponent(bl, n5);
        if (this.hasVerticalScrollbar()) {
            int n7;
            if (bl) {
                int n8 = this.absoluteHeights[n6 + 1];
                if (n8 > n4) {
                    n7 = n5;
                } else {
                    int n9 = this.absoluteHeights[this.highlightedComponent];
                    int n10 = this.absoluteHeights[this.highlightedComponent + 1];
                    n7 = n9 > this.topOfScreen && n10 < n4 ? 0 : n10 - n8;
                }
            } else {
                int n11 = this.absoluteHeights[n6];
                if (n11 < this.topOfScreen) {
                    n7 = n5;
                } else if (this.highlightedComponent == 0) {
                    n7 = this.topOfScreen;
                } else {
                    int n12 = this.absoluteHeights[this.highlightedComponent] - this.spacing;
                    n7 = this.topOfScreen - n12;
                    if (n12 >= this.topOfScreen) {
                        n7 = 0;
                    }
                }
            }
            if (n7 > n5) {
                n7 = n5;
            }
            if (!bl) {
                n7 *= -1;
            }
            this.topOfScreen += n7;
            if (this.topOfScreen < n) {
                this.topOfScreen = n;
            } else if (this.topOfScreen > n3) {
                this.topOfScreen = n3;
            }
        }
        this.repaint();
    }

    public void setFullScreenMode(boolean bl) {
        super.setFullScreenMode(bl);
        this.invalidate();
    }

    public void setMenuText(String string, String string2) {
        super.setMenuText(string, string2);
        this.invalidate();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.invalidate();
    }

    protected void keyPressed(int n) {
        Component component = this.get(this.highlightedComponent);
        if (component != null) {
            component.keyPressed(n);
        }
        if (n == -1) {
            this.scroll(false);
        } else if (n == -6) {
            this.scroll(true);
        }
        super.keyPressed(n);
    }

    protected void keyRepeated(int n) {
        Component component = this.get(this.highlightedComponent);
        if (component != null) {
            component.keyRepeated(n);
        }
        super.keyRepeated(n);
    }

    protected void keyReleased(int n) {
        Component component = this.get(this.highlightedComponent);
        if (component != null) {
            component.keyReleased(n);
        }
        super.keyReleased(n);
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        if (this.hasVerticalScrollbar() && n >= (n5 = (n4 = this.getScreenWidth()) - (n3 = UIManager.getTheme().getVerticalScrollbarWidth()))) {
            int n6;
            double d;
            bl = true;
            int n7 = this.getHeight();
            int n8 = this.absoluteHeights[this.absoluteHeights.length - 1];
            int n9 = n8 - n7;
            double d2 = (double)n7 / (double)n8;
            int n10 = (int)MathFunc.round((double)n7 * d2);
            int n11 = (n10 = Math.max(n10, 2 * n3)) / 2;
            int n12 = n11 + (int)MathFunc.round((d = (double)this.topOfScreen / (double)n9) * (double)(n6 = n7 - 2 * n11));
            if (n2 < n12) {
                this.scroll(false);
            } else {
                this.scroll(true);
            }
        }
        if (!bl) {
            this.highlightedComponent = this.getAt(n, n2);
            Component component = this.get(this.highlightedComponent);
            if (component != null) {
                n3 = n - component.getX();
                n5 = n2 - component.getY();
                component.pointerPressed(n3, n5);
            }
        }
        super.pointerPressed(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        Component component = this.get(this.highlightedComponent);
        if (component != null) {
            component.pointerDragged(n, n2);
        }
        super.pointerDragged(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        Component component = this.get(this.highlightedComponent);
        if (component != null) {
            component.pointerReleased(n, n2);
        }
        super.pointerReleased(n, n2);
    }
}

