/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.util.MathFunc;

public class Theme {
    public static final int BLACK = 0;
    public static final int BROWN = 0x804000;
    public static final int BLUE = 255;
    public static final int NAVY = 128;
    public static final int NEON_BLUE = 0x4DFFFF;
    public static final int LIGHT_BLUE = 33023;
    public static final int RED = 0xFF0000;
    public static final int MAROON = 0x802020;
    public static final int LIGHT_RED = 0xFF5050;
    public static final int MAGENTA = 0xFF28FF;
    public static final int ORANGE = 0xFF8000;
    public static final int BURNT_ORANGE = 0xD07000;
    public static final int YELLOW = 0xFFFF00;
    public static final int GREEN = 0x66FF33;
    public static final int MEDIUM_GREEN = 42752;
    public static final int LIGHT_GREEN = 3194912;
    public static final int DARK_GREEN = 2048813;
    public static final int FOREST_GREEN = 0x33773A;
    public static final int BLUE_GREEN = 32896;
    public static final int CYAN = 0x33FFFF;
    public static final int SILVER = 0xC0C0C0;
    public static final int GRAY = 0x808080;
    public static final int LIGHT_GRAY = 0xC0C0C0;
    public static final int LAVENDAR = 15132410;
    public static final int WHITE = 0xFFFFFF;
    private static final double TITLE_BAR_SECONDARY_COLOR_MAX = 0.6;
    private static final double MENU_BAR_SECONDARY_COLOR_MAX = 0.1;
    private static final double SCROLLBAR_SECONDARY_COLOR_MAX = 0.8;
    private static final int SCROLLBAR_WIDTH = 6;
    private final Font defaultFont;
    private final Font menuFont;
    private final Font titleFont;

    public Theme() {
        Font font = Font.getDefaultFont();
        int n = font.getFace();
        int n2 = font.getSize();
        this.defaultFont = Font.getFont((int)n, (int)0, (int)n2);
        this.menuFont = Font.getFont((int)n, (int)0, (int)n2);
        this.titleFont = Font.getFont((int)n, (int)1, (int)n2);
    }

    public Font getFont() {
        return this.defaultFont;
    }

    public Font getMenuFont() {
        return this.menuFont;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public int getFontColor() {
        return 128;
    }

    public int getMenuFontColor() {
        return 0xFFFFFF;
    }

    public int getMenuFontHighlightColor() {
        return 0xC0C0C0;
    }

    public int getTitleFontColor() {
        return this.getMenuFontColor();
    }

    public int getBorderColor() {
        return 128;
    }

    public int getBackgroundColor() {
        return 0xFFFFFF;
    }

    public int getHighlightColor() {
        return 33023;
    }

    public int getTitleBarBorderColor() {
        return this.getMenuBarBorderColor();
    }

    public int getTitleBarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getTitleBarHighlightColor() {
        return this.getMenuBarHighlightColor();
    }

    public int getMenuBarBorderColor() {
        return this.getFontColor();
    }

    public int getMenuBarBackgroundColor() {
        return 128;
    }

    public int getMenuBarHighlightColor() {
        return 33023;
    }

    public int getTitleHeight() {
        return this.getTitleFont().getHeight() + 2;
    }

    public void paintTitleBar(Graphics graphics, String string, int n, int n2) {
        this.paintTitleBarBackground(graphics, 0, 0, n, n2);
        graphics.setColor(this.getTitleBarBorderColor());
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        graphics.setFont(this.getTitleFont());
        graphics.setColor(this.getTitleFontColor());
        graphics.drawString(string, n / 2, 1, 17);
    }

    protected void paintTitleBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getTitleBarBackgroundColor();
        int n6 = this.getTitleBarHighlightColor();
        Theme.gradientFill(graphics, 0, 0, n3, n4, true, n5, n6, 0.6);
    }

    public int getMenuHeight() {
        return this.getMenuFont().getHeight() + 2;
    }

    public void paintMenuBar(Graphics graphics, String string, boolean bl, String string2, boolean bl2, int n, int n2) {
        this.paintMenuBarBackground(graphics, 0, 0, n, n2);
        graphics.setColor(this.getMenuBarBorderColor());
        graphics.drawLine(0, 0, n, 0);
        int n3 = this.getMenuFontColor();
        int n4 = this.getMenuFontHighlightColor();
        Font font = this.getMenuFont();
        graphics.setFont(font);
        int n5 = font.charWidth(' ') / 2;
        graphics.setColor(bl ? n4 : n3);
        graphics.drawString(string, n5, n2, 36);
        graphics.setColor(bl2 ? n4 : n3);
        graphics.drawString(string2, n - n5, n2, 40);
    }

    protected void paintMenuBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getMenuBarBackgroundColor();
        int n6 = this.getMenuBarHighlightColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, true, n5, n6, 0.1);
    }

    public String getMenuTextForOK() {
        return "OK";
    }

    public String getMenuTextForCancel() {
        return "Cancel";
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getBackgroundColor();
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.setColor(n);
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void paintVerticalScrollbar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getVerticalScrollbarWidth();
        int n8 = n + n3 - n7;
        this.paintScrollbarBackground(graphics, n8, n2, n7, n4);
        int n9 = this.getBorderColor();
        graphics.setColor(n9);
        graphics.drawLine(n8, n2, n8, n2 + n4);
        int n10 = n6 - n4;
        double d = (double)n4 / (double)n6;
        int n11 = (int)MathFunc.round((double)n4 * d);
        n11 = Math.max(n11, 2 * n7);
        int n12 = n11 / 2;
        int n13 = n4 - 2 * n12;
        double d2 = (double)n5 / (double)n10;
        int n14 = n2 + n12 + (int)MathFunc.round(d2 * (double)n13);
        this.paintTrackbar(graphics, n8, n14 - n12, n7, n11);
    }

    protected void paintScrollbarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getScrollbarBackgroundColor();
        int n6 = this.getScrollbarHighlightColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, false, n5, n6, 0.8);
    }

    protected void paintTrackbar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getScrollbarTrackbarColor();
        int n6 = this.getScrollbarBorderColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, false, n5, n6, 0.8);
    }

    public int getVerticalScrollbarWidth() {
        return 6;
    }

    public int getScrollbarBorderColor() {
        return this.getBorderColor();
    }

    public int getScrollbarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getScrollbarHighlightColor() {
        return this.getMenuFontHighlightColor();
    }

    public int getScrollbarTrackbarColor() {
        return this.getMenuBarHighlightColor();
    }

    public static void gradientFill(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) {
        int n7 = (n5 & 0xFF0000) >> 16;
        int n8 = (n5 & 0xFF00) >> 8;
        int n9 = n5 & 0xFF;
        int n10 = (n6 & 0xFF0000) >> 16;
        int n11 = (n6 & 0xFF00) >> 8;
        int n12 = n6 & 0xFF;
        int n13 = bl ? n4 : n3;
        for (int i = 0; i < n13; ++i) {
            double d2 = (double)i / (double)n13;
            double d3 = Math.abs(d - d2);
            double d4 = 1.0 - d3;
            int n14 = (int)((double)n7 * d3 + (double)n10 * d4);
            int n15 = (int)((double)n8 * d3 + (double)n11 * d4);
            int n16 = (int)((double)n9 * d3 + (double)n12 * d4);
            graphics.setColor(n14, n15, n16);
            if (bl) {
                graphics.drawLine(n, n2 + i, n + n3, n2 + i);
                continue;
            }
            graphics.drawLine(n + i, n2, n + i, n2 + n4);
        }
    }
}

