/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;

public class UIManager {
    private static final String INIT_NOT_SET_EXCEPTION = "Must first call UIManager.init";
    private static Theme theme = new Theme();
    private static Display display;
    private static DeviceScreen current;

    public static void init(MIDlet mIDlet) {
        if (mIDlet == null) {
            throw new IllegalArgumentException();
        }
        display = Display.getDisplay((MIDlet)mIDlet);
    }

    public static Theme getTheme() {
        return theme;
    }

    public static void setTheme(Theme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Cannot set a null theme.");
        }
        UIManager.theme = theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setScreen(DeviceScreen deviceScreen, Displayable displayable) {
        if (display == null) {
            throw new IllegalStateException(INIT_NOT_SET_EXCEPTION);
        }
        if (displayable == null) {
            throw new IllegalArgumentException();
        }
        Display display = UIManager.display;
        synchronized (display) {
            if (current != null) {
                try {
                    current.hideNotify();
                }
                catch (Throwable throwable) {
                    Log.warn("Unhandled exception in hideNotify() of " + current, throwable);
                }
            }
            current = deviceScreen;
            try {
                deviceScreen.showNotify();
            }
            catch (Throwable throwable) {
                Log.warn("Unhandled exception in showNotify() of " + current, throwable);
            }
            UIManager.display.setCurrent(displayable);
            deviceScreen.repaint();
            if (Log.isDebugEnabled()) {
                Log.debug("Screen switched to " + deviceScreen);
            }
        }
    }

    public static DeviceScreen getScreen() {
        return current;
    }

    public static Display getDisplay() {
        if (display == null) {
            throw new IllegalStateException(INIT_NOT_SET_EXCEPTION);
        }
        return display;
    }
}

