/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class CheckBox
extends Component {
    private static final double CHECKBOX_TO_FONT_RATIO = 0.7;
    private Label label = new Label();
    private boolean checked;

    public String getLabel() {
        String string = this.label.getLabel();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setLabel(String string) {
        this.label.setLabel(string);
        this.invalidate();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
    }

    protected void showNotify() {
        this.label.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        this.label.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = this.checkboxSideSize(theme);
        int n6 = (n2 - n5) / 2;
        int n7 = Component.paintRect(graphics, theme, 0, n6, n5, n5, bl);
        if (this.checked) {
            n4 = theme.getHighlightColor();
            graphics.setColor(n4);
            n3 = n7 + 1;
            int n8 = n5 - 2 * n3;
            graphics.fillRect(n3, n6 + n3, n8, n8);
        }
        n4 = (int)((double)n5 * 1.5);
        n3 = n - n4;
        int[] nArray = this.label.getPreferredSize(theme, n3, n2);
        int n9 = nArray[1];
        int n10 = (n2 - n9) / 2;
        this.label.paint(graphics, theme, this.getScreen(), n4, n10, n3, n9, bl);
    }

    private int checkboxSideSize(Theme theme) {
        int n = theme.getFont().getHeight();
        int n2 = (int)((double)n * 0.7);
        return n2;
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int n3 = this.checkboxSideSize(theme);
        int[] nArray = this.label.getPreferredSize(theme, n - n3, n2);
        int n4 = Math.max(n3, nArray[1]);
        n4 += n4 % 2;
        return new int[]{n, n4};
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int n) {
        if (n > 0 || n == -8) {
            this.checked = !this.checked;
            this.repaint();
        }
        super.keyPressed(n);
    }

    public void pointerPressed(int n, int n2) {
        this.checked = !this.checked;
        this.repaint();
        super.pointerPressed(n, n2);
    }
}

