/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.Theme;

public abstract class Component {
    protected static final int HIGHLIGHTED_BORDER_WIDTH = 2;
    private int horizontalAlignment = 4;
    private boolean visible;
    private DeviceScreen screen;
    protected Component container;
    private int x;
    private int y;
    private int width;
    private int height;

    public final void paint(Graphics graphics, Theme theme, DeviceScreen deviceScreen, int n, int n2, int n3, int n4, boolean bl) {
        if (this.isShown()) {
            this.screen = deviceScreen;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            graphics.setClip(n5, n6, n7, n8 * 2);
            graphics.translate(n, n2);
            graphics.clipRect(0, 0, n3, n4 * 2);
            int n9 = graphics.getColor();
            graphics.setColor(theme.getFontColor());
            Font font = graphics.getFont();
            graphics.setFont(theme.getFont());
            int n10 = graphics.getStrokeStyle();
            graphics.setStrokeStyle(0);
            this.paintComponent(graphics, theme, n3, n4, bl);
            graphics.translate(-n, -n2);
            graphics.setClip(n5, n6, n7, n8);
            graphics.setColor(n9);
            graphics.setFont(font);
            graphics.setStrokeStyle(n10);
        }
    }

    protected abstract void paintComponent(Graphics var1, Theme var2, int var3, int var4, boolean var5);

    public final int[] getPreferredSize(Theme theme, int n, int n2) {
        int[] nArray = this.getPreferredComponentSize(theme, n, n2);
        if (nArray == null || nArray.length != 2) {
            throw new RuntimeException(this.getClass().getName() + ".getPreferredComponentSize must return an array of length 2");
        }
        return nArray;
    }

    protected abstract int[] getPreferredComponentSize(Theme var1, int var2, int var3);

    public boolean acceptsInput() {
        return false;
    }

    public DeviceScreen getScreen() {
        return this.screen;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n != 4 && n != 1 && n != 8) {
            throw new IllegalArgumentException("setHorizontalAlignment only takes Graphics.LEFT, HCENTER, or RIGHT");
        }
        this.horizontalAlignment = n;
    }

    public void visible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl) {
                this.showNotify();
            } else {
                this.hideNotify();
            }
        }
    }

    public boolean isShown() {
        return this.visible;
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void invalidate() {
        if (this.screen != null && this.screen instanceof Dialog) {
            Dialog dialog = (Dialog)this.screen;
            dialog.invalidate();
        }
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
    }

    public void repaint() {
        if (this.isShown() && this.screen != null) {
            if (this.height != 0) {
                this.screen.repaint(this.x, this.y, this.width, this.height);
            } else {
                this.screen.repaint();
            }
        }
    }

    public void keyPressed(int n) {
    }

    public void keyRepeated(int n) {
    }

    public void keyReleased(int n) {
    }

    public void pointerPressed(int n, int n2) {
    }

    public void pointerReleased(int n, int n2) {
    }

    public void pointerDragged(int n, int n2) {
    }

    protected static int paintRect(Graphics graphics, Theme theme, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7 = Math.min(n4 / 4, 5);
        if (bl) {
            n6 = theme.getHighlightColor();
            graphics.setColor(n6);
            graphics.drawRoundRect(0, n2, n3 - 1, n4 - 1, n7, n7);
        }
        n6 = theme.getBorderColor();
        graphics.setColor(n6);
        int n8 = n5 = 1;
        int n9 = n2 + n5;
        int n10 = 2 * n5;
        int n11 = n3 - n10;
        int n12 = n4 - n10;
        graphics.drawRect(n8, n9, n11 - 1, n12 - 1);
        int n13 = Math.max(2, n7 / 2);
        return n13;
    }
}

