/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;

public class HorizontalRule
extends Component {
    private int height = 1;
    private double widthPercentage = 0.9;

    public HorizontalRule() {
        this.setHorizontalAlignment(1);
    }

    public void setWidthOfScreen(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        this.widthPercentage = d;
    }

    public double getWidthOfScreen() {
        return this.widthPercentage;
    }

    public void setHeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.height = n;
        this.invalidate();
    }

    public int getHeight() {
        return this.height;
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        int n3;
        int n4 = (int)((double)n * this.widthPercentage);
        switch (this.getHorizontalAlignment()) {
            case 4: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = (n - n4) / 2;
                break;
            }
            default: {
                n3 = n - n4;
            }
        }
        int n5 = theme.getBorderColor();
        graphics.setColor(n5);
        graphics.drawLine(n3, 0, n3 + n4, n2 - 1);
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        return new int[]{n, this.height};
    }
}

