/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;

public class Label
extends Component {
    private String text;
    private String[] lines;
    private int widthForLines;
    private int height;
    private Font font;
    private int fontColor = -1;

    public Label() {
    }

    public Label(String string) {
        this.setLabel(string);
    }

    protected void invalidate() {
        this.lines = null;
        super.invalidate();
    }

    public String getLabel() {
        return this.text;
    }

    public synchronized void setLabel(String string) {
        this.text = string;
        this.invalidate();
    }

    public Font getFont() {
        return this.font;
    }

    private Font getFont(Theme theme) {
        if (this.font != null) {
            return this.font;
        }
        return theme.getFont();
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public int getFontColor() {
        return this.fontColor;
    }

    private int getFontColor(Theme theme) {
        if (this.fontColor >= 0) {
            return this.fontColor;
        }
        return theme.getFontColor();
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    protected synchronized void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        if (this.text != null) {
            Font font = this.getFont(theme);
            graphics.setFont(font);
            int n3 = this.getFontColor(theme);
            graphics.setColor(n3);
            int n4 = font.getHeight();
            int n5 = n4 / 2;
            int n6 = 0;
            int n7 = this.getHorizontalAlignment();
            int n8 = n7 | 0x10;
            int n9 = n7 == 4 ? 0 : (n7 == 1 ? n / 2 : n);
            if (this.lines == null || this.widthForLines != n) {
                this.lines = Label.breakIntoLines(font, this.text, n);
                this.widthForLines = n;
            }
            int n10 = graphics.getClipY();
            int n11 = n10 + graphics.getClipHeight();
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) {
                    n6 += n5;
                    continue;
                }
                if (n6 + n4 >= n10 && n6 <= n11) {
                    graphics.drawString(this.lines[i], n9, n6, n8);
                }
                n6 += n4;
            }
            this.height = n6;
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int n3 = 0;
        this.height = 0;
        if (this.text != null) {
            Font font = this.getFont(theme);
            if (this.lines == null || this.widthForLines != n) {
                this.lines = Label.breakIntoLines(font, this.text, n);
                this.widthForLines = n;
            }
            int n4 = font.getHeight();
            int n5 = n4 / 2;
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) {
                    this.height += n5;
                    continue;
                }
                int n6 = font.stringWidth(this.lines[i]);
                if (n6 > n3) {
                    n3 = n6;
                }
                this.height += n4;
            }
        }
        return new int[]{n3, this.height};
    }

    public int getHeight() {
        if (this.lines == null) {
            return super.getHeight();
        }
        return this.height;
    }

    public static String[] breakIntoLines(Font font, String string, int n) {
        String[] stringArray = null;
        if (string != null) {
            String string2;
            int n2;
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = font.charWidth('O');
            n -= n6;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                n2 = cArray[i] == '-' || cArray[i] == '/' ? 1 : 0;
                boolean bl = cArray[i] == ' ';
                boolean bl2 = cArray[i] == '\n';
                boolean bl3 = cArray[i] == '\r';
                boolean bl4 = bl2 || bl3;
                int n7 = font.charsWidth(cArray, n3, i - n3);
                if (bl4 || n7 > n) {
                    int n8 = bl4 ? i : (n4 > n3 ? n4 : i - 1);
                    string2 = string.substring(n3, n8).trim();
                    vector.addElement(string2);
                    if (bl4) {
                        n3 = n8 + 1;
                        if (bl2) {
                            vector.addElement(null);
                        }
                    } else {
                        n3 = n8;
                    }
                }
                if (n2 != 0) {
                    n4 = i + 1;
                }
                if (bl) {
                    n4 = n5 + 1;
                    continue;
                }
                n5 = i;
            }
            string2 = string.substring(n3).trim();
            vector.addElement(string2);
            stringArray = new String[vector.size()];
            Enumeration enumeration = vector.elements();
            n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }
}

