/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import javax.microedition.lcdui.Font;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Label;

public class LabelTest
extends TestCase {
    public LabelTest() {
    }

    public LabelTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new LabelTest("testBreakIntoLines", new TestMethod(){

            public void run(TestCase testCase) {
                ((LabelTest)testCase).testBreakIntoLines();
            }
        }));
        testSuite.addTest(new LabelTest("testGetDimensions", new TestMethod(){

            public void run(TestCase testCase) {
                ((LabelTest)testCase).testGetDimensions();
            }
        }));
        return testSuite;
    }

    public void testBreakIntoLines() {
        Font font = Font.getFont((int)32, (int)0, (int)0);
        String[] stringArray = Label.breakIntoLines(font, null, 1000);
        this.assertNull("Parsing null should return null", stringArray);
        String string = "test";
        stringArray = Label.breakIntoLines(font, string, 1000);
        this.assertEquals("Length of single line", 1L, stringArray.length);
        this.assertEquals("Contents of single line", string, stringArray[0]);
        String string2 = "The rain in Spain falls mainly on the plain.";
        stringArray = Label.breakIntoLines(font, string2, 100);
        this.assertTrue("Length of multi-line", stringArray.length > 1);
        for (int i = 0; i < stringArray.length; ++i) {
            this.assertTrue("Contents of multi-line contain:  " + stringArray[i], string2.indexOf(stringArray[i]) >= 0);
        }
        String string3 = "abcdefghijklmnopqrstuvwxyz0123456789";
        stringArray = Label.breakIntoLines(font, string3, 100);
        this.assertTrue("Length of multi-line one word", stringArray.length > 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        this.assertEquals("Contents of multi-line one word", string3, stringBuffer.toString());
        String string4 = "This is the first paragraph.\nParagraph number 2. Second sentence.";
        stringArray = Label.breakIntoLines(font, string4, 100);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                ++n;
                continue;
            }
            this.assertTrue("Contents of multi-paragraph contain:  " + stringArray[i], string4.indexOf(stringArray[i]) >= 0);
        }
        this.assertEquals("Paragraph separators seen", 1L, n);
    }

    public void testGetDimensions() {
        Theme theme = new Theme();
        int n = 100;
        int n2 = 100;
        Label label = new Label();
        int[] nArray = label.getPreferredSize(theme, n, n2);
        this.assertEquals("Empty label width", 0L, nArray[0]);
        this.assertEquals("Empty label height", 0L, nArray[1]);
        label = new Label();
        label.setLabel("Simple");
        nArray = label.getPreferredSize(theme, n, n2);
        int n3 = nArray[0];
        int n4 = nArray[1];
        this.assertTrue("Simple label width less than screen", n3 < n);
        this.assertTrue("Simple label height less than screen", n4 < n2);
        label = new Label();
        label.setLabel("This is a multi-paragraph string.\nFirst sentence of the second paragraph.");
        nArray = label.getPreferredSize(theme, n, n2);
        int n5 = nArray[0];
        int n6 = nArray[1];
        this.assertTrue("Multi-paragraph label width less than screen", n5 <= n);
        this.assertTrue("Multi-paragraph label width greater than simple", n5 > n3);
        this.assertTrue("Multi-paragraph label height greater than simple", n6 > n4);
    }
}

