/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Menu;
import org.j4me.ui.MenuItem;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class MenuOption
extends Component {
    private static final int HORIZONTAL_MARGIN = 3;
    private static final int VERTICAL_MARGIN = 3;
    private final MenuItem menuItem;
    private final DeviceScreen screen;
    private String screenText;
    private final Label text = new Label();
    private boolean submenu = false;

    public MenuOption(MenuItem menuItem) {
        if (menuItem == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        if (menuItem.getText() == null) {
            throw new IllegalArgumentException("choice text cannot be null");
        }
        this.menuItem = menuItem;
        this.screen = null;
    }

    public MenuOption(DeviceScreen deviceScreen) {
        if (deviceScreen == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.menuItem = null;
        this.screen = deviceScreen;
    }

    public MenuOption(String string, DeviceScreen deviceScreen) {
        if (deviceScreen == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.menuItem = null;
        this.screen = deviceScreen;
        this.screenText = string;
    }

    public MenuOption(Menu menu, boolean bl) {
        this(menu);
        this.submenu = bl;
    }

    public boolean isSubmenu() {
        return this.submenu;
    }

    public void setLabel(String string) {
        this.screenText = string;
        this.invalidate();
    }

    public String getLabel() {
        if (this.screenText != null) {
            return this.screenText;
        }
        String string = this.menuItem != null ? this.menuItem.getText() : this.screen.getTitle();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void select() {
        if (this.menuItem != null) {
            this.menuItem.onSelection();
        } else {
            this.screen.show();
        }
    }

    protected void showNotify() {
        this.text.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        this.text.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        int n3 = bl ? theme.getHighlightColor() : theme.getBackgroundColor();
        graphics.setColor(n3);
        graphics.fillRect(0, 0, n, n2);
        int[] nArray = this.getSubmenuIndicatorSize(theme, n, n2);
        int n4 = n - 9 - nArray[0];
        int[] nArray2 = this.getPreferredTextSize(theme, n4, n2);
        int n5 = nArray2[1];
        int n6 = (n2 - n5) / 2;
        int n7 = 3;
        this.paintText(graphics, theme, n7, n6, n4, n5, bl);
        if (this.submenu) {
            int n8 = nArray[1];
            if (n8 % 2 == 0) {
                --n8;
            }
            int n9 = nArray[0];
            int n10 = n - 3 - n9;
            int n11 = (n2 - n8) / 2;
            int n12 = bl ? theme.getMenuFontColor() : theme.getFontColor();
            graphics.setColor(n12);
            graphics.fillTriangle(n10, n11, n10, n11 + n8, n10 + n9, n11 + n8 / 2 + 1);
        }
    }

    protected void paintText(Graphics graphics, Theme theme, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = bl ? theme.getBackgroundColor() : theme.getFontColor();
        this.text.setFontColor(n5);
        this.text.paint(graphics, theme, this.getScreen(), n, n2, n3, n4, bl);
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int[] nArray = this.getSubmenuIndicatorSize(theme, n, n2);
        int n3 = n - 9 - nArray[0];
        int[] nArray2 = this.getPreferredTextSize(theme, n3, n2);
        int n4 = Math.max(nArray2[1], nArray[1]);
        return new int[]{n, n4 += 6};
    }

    protected int[] getPreferredTextSize(Theme theme, int n, int n2) {
        this.text.setLabel(this.getLabel());
        return this.text.getPreferredSize(theme, n, n2);
    }

    protected int[] getSubmenuIndicatorSize(Theme theme, int n, int n2) {
        Font font = theme.getFont();
        int n3 = font.getHeight() * 4 / 5;
        if (n3 % 2 == 0) {
            --n3;
        }
        int n4 = n3 / 2;
        return new int[]{n4, n3};
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int n) {
        if (n == -8) {
            this.select();
        }
        super.keyPressed(n);
    }

    public void pointerPressed(int n, int n2) {
        this.select();
        super.pointerPressed(n, n2);
    }
}

