/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;
import org.j4me.util.MathFunc;

public class ProgressBar
extends Component {
    private static final int ANIMATION_INTERVAL = 166;
    private double widthPercentage = 0.9;
    private double heightPercentage = 0.0;
    private Label label;
    private int value;
    private int max;
    private int spinnerHour;
    private Timer timer;

    public ProgressBar() {
        this.setHorizontalAlignment(1);
    }

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String string) {
        if (string == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(string);
        }
        this.invalidate();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n < 0 ? 0 : (n > this.max ? this.max : n);
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setMaxValue(int n) {
        if (n < 0) {
            this.max = 0;
        } else {
            this.stopTimer();
            this.max = n;
        }
        if (this.max < this.value) {
            this.value = this.max;
        }
    }

    public void setRelativeWidth(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        this.widthPercentage = d;
    }

    public double getRelativeWidth() {
        return this.widthPercentage;
    }

    public void setRelativeHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        this.heightPercentage = d;
        this.invalidate();
    }

    public double getRelativeHeight() {
        if (this.heightPercentage == 0.0) {
            if (this.max == 0) {
                return 2.0;
            }
            return 1.2;
        }
        return this.heightPercentage;
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        int n3 = 0;
        if (this.label != null) {
            int n4;
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(graphics, theme, this.getScreen(), 0, 0, n, n2, bl);
            n3 = n4 = this.label.getHeight();
            n2 -= n4;
        }
        if (this.max == 0) {
            this.startTimer();
            this.paintSpinner(graphics, theme, 0, n3, n, n2, bl);
        } else {
            this.paintBar(graphics, theme, 0, n3, n, n2, bl);
        }
    }

    protected void paintBar(Graphics graphics, Theme theme, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = (int)((double)n3 * this.getRelativeWidth());
        int n6 = this.getHorizontalAlignment();
        if (n6 == 1) {
            n += (n3 - n5) / 2;
        } else if (n6 == 8) {
            n += n3 - n5;
        }
        n3 = n5;
        double d = (double)this.value / (double)this.max;
        int n7 = (int)MathFunc.round((double)n3 * d);
        int n8 = theme.getBorderColor();
        int n9 = theme.getHighlightColor();
        Theme.gradientFill(graphics, n, n2, n7, n4, true, n8, n9, 0.5);
        int n10 = theme.getBackgroundColor();
        graphics.setColor(n10);
        graphics.fillRect(n + n7, n2, n + n3 - n7, n4);
        int n11 = theme.getBorderColor();
        graphics.setColor(n11);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    protected void paintSpinner(Graphics graphics, Theme theme, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = Math.min(n3, n4);
        int n6 = n5 / 6;
        int n7 = n6 / 2;
        double d = n5 / 3;
        int n8 = n5 / 2 - n7;
        int n9 = n + n8;
        int n10 = n2 + n8;
        int n11 = this.getHorizontalAlignment();
        if (n11 == 1) {
            n9 += (n3 - n5) / 2;
        } else if (n11 == 8) {
            n9 += n3 - n5;
        }
        int n12 = theme.getBackgroundColor();
        int n13 = theme.getBorderColor();
        int n14 = (n12 & 0xFF0000) >> 16;
        int n15 = (n12 & 0xFF00) >> 8;
        int n16 = n12 & 0xFF;
        int n17 = (n13 & 0xFF0000) >> 16;
        int n18 = (n13 & 0xFF00) >> 8;
        int n19 = n13 & 0xFF;
        n17 = (n17 - n14) / 12;
        n18 = (n18 - n15) / 12;
        n19 = (n19 - n16) / 12;
        for (int i = 1; i <= 12; ++i) {
            int n20 = ((i - 3) * -30 + 360) % 360;
            double d2 = Math.toRadians(n20);
            int n21 = (int)MathFunc.round(Math.cos(d2) * d);
            int n22 = (int)MathFunc.round(Math.sin(d2) * d) * -1;
            int n23 = (i - this.spinnerHour + 12) % 12;
            int n24 = n14 + n23 * n17;
            int n25 = n15 + n23 * n18;
            int n26 = n16 + n23 * n19;
            graphics.setColor(n24, n25, n26);
            graphics.fillRoundRect(n9 + n21, n10 + n22, n6, n6, n6, n6);
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int n3 = (int)((double)n * this.getRelativeWidth());
        int n4 = theme.getFont().getHeight();
        int n5 = (int)((double)n4 * this.getRelativeHeight());
        if (this.max == 0) {
            n5 += n5 % 6;
        }
        if (this.label != null) {
            int[] nArray = this.label.getPreferredComponentSize(theme, n, n2);
            n5 += nArray[1];
        }
        return new int[]{n3, n5};
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new SpinnerTask(), 0L, 166L);
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        this.stopTimer();
        super.hideNotify();
    }

    private final class SpinnerTask
    extends TimerTask {
        private SpinnerTask() {
        }

        public void run() {
            ProgressBar.this.spinnerHour = (ProgressBar.this.spinnerHour + 1) % 12;
            ProgressBar.this.repaint();
        }
    }
}

