/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Menu;
import org.j4me.ui.MenuItem;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;
import org.j4me.ui.components.TextBox;

public class RadioButton
extends Component {
    private Label label;
    protected Vector choices = new Vector();
    protected int selected;
    private TextBox box = new TextBox();

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String string) {
        if (string == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(string);
        }
        this.invalidate();
    }

    public int size() {
        return this.choices.size();
    }

    public String getString(int n) {
        String string = (String)this.choices.elementAt(n);
        return string;
    }

    public int append(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot append null choice");
        }
        this.choices.addElement(string);
        return this.choices.size() - 1;
    }

    public void insert(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot insert null choice");
        }
        this.choices.insertElementAt(string, n);
    }

    public void delete(int n) {
        this.choices.removeElementAt(n);
    }

    public void deleteAll() {
        this.choices.removeAllElements();
    }

    public void set(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot set null choice");
        }
        this.choices.setElementAt(string, n);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public String getSelectedValue() {
        return this.getString(this.selected);
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.choices.size()) {
            throw new IndexOutOfBoundsException("elementNum not a possible choice");
        }
        this.selected = n;
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        this.box.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        this.box.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        if (this.size() == 0) {
            throw new IllegalStateException("RadioButton has no values");
        }
        int n3 = 0;
        if (this.label != null) {
            int n4;
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(graphics, theme, this.getScreen(), 0, 0, n, n2, bl);
            n3 = n4 = this.label.getHeight();
            n2 -= n4;
        }
        String string = this.getSelectedValue();
        this.box.setString(string);
        this.box.paint(graphics, theme, this.getScreen(), 0, n3, n, n2, bl);
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int[] nArray = this.box.getPreferredSize(theme, n, n2);
        if (this.label != null) {
            int[] nArray2 = this.label.getPreferredComponentSize(theme, n, n2);
            nArray[1] = nArray[1] + nArray2[1];
        }
        return nArray;
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int n) {
        if (n == -1 || n == -6) {
            super.keyPressed(n);
        } else {
            this.select();
        }
    }

    public void pointerPressed(int n, int n2) {
        this.select();
    }

    protected void select() {
        Menu menu = new Menu(this.getLabel(), this.getScreen());
        Enumeration enumeration = this.choices.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RadioItem radioItem = new RadioItem(string, n);
            menu.appendMenuOption(radioItem);
            ++n;
        }
        int n2 = this.getSelectedIndex();
        menu.setSelected(n2);
        menu.show();
    }

    private final class RadioItem
    implements MenuItem {
        private final String text;
        private final int index;

        public RadioItem(String string, int n) {
            this.text = string;
            this.index = n;
        }

        public String getText() {
            return this.text;
        }

        public void onSelection() {
            RadioButton.this.setSelectedIndex(this.index);
            DeviceScreen deviceScreen = RadioButton.this.getScreen();
            deviceScreen.show();
            deviceScreen.repaint();
        }
    }
}

