/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.j4me.ui.DeviceScreen;
import org.j4me.ui.Theme;
import org.j4me.ui.UIManager;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class TextBox
extends Component {
    private static final int DEFAULT_MAX_CHARS = 128;
    private static final int TEXT_OFFSET = 2;
    private Label label;
    private String contents;
    private int maxSize = 128;
    private int constraints = 0;

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getLabel();
    }

    public void setLabel(String string) {
        if (string == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new Label();
            }
            this.label.setLabel(string);
        }
        this.invalidate();
    }

    public String getString() {
        if (this.contents == null) {
            return "";
        }
        return this.contents;
    }

    public void setString(String string) {
        this.contents = string;
        this.invalidate();
    }

    public void setForAnyText() {
        this.setRestrictiveConstraint(0);
    }

    public void setForNumericOnly() {
        this.setRestrictiveConstraint(2);
    }

    public void setForPhoneNumber() {
        this.setRestrictiveConstraint(3);
    }

    public boolean isPhoneNumber() {
        boolean bl = (this.constraints & 3) != 0;
        return bl;
    }

    private void setRestrictiveConstraint(int n) {
        this.constraints &= 0xFFFF;
        this.constraints |= n;
        this.invalidate();
    }

    public void setPassword(boolean bl) {
        this.setModifierConstraint(65536, bl);
    }

    public boolean isPassword() {
        boolean bl = (this.constraints & 0x10000) != 0;
        return bl;
    }

    private void setModifierConstraint(int n, boolean bl) {
        this.constraints = bl ? (this.constraints |= n) : (this.constraints &= ~n);
        this.invalidate();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n < this.size()) {
            this.contents = this.contents.substring(0, n);
            this.repaint();
        }
        this.maxSize = n;
    }

    public int size() {
        int n = 0;
        if (this.contents != null) {
            n = this.contents.length();
        }
        return n;
    }

    protected void paintComponent(Graphics graphics, Theme theme, int n, int n2, boolean bl) {
        int n3;
        int n4 = 0;
        if (this.label != null) {
            this.label.setHorizontalAlignment(this.getHorizontalAlignment());
            this.label.paint(graphics, theme, this.getScreen(), 0, 0, n, n2, bl);
            n4 = n3 = this.label.getHeight();
            n2 -= n3;
        }
        n3 = Component.paintRect(graphics, theme, 0, n4, n, n2, bl);
        if (this.contents != null) {
            int n5 = n3 += 2;
            int n6 = n4 + n3;
            int n7 = 20;
            graphics.clipRect(n5, n6, n -= 2 * n3, n2 -= 2 * n3);
            graphics.setColor(theme.getFontColor());
            String string = this.contents;
            if (this.isPassword()) {
                int n8 = this.contents.length();
                StringBuffer stringBuffer = new StringBuffer(n8);
                for (int i = 0; i < n8; ++i) {
                    stringBuffer.append('*');
                }
                string = stringBuffer.toString();
            } else if (this.isPhoneNumber() && string.length() == 10) {
                StringBuffer stringBuffer = new StringBuffer(15);
                stringBuffer.append("(");
                stringBuffer.append(string.substring(0, 3));
                stringBuffer.append(") ");
                stringBuffer.append(string.substring(3, 6));
                stringBuffer.append("-");
                stringBuffer.append(string.substring(6, 10));
                string = stringBuffer.toString();
            }
            graphics.drawString(string, n5, n6, n7);
        }
    }

    protected int[] getPreferredComponentSize(Theme theme, int n, int n2) {
        int n3 = theme.getFont().getHeight();
        int n4 = n3 + 8;
        if (this.label != null) {
            int[] nArray = this.label.getPreferredComponentSize(theme, n, n2);
            n4 += nArray[1];
        }
        return new int[]{n, n4};
    }

    protected void showNotify() {
        if (this.label != null) {
            this.label.visible(true);
        }
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.label != null) {
            this.label.visible(false);
        }
        super.hideNotify();
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int n) {
        if (n > 0 || n == -8) {
            this.select();
        }
    }

    public void pointerPressed(int n, int n2) {
        this.select();
    }

    protected void select() {
        DeviceScreen deviceScreen = UIManager.getScreen();
        String string = this.getLabel();
        String string2 = this.getString();
        int n = this.getMaxSize();
        TextInput textInput = new TextInput(deviceScreen, this, string, string2, n, this.constraints);
        Display display = UIManager.getDisplay();
        display.setCurrent((Displayable)textInput);
    }

    private final class TextInput
    extends javax.microedition.lcdui.TextBox
    implements CommandListener {
        private final Command cancel;
        private final Command ok;
        private final DeviceScreen parent;
        private final TextBox component;

        public TextInput(DeviceScreen deviceScreen, TextBox textBox2, String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
            this.parent = deviceScreen;
            this.component = textBox2;
            Theme theme = UIManager.getTheme();
            String string3 = theme.getMenuTextForCancel();
            this.cancel = new Command(string3, 3, 1);
            this.addCommand(this.cancel);
            String string4 = theme.getMenuTextForOK();
            this.ok = new Command(string4, 4, 2);
            this.addCommand(this.ok);
            this.setCommandListener(this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.ok) {
                String string = this.getString();
                this.component.setString(string);
            }
            this.parent.show();
            this.parent.repaint();
        }
    }
}

